/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.metadata.AbstractDataModelMetadata;
import kd.bos.datamodel.metadata.DMMetaCategory;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.PhysicalDataModelTemplate;
import kd.bos.designer.utils.DataModelUtils;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataModelDesignerData {
    private static final String DATAMODELDESIGNERDATA_SAVE = "DataModelDesignerData_save";
    private static final String DATAMODEL_DESIGNERDATA_SUBMIT = "DataModelDesignerData_submit";
    private static final String SUCCESS = "success";
    private static final String SAVE_SUCCESS = "saveSuccess";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final Log log = LogFactory.getLog(DataModelDesignerData.class);

    public Map<String, Object> save(Map<String, Object> content, Map<String, Object> oldContent, String modelId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
        PDMEntityMetadata pdmMetadata = writer.convertToMetadata(content);
        boolean saveSuccess = true;
        String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DataModelDesignerData_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        try (TXHandle tx = TX.required((String)DATAMODELDESIGNERDATA_SAVE);){
            try {
                List designMetaList = writer.convertToDeltaDesignMeta(pdmMetadata);
                writer.save(designMetaList);
                DataModelUtils.addLog("bos_dm_modellist", "\u4fdd\u5b58", String.format("\u4fdd\u5b58\u6570\u636e\u6a21\u578b%s", pdmMetadata.getNumber()));
            }
            catch (Exception e) {
                tx.markRollback();
                saveSuccess = false;
                msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"DataModelDesignerData_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), e.getMessage());
            }
        }
        result.put(SUCCESS, saveSuccess);
        result.put("message", msg);
        return result;
    }

    public Map<String, Object> submit(Map<String, Object> content) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
        PDMEntityMetadata pdmMetadata = writer.convertToMetadata(content);
        boolean success = true;
        String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"DataModelDesignerData_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        try (TXHandle tx = TX.requiresNew((String)DATAMODEL_DESIGNERDATA_SUBMIT);){
            try {
                List designMetaList = writer.convertToMDesignMeta(pdmMetadata);
                writer.save(designMetaList);
                writer.deleteDeltaData(pdmMetadata.getId());
            }
            catch (Exception e) {
                tx.markRollback();
                success = false;
                msg = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c%s", (String)"DataModelDesignerData_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), e.getMessage());
                log.error((Throwable)e);
            }
            result.put(SUCCESS, success);
            result.put("message", msg);
        }
        return result;
    }

    public PDMEntityMetadata createBlankMetadata(Map<String, Object> parameters) {
        PDMEntityMetadata metadata;
        String key = (String)parameters.get("key");
        String modelId = (String)parameters.get("modelId");
        String number = (String)parameters.get("number");
        Object objName = parameters.get("name");
        Object objDescription = parameters.get("description");
        String bizAppId = (String)parameters.get("bizAppId");
        String product = (String)parameters.get("product");
        String currentIsv = ISVService.getISVInfo().getId();
        String parentId = (String)parameters.get("parentId");
        String devType = (String)parameters.get("devType");
        devType = StringUtils.isBlank((CharSequence)devType) ? "0" : devType;
        boolean isExt = "2".equals(devType);
        LocaleString name = this.formatLocaleString(objName);
        LocaleString description = this.formatLocaleString(objDescription);
        if (isExt) {
            IPDMDesignMetaReader dataModelReader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
            metadata = (PDMEntityMetadata)dataModelReader.loadBaseMeta(parentId, DMMetaCategory.MDataModel);
            PDMDiagramMetadata pdmDiagramMetadata = (PDMDiagramMetadata)dataModelReader.loadBaseMeta(parentId, DMMetaCategory.MDiagram);
            if (pdmDiagramMetadata != null) {
                metadata.setPdmDiagramMetadata(pdmDiagramMetadata);
            }
            metadata.setMasterId(parentId);
            metadata.setDevType(devType);
        } else {
            PhysicalDataModelTemplate template = new PhysicalDataModelTemplate();
            metadata = template.getDataModelMetadata();
            List packageApList = metadata.getPackageAps();
            if (packageApList != null) {
                int i = 0;
                for (DMPackageAp packageAp : packageApList) {
                    packageAp.setId(DB.genStringId((String)""));
                    if (i > 0) {
                        packageAp.setKey(String.format("package%s", i));
                        packageAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u5305%s", (String)"DataModelDesignerData_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), i)));
                    } else {
                        packageAp.setKey("package");
                        packageAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u5305", (String)"DataModelDesignerData_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), new Object[0])));
                        this.bindDiagramMetadata(metadata, name, packageAp.getId());
                    }
                    ++i;
                }
            }
        }
        metadata.setId(modelId);
        metadata.setName(name);
        metadata.setNumber(number);
        metadata.setIsv(currentIsv);
        metadata.setBizappId(bizAppId);
        metadata.setProduct(product);
        metadata.setCreator(RequestContext.get().getCurrUserId());
        metadata.setCreatedDate(new Date());
        metadata.setDescription(description);
        metadata.bindDiagramMetadata();
        this.resetParentId(metadata, isExt);
        return metadata;
    }

    private void resetParentId(PDMEntityMetadata metadata, boolean isExt) {
        if (!isExt) {
            return;
        }
        PDMDesignMetaDao.resetParentId((AbstractDataModelMetadata)metadata, (String)metadata.getId());
        if (metadata.getPdmDiagramMetadata() != null) {
            PDMDesignMetaDao.resetParentId((AbstractDataModelMetadata)metadata.getPdmDiagramMetadata(), (String)metadata.getId());
        }
    }

    private LocaleString formatLocaleString(Object objName) {
        LocaleString name = null;
        if (objName instanceof LocaleString) {
            name = (LocaleString)objName;
        } else if (objName instanceof OrmLocaleValue) {
            HashMap<String, String> localNameMap = new HashMap<String, String>(16);
            for (String loId : ((OrmLocaleValue)objName).keySet()) {
                localNameMap.put(loId, ((OrmLocaleValue)objName).get((Object)loId));
            }
            name = LocaleString.fromMap(localNameMap);
        } else if (objName instanceof String) {
            name = new LocaleString((String)objName);
        }
        return name;
    }

    private void bindDiagramMetadata(PDMEntityMetadata metadata, LocaleString name, String packageId) {
        List physicalDiagramList;
        PDMDiagramMetadata pdmDiagramMetadata = metadata.getPdmDiagramMetadata();
        if (pdmDiagramMetadata == null) {
            pdmDiagramMetadata = new PDMDiagramMetadata();
        }
        if ((physicalDiagramList = pdmDiagramMetadata.getPhysicalDiagramAps()).isEmpty()) {
            PhysicalDiagram physicalDiagram = new PhysicalDiagram();
            physicalDiagram.setParentId(packageId);
            physicalDiagram.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u56fe", (String)"DataModelDesignerData_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), new Object[0])));
            physicalDiagram.setId("physicaldiagram");
            physicalDiagram.setKey("physicaldiagram");
            physicalDiagramList.add(physicalDiagram);
        }
    }
}

