/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.metadata.exception.DataModelValidatorInfo;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.model.validator.IValidateResult;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResult;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.PDMValidator;
import kd.bos.datamodel.pdm.model.Table;

public class DataModelValidator {
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private PDMEntityMetadata pdmMetadata;

    public DataModelValidator() {
    }

    public DataModelValidator(PDMEntityMetadata pdmMetadata) {
        this.pdmMetadata = pdmMetadata;
    }

    public PDMEntityMetadata getPdmMetadata() {
        return this.pdmMetadata;
    }

    public void setPdmMetadata(PDMEntityMetadata pdmMetadata) {
        this.pdmMetadata = pdmMetadata;
    }

    public void validatorDataModel() {
        if (this.pdmMetadata.getPackageAps().isEmpty()) {
            return;
        }
        this.checkPackage();
        this.checkPhysicalDiagram();
    }

    private void checkPackage() {
        List packageAps = this.pdmMetadata.getPackageAps();
        HashMap<String, DMPackageAp> packageKeys = new HashMap<String, DMPackageAp>(packageAps.size());
        for (DMPackageAp packageAp : packageAps) {
            String packageKey = packageAp.getKey();
            if (StringUtils.isNotBlank((CharSequence)packageKey) && (packageKeys.containsKey(packageKey.toUpperCase(Locale.ENGLISH)) || packageKeys.containsKey(packageKey.toLowerCase(Locale.ENGLISH)))) {
                this.checkPackage(packageAp);
            } else {
                packageKeys.put(packageKey, packageAp);
            }
            List tableAps = packageAp.getTableAps();
            HashMap<String, TableAp> tableNames = new HashMap<String, TableAp>(tableAps.size());
            HashMap<String, TableAp> tableIds = new HashMap<String, TableAp>(tableAps.size());
            for (TableAp tableAp : tableAps) {
                this.checkTable(tableAp);
                String tableName = tableAp.getTableName();
                String tableKey = tableAp.getKey();
                if (tableName != null && (tableNames.containsKey(tableName.toUpperCase(Locale.ENGLISH)) || tableNames.containsKey(tableName.toLowerCase(Locale.ENGLISH)))) {
                    this.checkTableName(tableAp);
                } else {
                    tableNames.put(tableAp.getTableName(), tableAp);
                }
                if (tableKey != null && (tableIds.containsKey(tableKey.toUpperCase(Locale.ENGLISH)) || tableIds.containsKey(tableKey.toLowerCase(Locale.ENGLISH)))) {
                    this.checkTableKey(tableAp);
                    continue;
                }
                tableIds.put(tableAp.getKey(), tableAp);
            }
        }
    }

    private void checkPackage(DMPackageAp packageAp) {
        String key = packageAp.getKey();
        DataModelValidatorInfo validatorInfo = new DataModelValidatorInfo();
        validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
        validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u5305", (String)"DataModelValidator_11", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        validatorInfo.setValidatorNumber(key);
        validatorInfo.setValidatorName(packageAp.getName().getLocaleValue());
        String tbName = ResManager.loadKDString((String)"\u6807\u8bc6", (String)"TablePlugin_10", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        String msg = String.format(ResManager.loadKDString((String)"\u5305\u201c%1$s\u201d \u503c \u201c%2$s\u201d \u6216\u8005 \u201c%3$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DataModelValidator_16", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tbName, key.toLowerCase(Locale.ENGLISH), key.toUpperCase(Locale.ENGLISH));
        validatorInfo.setResult(msg);
        validatorInfo.setLevel(2);
        this.pdmMetadata.getValidatorInfos().add(validatorInfo);
    }

    private void checkPhysicalDiagram() {
        PDMDiagramMetadata pdmDiagramMetadata = this.pdmMetadata.getPdmDiagramMetadata();
        if (pdmDiagramMetadata != null) {
            List physicalDiagramAps = pdmDiagramMetadata.getPhysicalDiagramAps();
            HashMap<String, PhysicalDiagram> diagramMap = new HashMap<String, PhysicalDiagram>(physicalDiagramAps.size());
            for (PhysicalDiagram diagram : physicalDiagramAps) {
                String key = diagram.getKey();
                if (StringUtils.isNotBlank((CharSequence)key) && (diagramMap.containsKey(key.toUpperCase(Locale.ENGLISH)) || diagramMap.containsKey(key.toLowerCase(Locale.ENGLISH)))) {
                    DataModelValidatorInfo validatorInfo = new DataModelValidatorInfo();
                    validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
                    validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u6a21\u578b\u56fe", (String)"DataModelValidator_12", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                    validatorInfo.setValidatorNumber(key);
                    validatorInfo.setValidatorName(diagram.getName().getLocaleValue());
                    String tbName = ResManager.loadKDString((String)"\u6807\u8bc6", (String)"TablePlugin_10", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
                    String msg = String.format(ResManager.loadKDString((String)"\u6a21\u578b\u56fe\u201c%1$s\u201d \u503c \u201c%2$s\u201d \u6216\u8005 \u201c%3$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DataModelValidator_15", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tbName, key.toLowerCase(Locale.ENGLISH), key.toUpperCase(Locale.ENGLISH));
                    validatorInfo.setResult(msg);
                    validatorInfo.setLevel(2);
                    this.pdmMetadata.getValidatorInfos().add(validatorInfo);
                    continue;
                }
                diagramMap.put(diagram.getKey(), diagram);
            }
        }
    }

    private void checkTableName(TableAp tableAp) {
        DataModelValidatorInfo validatorInfo = new DataModelValidatorInfo();
        validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
        validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        validatorInfo.setValidatorNumber(tableAp.getKey());
        validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
        String tbName = ResManager.loadKDString((String)"\u8868\u540d", (String)"TablePlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        String msg = String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d \u503c \u201c%2$s\u201d \u6216\u8005 \u201c%3$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DataModelValidator_14", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tbName, tableAp.getTableName().toLowerCase(Locale.ENGLISH), tableAp.getTableName().toUpperCase(Locale.ENGLISH));
        validatorInfo.setResult(msg);
        validatorInfo.setLevel(2);
        this.pdmMetadata.getValidatorInfos().add(validatorInfo);
    }

    private void checkTableKey(TableAp tableAp) {
        DataModelValidatorInfo validatorInfo = new DataModelValidatorInfo();
        validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
        validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        validatorInfo.setValidatorNumber(tableAp.getKey());
        validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
        String tbName = ResManager.loadKDString((String)"\u6807\u8bc6", (String)"TablePlugin_10", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        String msg = String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d \u503c \u201c%2$s\u201d \u6216\u8005 \u201c%3$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DataModelValidator_14", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tbName, tableAp.getKey().toLowerCase(Locale.ENGLISH), tableAp.getKey().toUpperCase(Locale.ENGLISH));
        validatorInfo.setResult(msg);
        validatorInfo.setLevel(2);
        this.pdmMetadata.getValidatorInfos().add(validatorInfo);
    }

    private void checkTable(TableAp tableAp) {
        Table table;
        DataModelValidatorInfo validatorInfo = new DataModelValidatorInfo();
        try {
            table = (Table)tableAp.createDMO();
        }
        catch (Exception e) {
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(e.getMessage());
            validatorInfo.setLevel(2);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
            return;
        }
        if (table == null) {
            return;
        }
        PDMValidator validator = new PDMValidator();
        validator.setNoModifiedErrorLevel(MessageType.Warn);
        ArrayList<Table> tableList = new ArrayList<Table>();
        tableList.add(table);
        List list = validator.validate(tableList);
        ArrayList validate = new ArrayList();
        for (IValidateResult result : list) {
            if (!(result instanceof ValidateResult)) continue;
            validate.addAll(((ValidateResult)result).getResultItems());
        }
        for (ValidateResultItem item : validate) {
            if (item.getMessageType() == MessageType.Info) continue;
            validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(item.getMessage());
            if (item.getMessageType() == MessageType.Warn) {
                validatorInfo.setLevel(1);
            } else {
                validatorInfo.setLevel(2);
            }
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
    }

    private void checkColumn(TableAp tableAp) {
        DataModelValidatorInfo validatorInfo;
        List columns = tableAp.getColumns();
        if (columns.isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"Table\uff1a%s \u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataModelValidator_9", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName());
            validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(msg);
            validatorInfo.setLevel(2);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
        if (columns.size() > 80) {
            String message = String.format(ResManager.loadKDString((String)"Table\uff1a%s \u4e0d\u5e94\u8d85\u8fc780\u4e2a\u5b57\u6bb5\u3002", (String)"DataModelValidator_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName());
            validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(message);
            validatorInfo.setLevel(1);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
        for (ColumnAp columnAp : columns) {
            if (columnAp.getColunmType() != DataType.DECIMAL.getValue() && columnAp.getColunmType() != DataType.INT.getValue() && columnAp.getColunmType() != DataType.BIGINT.getValue() && columnAp.getColunmType() != DataType.SMALLINT.getValue() || columnAp.isNotNull()) continue;
            validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(columnAp.getName().getLocaleValue());
            validatorInfo.setLevel(1);
            String message = columnAp.getColumnDef() == null ? String.format(ResManager.loadKDString((String)"Table: %s\u7684\u5217 %s\u6570\u503c\u7c7b\u578b\u5e94\u5b9a\u4e49\u4e3a NOT NULL\uff0c\u5e76\u4e14\u5fc5\u987b\u6307\u5b9a\u9ed8\u8ba4\u503c\u3002", (String)"DataModelValidator_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName(), columnAp.getColumnName()) : String.format(ResManager.loadKDString((String)"Table: %s\u7684\u5217 %s\u6570\u503c\u7c7b\u578b\u5e94\u5b9a\u4e49\u4e3a NOT NULL\u3002", (String)"DataModelValidator_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName(), columnAp.getColumnName());
            validatorInfo.setResult(message);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
    }

    private void checkIndex(TableAp tableAp) {
        DataModelValidatorInfo validatorInfo;
        String message;
        HashMap columnApMap = new HashMap();
        tableAp.getColumns().forEach(columnAp -> columnApMap.put(columnAp.getId(), columnAp));
        List indexAps = tableAp.getIndexs();
        if (indexAps.isEmpty()) {
            message = String.format(ResManager.loadKDString((String)"Table\uff1a%s \u672a\u5b9a\u4e49\u7d22\u5f15\u3002", (String)"DataModelValidator_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName());
            validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(message);
            validatorInfo.setLevel(1);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
        if (indexAps.size() > 8) {
            message = String.format(ResManager.loadKDString((String)"Table\uff1a%s\u7d22\u5f15\u4e2a\u6570\u4e0d\u5e94\u8d85\u8fc78\u4e2a\u3002", (String)"DataModelValidator_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName());
            validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(message);
            validatorInfo.setLevel(1);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
        HashMap<String, String> columnIndexMap = new HashMap<String, String>(16);
        for (IndexAp indexAp : indexAps) {
            String message2;
            List indexColumnAps = indexAp.getIndexColumnAps();
            if (indexColumnAps.isEmpty()) {
                message2 = String.format(ResManager.loadKDString((String)"Table:%s \u7d22\u5f15:%s \u672a\u5b9a\u4e49\u5217\u3002", (String)"DataModelValidator_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName(), indexAp.getIndexName());
                validatorInfo = new DataModelValidatorInfo();
                validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
                validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                validatorInfo.setValidatorNumber(tableAp.getKey());
                validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
                validatorInfo.setResult(message2);
                validatorInfo.setLevel(2);
                this.pdmMetadata.getValidatorInfos().add(validatorInfo);
            }
            if (indexColumnAps.size() > 5) {
                message2 = String.format(ResManager.loadKDString((String)"Table:%s \u7d22\u5f15:%s \u5b9a\u4e49\u7684\u5217\u4e0d\u5e94\u8d85\u8fc75\u4e2a\u3002", (String)"DataModelValidator_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName(), indexAp.getIndexName());
                validatorInfo = new DataModelValidatorInfo();
                validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
                validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                validatorInfo.setValidatorNumber(tableAp.getKey());
                validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
                validatorInfo.setResult(message2);
                validatorInfo.setLevel(2);
                this.pdmMetadata.getValidatorInfos().add(validatorInfo);
            }
            for (RefColumnAp refColumnAp : indexColumnAps) {
                ColumnAp columnAp2 = (ColumnAp)columnApMap.get(refColumnAp.getRefId());
                if (columnAp2 == null) continue;
                String indexName = (String)columnIndexMap.get(columnAp2.getColumnName());
                if (indexName != null && indexName.equals(indexAp.getIndexName())) {
                    String message3 = String.format(ResManager.loadKDString((String)"Table\uff1a%s \u7d22\u5f15:%s\u5b9a\u4e49\u7684\u5217%s\u4e0e\u7d22\u5f15%s\u5b9a\u4e49\u5217\u6709\u91cd\u590d\uff0c\u9700\u786e\u8ba4\u662f\u5426\u5408\u9002\u3002", (String)"DataModelValidator_7", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName(), indexAp.getIndexName(), columnAp2.getColumnName(), indexName);
                    validatorInfo = new DataModelValidatorInfo();
                    validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
                    validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                    validatorInfo.setValidatorNumber(tableAp.getKey());
                    validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
                    validatorInfo.setResult(message3);
                    validatorInfo.setLevel(1);
                    this.pdmMetadata.getValidatorInfos().add(validatorInfo);
                    continue;
                }
                columnIndexMap.put(columnAp2.getColumnName(), indexAp.getIndexName());
            }
        }
    }

    private void checkPrimary(TableAp tableAp) {
        PrimaryKeyAp primaryKey = tableAp.getPrimaryKey();
        if (primaryKey == null || primaryKey.getPkColumnList().isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"Table\uff1a%s \u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\u3002", (String)"DataModelValidator_8", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), tableAp.getTableName());
            DataModelValidatorInfo validatorInfo = new DataModelValidatorInfo();
            validatorInfo.setDataModelNumber(this.pdmMetadata.getNumber());
            validatorInfo.setValidatorType(ResManager.loadKDString((String)"\u8868", (String)"DataModelValidator_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            validatorInfo.setValidatorNumber(tableAp.getKey());
            validatorInfo.setValidatorName(tableAp.getName().getLocaleValue());
            validatorInfo.setResult(msg);
            validatorInfo.setLevel(2);
            this.pdmMetadata.getValidatorInfos().add(validatorInfo);
        }
    }
}

