/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;

public class AbstractDataModelImportPlugin
extends AbstractFormPlugin
implements UploadListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AbstractDataModelImportPlugin.class);
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    protected static final String URLARR = "urlarr";
    private static final String BIZAPP = "bizapp";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"import", "next"});
        IAttachmentPanel dbspanel = (IAttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
        BasedataEdit bizApp = (BasedataEdit)this.getView().getControl(BIZAPP);
        if (bizApp != null) {
            bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "import": {
                Object bizAppObj = this.getModel().getValue(BIZAPP);
                if (!(bizAppObj instanceof DynamicObject)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5173\u8054\u6240\u5c5e\u5e94\u7528\u3002", (String)"AbstractDataModelImportPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (this.isHaveAttachment()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u9875\u9762\u3002", (String)"AbstractDataModelImportPlugin_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.confirm(null);
            }
        }
    }

    protected boolean isHaveAttachment() {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachmentData = panel.getAttachmentData();
        return attachmentData.isEmpty();
    }

    public void upload(UploadEvent arg0) {
        if (arg0 == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"BizImportPagePlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object[] args = arg0.getUrls();
        if (args == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"BizImportPagePlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (int n = 0; n < args.length; ++n) {
            Map urlMsg = (Map)args[n];
            String urlName = (String)urlMsg.get("name");
            String url = (String)urlMsg.get("url");
            JSONArray urlArr = new JSONArray();
            JSONObject urlObj = new JSONObject();
            urlObj.put(urlName, (Object)url);
            urlArr.add((Object)urlObj);
            JSONArray urlCaheArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
            if (urlCaheArr != null && urlCaheArr.size() > 0) {
                for (int i = 0; i < urlCaheArr.size(); ++i) {
                    JSONObject urlCatchObj = (JSONObject)urlCaheArr.get(i);
                    if (!urlCatchObj.containsKey((Object)urlName)) continue;
                    urlCaheArr.remove((Object)urlCatchObj);
                }
                urlCaheArr.addAll((Collection)urlArr);
                this.getPageCache().put(URLARR, urlCaheArr.toJSONString());
                continue;
            }
            this.getPageCache().put(URLARR, urlArr.toJSONString());
        }
    }

    public void remove(UploadEvent arg0) {
        Map urlMsg = (Map)arg0.getUrls()[0];
        String urlName = (String)urlMsg.get("name");
        JSONArray urlCacheArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        if (urlCacheArr != null && urlCacheArr.size() > 0) {
            for (int i = 0; i < urlCacheArr.size(); ++i) {
                JSONObject urlCatchObj = (JSONObject)urlCacheArr.get(i);
                if (!urlCatchObj.containsKey((Object)urlName)) continue;
                urlCacheArr.remove((Object)urlCatchObj);
            }
            this.getPageCache().put(URLARR, urlCacheArr.toJSONString());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (BIZAPP.equals(arg0.getProperty().getName())) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            QFilter filter = new QFilter("masterid", "=", (Object)" ");
            filters.add(filter);
            filters.add(new QFilter("bizcloud", "!=", (Object)"2HGKCE94QELW"));
            filters.add(new QFilter("id", "!=", (Object)"2HGKTA7HH43C"));
            param.getListFilterParameter().getQFilters().addAll(filters);
        }
    }

    protected Map<String, Object> confirm(Map<String, Object> param) {
        JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (urlArr != null && urlArr.size() > 0) {
            this.getView().showLoading(new LocaleString(" "));
            ArrayList<String> errorList = new ArrayList<String>(10);
            ArrayList<String> successList = new ArrayList<String>(10);
            String modelId = "";
            String number = null;
            for (int i = 0; i < urlArr.size(); ++i) {
                JSONObject urlObj = (JSONObject)urlArr.get(i);
                for (String urlName : urlObj.keySet()) {
                    String url = urlObj.getString(urlName);
                    try {
                        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        InputStream inputStream = cache.getInputStream(url);
                        Throwable throwable = null;
                        try {
                            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                            Throwable throwable2 = null;
                            try {
                                Map<String, Object> message = this.doImport(zipInputStream, param);
                                if (message != null) {
                                    if (message.get("error") != null) {
                                        errorList.add((String)message.get("error"));
                                    } else {
                                        successList.add((String)message.get("success"));
                                    }
                                }
                                modelId = message == null ? "" : (String)message.get("modelId");
                                number = message == null ? "" : (String)message.get("number");
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (zipInputStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        zipInputStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                zipInputStream.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
            map.put("modelId", modelId);
            map.put("number", number);
            this.getView().hideLoading();
            if (errorList.isEmpty()) {
                map.put("success", true);
                this.getView().returnDataToParent(map);
                this.getView().close();
            } else if (successList.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"AbstractDataModelImportPlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), SerializationUtils.toJsonString(errorList)));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u90e8\u5206\u5931\u8d25\uff0c\u6210\u529f\uff1a%s\uff1b\u5931\u8d25\uff1a%s", (String)"AbstractDataModelImportPlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), SerializationUtils.toJsonString(successList), SerializationUtils.toJsonString(errorList)));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9700\u8981\u5b89\u88c5\u7684\u90e8\u7f72\u5305\u3002", (String)"BizImportPagePlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        }
        return map;
    }

    protected boolean check(ZipEntry zEntry, Map<String, Object> res) {
        if (zEntry == null) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BizImportPagePlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Map<String, Object> doImport(ZipInputStream zipInputStream, Map<String, Object> param) throws IOException {
        return new HashMap<String, Object>(16);
    }

    private void writeLog(DataModelDesignMeta designMeta) {
        try {
            MetadataLogService metadataLogService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58PDM\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a", (Throwable)e);
        }
    }
}

