/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ColumnDefaultPlugin
extends AbstractFormPlugin {
    private static final String COLUMN_TYPE = "columntype";
    private static final String VARCHAR = "varchar";
    private static final String INTEGER = "integer";
    private static final String BIGINT = "bigint";
    private static final String DECIMAL = "decimal";
    private static final String CURRENT_KEY = "currentKey";
    private static final String VARCHAR_LIST = "varcharlist";
    private static final String DATE_LIST = "datelist";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam(COLUMN_TYPE);
        String value = (String)parameter.getCustomParam("columnValue");
        int precision = 0;
        Object param = parameter.getCustomParam("precision");
        if (param != null) {
            precision = (Integer)param;
        }
        this.initFieldVisible(type, value, precision);
    }

    private void initFieldVisible(String type, String value, int precision) {
        Object fileValue = value;
        DataType currentType = DataType.valueOf((int)Integer.parseInt(type));
        String currentKey = this.getFileKey(currentType);
        if (this.isNumberType(type) && StringUtils.isNotBlank((CharSequence)value)) {
            try {
                fileValue = new BigDecimal(value).setScale(precision, 4);
            }
            catch (NumberFormatException e) {
                this.getView().showErrorNotification("\u6570\u503c\u7c7b\u578b\u9ed8\u8ba4\u503c\u6709\u8bef\u3002");
                fileValue = 0;
            }
        }
        if (currentType == DataType.VARCHAR) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VARCHAR_LIST});
            this.getModel().setValue(VARCHAR_LIST, (Object)value);
        } else if (currentType == DataType.DATETIME) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DATE_LIST});
            this.getModel().setValue(DATE_LIST, (Object)value);
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{currentKey});
        this.getModel().setValue(currentKey, fileValue);
        this.getPageCache().put(CURRENT_KEY, currentKey);
    }

    private String getFileKey(DataType currentType) {
        String currentKey = VARCHAR;
        if (currentType == DataType.INT || currentType == DataType.SMALLINT) {
            currentKey = INTEGER;
        } else if (currentType == DataType.BIGINT) {
            currentKey = BIGINT;
        } else if (currentType == DataType.DECIMAL) {
            currentKey = DECIMAL;
        }
        return currentKey;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap<String, String> res = new HashMap<String, String>(2);
        if (BTN_OK.equals(key)) {
            String currentKey = this.getPageCache().get(CURRENT_KEY);
            String value = String.valueOf(this.getModel().getValue(currentKey));
            res.put("value", value);
            this.getView().returnDataToParent(res);
            this.getView().close();
        }
    }

    private boolean isNumberType(String type) {
        DataType currentType = DataType.valueOf((int)Integer.parseInt(type));
        return currentType == DataType.INT || currentType == DataType.SMALLINT || currentType == DataType.BIGINT || currentType == DataType.DECIMAL;
    }
}

