/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ColumnPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BTN_OK = "btnok";
    private static final String SELECT_INDEX = "selectIndex";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterBindData(EventObject e) {
        String index = this.getPageCache().get(SELECT_INDEX);
        if (StringUtils.isNotBlank((CharSequence)index)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectIndex = (int[])SerializationUtils.fromJsonString((String)index, int[].class);
            if (selectIndex.length > 0) {
                entryGrid.selectRows(selectIndex, selectIndex[0]);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.fillEntryEntity();
    }

    private void fillEntryEntity() {
        List<ColumnAp> dmColumn = this.getDmColumn();
        if (dmColumn.isEmpty()) {
            return;
        }
        Set<String> selectColumn = this.getSelectColumn();
        ArrayList<Integer> selectIndex = new ArrayList<Integer>(10);
        int[] row = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, dmColumn.size());
        for (int i2 = 0; i2 < row.length; ++i2) {
            ColumnAp column = dmColumn.get(i2);
            this.getModel().setValue(NAME, (Object)column.getName(), i2);
            this.getModel().setValue(NUMBER, (Object)column.getColumnName(), i2);
            if (!selectColumn.contains(column.getColumnName())) continue;
            selectIndex.add(i2);
        }
        int[] indexes = selectIndex.stream().mapToInt(i -> i).toArray();
        this.getPageCache().put(SELECT_INDEX, SerializationUtils.toJsonString((Object)indexes));
    }

    private List<ColumnAp> getDmColumn() {
        String column = (String)this.getView().getFormShowParameter().getCustomParam("param");
        if (StringUtils.isBlank((CharSequence)column)) {
            return new ArrayList<ColumnAp>();
        }
        return SerializationUtils.fromJsonStringToList((String)column, ColumnAp.class);
    }

    private Set<String> getSelectColumn() {
        String selectColumn = (String)this.getView().getFormShowParameter().getCustomParam("selectColumn");
        if (StringUtils.isBlank((CharSequence)selectColumn)) {
            return new HashSet<String>(1);
        }
        HashSet<String> columnSet = new HashSet<String>(16);
        String[] columns = selectColumn.split(",");
        columnSet.addAll(Arrays.asList(columns));
        return columnSet;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u4e00\u884c");
                return;
            }
            ArrayList<String> columns = new ArrayList<String>(selectRows.length);
            for (int rowIndex : selectRows) {
                String number = (String)this.getModel().getValue(NUMBER, rowIndex);
                columns.add(number);
            }
            this.getView().returnDataToParent(columns);
            this.getView().close();
        }
    }
}

