/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.metadata.pdm.PDMDiagramMetadata;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.exception.KDException;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

class DBToDataModelConverter {
    private DBRoute dbRoute;
    private String tables;
    private PDMEntityMetadata pdmMetadata;

    public DBToDataModelConverter() {
    }

    public DBToDataModelConverter(PDMEntityMetadata pdmMetadata, DBRoute dbRoute, String tables) {
        this.dbRoute = dbRoute;
        this.tables = tables;
        this.pdmMetadata = pdmMetadata;
    }

    protected void covert() {
        if (this.pdmMetadata == null) {
            return;
        }
        PDMDiagramMetadata pdmDiagramMetadata = new PDMDiagramMetadata();
        pdmDiagramMetadata.setId(this.pdmMetadata.getId());
        pdmDiagramMetadata.setNumber(this.pdmMetadata.getNumber());
        pdmDiagramMetadata.setBizappId(this.pdmMetadata.getBizappId());
        pdmDiagramMetadata.setIsv(this.pdmMetadata.getIsv());
        pdmDiagramMetadata.setDevType(this.pdmMetadata.getDevType());
        pdmDiagramMetadata.setProduct(this.pdmMetadata.getProduct());
        PhysicalDiagram physicalDiagram = new PhysicalDiagram();
        physicalDiagram.setId(DB.genStringId((String)""));
        physicalDiagram.setKey("physicalDiagram");
        physicalDiagram.setName(new LocaleString(String.format("%s\u6a21\u578b\u56fe", this.pdmMetadata.getNumber())));
        physicalDiagram.setParentId(this.pdmMetadata.getId());
        pdmDiagramMetadata.getPhysicalDiagramAps().add(physicalDiagram);
        this.pdmMetadata.setPdmDiagramMetadata(pdmDiagramMetadata);
        DMPackageAp packageAp = new DMPackageAp();
        packageAp.setParentId(this.pdmMetadata.getId());
        packageAp.setName(this.pdmMetadata.getName());
        packageAp.setKey("package");
        packageAp.setId(DB.genStringId((String)""));
        this.pdmMetadata.getPackageAps().add(packageAp);
        Imeta meta = MetaFactory.getMeta((DBRoute)DBRoute.meta);
        List<String> tableList = this.getTableList();
        if (tableList != null) {
            String[] tableIds = DB.genStringIds((String)"", (int)tableList.size());
            int i = 0;
            for (String table : tableList) {
                List indexInfoList;
                TableAp tableAp = new TableAp();
                tableAp.setId(tableIds[i]);
                tableAp.setTableName(table);
                tableAp.setName(new LocaleString(table));
                tableAp.setKey(table);
                tableAp.setParentId(packageAp.getId());
                ArrayList<ColumnAp> columnApList = new ArrayList<ColumnAp>();
                List fieldInfoList = DB.getFieldInfo((DBRoute)this.dbRoute, (String)table);
                if (fieldInfoList != null) {
                    String[] columnIds = DB.genStringIds((String)"", (int)fieldInfoList.size());
                    int j = 0;
                    for (FieldInfo fieldInfo : fieldInfoList) {
                        ColumnAp columnAp = this.createColumnAp(fieldInfo, columnIds[j], j);
                        if (columnAp != null) {
                            columnAp.setParentId(tableAp.getId());
                            columnApList.add(columnAp);
                        }
                        ++j;
                    }
                }
                tableAp.setColumns(columnApList);
                PkInfo pkInfo = meta.queryPkInfo(this.dbRoute, table);
                PrimaryKeyAp primaryKeyAp = this.createPrimaryKeyAp(pkInfo, table, columnApList);
                if (primaryKeyAp != null) {
                    primaryKeyAp.setParentId(tableAp.getId());
                    tableAp.setPrimaryKey(primaryKeyAp);
                }
                if ((indexInfoList = meta.queryIndexInfos(this.dbRoute, table)) != null) {
                    String[] idxId = DB.genStringIds((String)"", (int)indexInfoList.size());
                    int k = 0;
                    for (IndexInfo indexInfo : indexInfoList) {
                        IndexAp indexAp = this.createIndexAp(indexInfo, table, columnApList, idxId[k]);
                        if (indexAp != null) {
                            indexAp.setParentId(tableAp.getId());
                            tableAp.getIndexs().add(indexAp);
                        }
                        ++k;
                    }
                }
                packageAp.getTableAps().add(tableAp);
                ++i;
            }
        }
    }

    private IndexAp createIndexAp(IndexInfo indexInfo, String table, List<ColumnAp> columnApList, String id) {
        if (indexInfo != null) {
            IndexAp indexAp = new IndexAp();
            indexAp.setId(id);
            indexAp.setIndexName(indexInfo.getIndexName());
            indexAp.setKey(indexInfo.getIndexName());
            indexAp.setName(new LocaleString(indexInfo.getAliasName()));
            indexAp.setTableName(table);
            indexAp.setCluster(false);
            indexAp.setUnique(indexInfo.isUnique());
            List indexColumnStringList = indexInfo.getColumnNameList();
            if (indexColumnStringList != null) {
                String[] refIds = DB.genStringIds((String)"", (int)indexColumnStringList.size());
                int n = 0;
                for (IndexColumnString indexColumnString : indexColumnStringList) {
                    for (ColumnAp columnAp : columnApList) {
                        if (!indexColumnString.getColumn().equals(columnAp.getColumnName())) continue;
                        RefColumnAp refColumnAp = new RefColumnAp();
                        refColumnAp.setRefId(columnAp.getId());
                        refColumnAp.setId(refIds[n]);
                        refColumnAp.setKey(columnAp.getColumnName());
                        refColumnAp.setName(new LocaleString(columnAp.getColumnName()));
                        indexAp.getIndexColumnAps().add(refColumnAp);
                    }
                    ++n;
                }
            }
            return indexAp;
        }
        return null;
    }

    private PrimaryKeyAp createPrimaryKeyAp(PkInfo pkInfo, String table, List<ColumnAp> columnApList) {
        if (pkInfo != null) {
            PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
            String pkName = pkInfo.getIndexName();
            primaryKeyAp.setPk(pkName);
            primaryKeyAp.setTableName(table);
            primaryKeyAp.setId(DB.genStringId((String)""));
            primaryKeyAp.setCluster(false);
            List pkList = pkInfo.getColumnNameList();
            if (pkList != null) {
                String[] refIds = DB.genStringIds((String)"", (int)pkList.size());
                int n = 0;
                for (IndexColumnString pk : pkList) {
                    for (ColumnAp columnAp : columnApList) {
                        if (!pk.getColumn().equals(columnAp.getColumnName())) continue;
                        columnAp.setPrimaryKey(true);
                        RefColumnAp refColumnAp = new RefColumnAp();
                        refColumnAp.setRefId(columnAp.getId());
                        refColumnAp.setId(refIds[n]);
                        refColumnAp.setKey(columnAp.getColumnName());
                        refColumnAp.setName(new LocaleString(columnAp.getColumnName()));
                        primaryKeyAp.getPkColumnList().add(refColumnAp);
                    }
                    ++n;
                }
            }
            return primaryKeyAp;
        }
        return null;
    }

    private ColumnAp createColumnAp(FieldInfo fieldInfo, String id, int i) {
        ColumnAp columnAp = new ColumnAp();
        columnAp.setId(String.valueOf(fieldInfo.getFieldId()));
        String name = StringUtil.isNotBlank((String)fieldInfo.getFieldComment()) ? fieldInfo.getFieldComment() : fieldInfo.getFieldName();
        columnAp.setName(new LocaleString(name));
        columnAp.setKey(fieldInfo.getFieldName());
        columnAp.setColumnName(fieldInfo.getFieldName());
        columnAp.setColumnDef(fieldInfo.getDataDefault());
        if (fieldInfo.getDataLength() > Integer.MAX_VALUE) {
            throw new KDException("\u5b57\u6bb5\u957f\u5ea6\u8d85\u8fc7\u4e86\u6700\u5927\u503c\u3002");
        }
        columnAp.setColumnLength((int)fieldInfo.getDataLength());
        columnAp.setColumnPrecision(fieldInfo.getDataPrecision());
        columnAp.setColunmType((int)DataType.fromSqlType((int)fieldInfo.getJDBCDataType()).getValue());
        columnAp.setNotNull(!fieldInfo.isNullable());
        columnAp.setDescription(name);
        columnAp.setSeq(i);
        return columnAp;
    }

    private List<String> getTableList() {
        if (StringUtil.isBlank((String)this.tables)) {
            return DB.getTables((DBRoute)this.dbRoute);
        }
        List tables = DB.getTables((DBRoute)this.dbRoute);
        List tableList = SerializationUtils.fromJsonStringToList((String)this.tables, String.class);
        tableList.removeIf(table -> !tables.contains(table.toLowerCase()) && !tables.contains(table.toUpperCase()));
        return tableList;
    }
}

