/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DataModelDesignerData;
import kd.bos.designer.utils.DataModelUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class DataModelCreatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(DataModelCreatePlugin.class);
    protected static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    protected static final String OK = "ok";
    protected static final String CANCEL = "cancel";
    protected static final String ISV = "isv";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String BIZAPP = "bizapp";
    protected static final String INDUSTRY = "industry";
    protected static final String PRODUCT = "product";
    protected static final String DBMS = "dbms";
    protected static final String SOURCE_MODEL = "sourcemodel";
    protected static final String DESCRIPTION = "description";
    protected static final String SUCCESS = "success";
    protected static final String MESSAGE = "message";
    private static List<String> kingdeeIsv = new ArrayList<String>(2);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OK, CANCEL});
        BasedataEdit bizApp = (BasedataEdit)this.getView().getControl(BIZAPP);
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isv = ISVService.getISVInfo().getId();
        this.getModel().setValue(ISV, (Object)isv);
        String createType = (String)this.getView().getFormShowParameter().getCustomParam("createType");
        if ("extend".equals(createType)) {
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
            String number = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
            String oriModelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
            this.getModel().setValue(SOURCE_MODEL, (Object)number);
            this.getView().setVisible(Boolean.TRUE, new String[]{SOURCE_MODEL});
            number = !"kingdee".equalsIgnoreCase(isv) ? String.format("%s_%s_%s", isv, number, "ext") : String.format("%s_%s", number, "ext");
            number = DataModelUtils.autoFormNumber(number, "_ext", oriModelId, "");
            String name = (String)this.getView().getFormShowParameter().getCustomParam(NAME);
            String description = (String)this.getView().getFormShowParameter().getCustomParam(DESCRIPTION);
            this.getModel().setValue(BIZAPP, (Object)bizAppId);
            this.getView().setEnable(Boolean.FALSE, new String[]{BIZAPP});
            this.getModel().setValue(NAME, (Object)name);
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().setValue(DESCRIPTION, (Object)description);
            this.setDbRoute();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SOURCE_MODEL});
        }
    }

    protected void setDbRoute() {
        DynamicObject app = (DynamicObject)this.getModel().getValue(BIZAPP);
        if (app == null) {
            this.getModel().setValue("db", null);
            return;
        }
        String db = app.getString("dbroute");
        JSONArray dbInstanceList = DataModelUtils.getDbInstanceList();
        String dbName = null;
        for (Object dbInstance : dbInstanceList) {
            JSONObject dbObject = (JSONObject)dbInstance;
            String number = dbObject.getString(NUMBER);
            if (number == null || !number.equals(db)) continue;
            dbName = Lang.zh_CN != Lang.get() ? number : dbObject.getString(NAME);
            break;
        }
        this.getModel().setValue("db", dbName);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                if (!this.check("")) {
                    return;
                }
                if (!this.numberCheck("")) {
                    return;
                }
                HashMap<String, Object> message = new HashMap<String, Object>(16);
                message.put(SUCCESS, true);
                try (TXHandle tx = TX.required((String)"DataModelCreate");){
                    try {
                        String createType = (String)this.getView().getFormShowParameter().getCustomParam("createType");
                        Map<String, Object> param = this.buildCreateParam();
                        DataModelDesignerData designerData = new DataModelDesignerData();
                        if ("extend".equals(createType)) {
                            String parentId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
                            param.put("devType", "2");
                            param.put("parentId", parentId);
                        }
                        PDMEntityMetadata metadata = designerData.createBlankMetadata(param);
                        IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
                        List designMetaList = writer.convertToMDesignMeta(metadata);
                        writer.save(designMetaList);
                        message.put("modelId", ((DataModelDesignMeta)designMetaList.get(0)).getId());
                        message.put(NUMBER, ((DataModelDesignMeta)designMetaList.get(0)).getNumber());
                        if ("extend".equals(createType)) {
                            DataModelUtils.addLog("bos_dm_modellist", ResManager.loadKDString((String)"\u6269\u5c55", (String)"DataModelCreatePlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6269\u5c55\u6570\u636e\u6a21\u578b%s", (String)"DataModelCreatePlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), metadata.getNumber()));
                        } else {
                            DataModelUtils.addLog("bos_dm_modellist", ResManager.loadKDString((String)"\u65b0\u5efa", (String)"DataModelCreatePlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u65b0\u5efa\u6570\u636e\u6a21\u578b%s", (String)"DataModelCreatePlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), metadata.getNumber()));
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        tx.markRollback();
                        message.put(SUCCESS, Boolean.FALSE);
                        String msg = e.getMessage();
                        message.put(MESSAGE, msg);
                        throw e;
                    }
                }
                this.getView().returnDataToParent(message);
                this.getView().close();
                break;
            }
            case "cancel": {
                String parentId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
                HashMap<String, String> closeReturn = new HashMap<String, String>(1);
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    closeReturn.put("modelId", parentId);
                }
                this.getView().returnDataToParent(closeReturn);
                this.getView().close();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (BIZAPP.equals(arg0.getProperty().getName())) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            QFilter filter = new QFilter("masterid", "=", (Object)" ");
            filters.add(filter);
            filters.add(new QFilter("bizcloud", "!=", (Object)"2HGKCE94QELW"));
            filters.add(new QFilter("id", "!=", (Object)"2HGKTA7HH43C"));
            param.getListFilterParameter().getQFilters().addAll(filters);
        }
    }

    protected Map<String, Object> buildCreateParam() {
        DynamicObject app = (DynamicObject)this.getModel().getValue(BIZAPP);
        String bizAppId = app.getPkValue().toString();
        String appNum = app.getString(NUMBER);
        String number = (String)this.getModel().getValue(NUMBER);
        String modelId = this.genModelId(number, app.getString(NUMBER));
        String name = (String)this.getModel().getValue(NAME);
        String isv = (String)this.getModel().getValue(ISV);
        String product = (String)this.getModel().getValue(PRODUCT);
        String description = (String)this.getModel().getValue(DESCRIPTION);
        DynamicObject industryObj = (DynamicObject)this.getModel().getValue(INDUSTRY);
        long industry = 0L;
        if (industryObj != null) {
            industry = (Long)industryObj.getPkValue();
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("bizAppId", bizAppId);
        param.put("appNum", appNum);
        param.put(NUMBER, number);
        param.put("key", modelId);
        param.put("modelId", modelId);
        param.put(NAME, name);
        param.put(ISV, isv);
        param.put(PRODUCT, product);
        param.put(DESCRIPTION, description);
        param.put(INDUSTRY, industry);
        return param;
    }

    protected boolean check(String modelId) {
        String number = (String)this.getModel().getValue(NUMBER);
        String name = (String)this.getModel().getValue(NAME);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(BIZAPP);
        String proudct = (String)this.getModel().getValue(PRODUCT);
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u578b\u7f16\u7801\u3002", (String)"DataModelCreate_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        Map<String, Object> retMap = DataModelUtils.numberCheck(number);
        if (!retMap.isEmpty() && retMap.get(MESSAGE) != null) {
            this.getView().showTipNotification((String)retMap.get(MESSAGE));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u578b\u540d\u79f0\u3002", (String)"DataModelCreate_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (bizApp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u5e94\u7528\u3002", (String)"DataModelCreate_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)proudct)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u578b\u6240\u5c5e\u4ea7\u54c1\u3002", (String)"DataModelCreate_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean numberCheck(String modelId) {
        String number = (String)this.getModel().getValue(NUMBER);
        if (DataModelUtils.numberExist(number, modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DataModelCreate_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean bizAppCheck(String modelId) {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(BIZAPP);
        if (bizApp != null && DataModelUtils.bizAppExist(bizApp.getPkValue().toString(), modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u6709\u6a21\u578b\uff0c\u6bcf\u4e2a\u5e94\u7528\u53ea\u53ef\u914d\u7f6e\u4e00\u4e2a\u6a21\u578b\u3002", (String)"DataModelCreate_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected String genModelId(String number, String appNum) {
        String createType = (String)this.getView().getFormShowParameter().getCustomParam("createType");
        String parentNumber = (String)this.getView().getFormShowParameter().getCustomParam(NUMBER);
        if ("extend".equals(createType)) {
            number = parentNumber;
        }
        String isv = (String)this.getModel().getValue(ISV);
        String product = (String)this.getModel().getValue(PRODUCT);
        if (StringUtils.isBlank((CharSequence)appNum)) {
            appNum = number;
        }
        return DataModelUtils.genModelId(isv, product, appNum, number, createType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (NUMBER.equalsIgnoreCase(propertyName)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            if (number != null) {
                number = number.trim();
            }
            number = DataModelUtils.autoISVNumber(number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        } else if (BIZAPP.equalsIgnoreCase(propertyName)) {
            DynamicObject bizApp = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (bizApp != null) {
                this.setProduct(bizApp.getPkValue().toString());
            }
            this.setDbRoute();
        }
    }

    private void setProduct(String bizAppId) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return;
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String appIsv = appMeta.getIsv();
        if (StringUtils.isBlank((CharSequence)appIsv)) {
            return;
        }
        String product = null;
        if (kingdeeIsv.contains(appIsv)) {
            if (BOSRuntime.isBOSApp((String)bizAppId)) {
                product = "cosmic";
            } else if ("kingdee".equalsIgnoreCase(appIsv)) {
                product = "constellation";
            } else if ("kdxk".equalsIgnoreCase(appIsv)) {
                product = "galaxy";
            }
        }
        this.getModel().setValue(PRODUCT, (Object)product);
    }

    static {
        kingdeeIsv.add("kingdee");
        kingdeeIsv.add("kdxk");
    }
}

