/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DataModelDesignerData;
import kd.bos.designer.plugin.DBToDataModelConverter;
import kd.bos.designer.plugin.DataModelCreatePlugin;
import kd.bos.designer.utils.DataModelUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataModelDBCreatePlugin
extends DataModelCreatePlugin {
    private static Log log = LogFactory.getLog(DataModelDBCreatePlugin.class);
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private static final String TABAP = "tabap";
    private static final String TAB_DBPAGE = "tabdbpage";
    private static final String TAB_NEWPAGE = "tabnewpage";
    private static final String DBROUTE = "dbroute";
    private static final String TABLES = "tables";
    private static final String BOS_DM_TABLESELECT = "bos_dm_tableselect";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LAST, NEXT, TABLES});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{LAST, "ok"});
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl(DBROUTE);
        ArrayList<ComboItem> dbInstenceItem = new ArrayList<ComboItem>();
        JSONArray dbInstanceList = DataModelUtils.getDbInstanceList();
        if (dbInstanceList.size() > 0) {
            for (Object object : dbInstanceList) {
                JSONObject dbInstance = (JSONObject)object;
                String dbNumber = (String)dbInstance.get((Object)"number");
                String dbName = (String)dbInstance.get((Object)"name");
                dbInstenceItem.add(new ComboItem(new LocaleString(dbName), dbNumber));
            }
            dbCombo.setComboItems(dbInstenceItem);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        Tab tab = (Tab)this.getControl(TABAP);
        String dbRoute = (String)this.getModel().getValue(DBROUTE);
        switch (key) {
            case "next": {
                if (StringUtils.isBlank((CharSequence)dbRoute)) {
                    this.getView().showTipNotification("\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u3002");
                    return;
                }
                tab.activeTab(TAB_NEWPAGE);
                this.getView().setVisible(Boolean.FALSE, new String[]{NEXT});
                this.getView().setVisible(Boolean.TRUE, new String[]{LAST, "ok"});
                break;
            }
            case "last": {
                tab.activeTab(TAB_DBPAGE);
                this.getView().setVisible(Boolean.FALSE, new String[]{LAST, "ok"});
                this.getView().setVisible(Boolean.TRUE, new String[]{NEXT});
                break;
            }
            case "ok": {
                if (!this.check("")) {
                    return;
                }
                this.save();
                break;
            }
            case "tables": {
                if (StringUtils.isBlank((CharSequence)dbRoute)) {
                    this.getView().showTipNotification("\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u3002");
                    return;
                }
                String selectTables = (String)this.getModel().getValue(TABLES);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(BOS_DM_TABLESELECT);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("dbRoute", (Object)dbRoute);
                parameter.setCustomParam("selectTables", (Object)selectTables);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tableSelectCallBack"));
                this.getView().showForm(parameter);
            }
        }
    }

    private void save() {
        HashMap<String, Object> message = new HashMap<String, Object>(16);
        message.put("success", true);
        try (TXHandle tx = TX.required((String)"DataModelDBCreate");){
            try {
                String number = (String)this.getModel().getValue("number");
                String name = (String)this.getModel().getValue("name");
                DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
                String dbRoute = (String)this.getModel().getValue(DBROUTE);
                String modelId = this.genModelId(number, bizApp.getString("number"));
                String product = (String)this.getModel().getValue("product");
                DataModelDesignerData designerData = new DataModelDesignerData();
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("number", number);
                param.put("key", modelId);
                param.put("modelId", modelId);
                param.put("name", name);
                param.put("product", product);
                param.put("bizAppId", bizApp.getPkValue().toString());
                DynamicObject industryObj = (DynamicObject)this.getModel().getValue("industry");
                long industry = 0L;
                if (industryObj != null) {
                    industry = (Long)industryObj.getPkValue();
                }
                param.put("industry", industry);
                PDMEntityMetadata metadata = designerData.createBlankMetadata(param);
                metadata.getPackageAps().clear();
                try (TXHandle dbTx = TX.notSupported();){
                    String tables = (String)this.getModel().getValue(TABLES);
                    DBToDataModelConverter converter = new DBToDataModelConverter(metadata, new DBRoute(dbRoute), tables);
                    converter.covert();
                }
                IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
                List designMetaList = writer.convertToMDesignMeta(metadata);
                writer.save(designMetaList);
                DataModelUtils.addLog("bos_dm_modellist", ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6a21\u578b", (String)"DataModelDBCreatePlugin_1", (String)"bos-datamodel-plugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6a21\u578b%s", (String)"DataModelDBCreatePlugin_2", (String)"bos-datamodel-plugin", (Object[])new Object[0]), number));
                message.put("modelId", ((DataModelDesignMeta)designMetaList.get(0)).getId());
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                tx.markRollback();
                message.put("success", Boolean.FALSE);
                String msg = e.getMessage();
                message.put("message", msg);
                throw e;
            }
        }
    }

    @Override
    protected boolean check(String modelId) {
        boolean check = super.check(modelId);
        if (!check) {
            return check;
        }
        String number = (String)this.getModel().getValue("number");
        if (DataModelUtils.numberExist(number, modelId)) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6a21\u578b\u5df2\u5b58\u5728\uff0c\u786e\u8ba4\u8986\u76d6\uff1f", (String)"DataModelDBCreatePlugin_0", (String)"bos-datamodel-plugin", (Object[])new Object[0]), number), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("numberExitCallback"));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "tableSelectCallBack": {
                if (returnData == null) break;
                String selectTables = (String)returnData.get("selectTables");
                this.getModel().setValue(TABLES, (Object)selectTables);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (actionId = messageBoxClosedEvent.getCallBackId()) {
            case "numberExitCallback": {
                this.save();
            }
        }
    }
}

