/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.designer.utils.DataModelUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DataModelDelPlugin
extends AbstractFormPlugin {
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String regex = "[a-z0-9_]+";
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final String MODEL_NUMBER = "modelnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OK, CANCEL});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                String number = (String)this.getModel().getValue(MODEL_NUMBER);
                if (StringUtils.isBlank((CharSequence)number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u578b\u7f16\u7801\u3002", (String)"DataModelDelPlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                Boolean flag = Pattern.matches(regex, number);
                if (!flag.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DevportalUtil_55", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String modelNumber = (String)this.getView().getFormShowParameter().getCustomParam("modelNumber");
                if (!number.equalsIgnoreCase(modelNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DataModelDelPlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
                IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
                writer.delete(new Object[]{modelId});
                DataModelUtils.addLog("bos_dm_modellist", ResManager.loadKDString((String)"\u5220\u9664", (String)"DataModelDelPlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u6a21\u578b%s", (String)"DataModelDelPlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), modelNumber));
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("success", true);
                map.put("modelId", modelId);
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
        }
    }
}

