/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.designer.plugin.PDMReader;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class DataModelDesignerImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(DataModelDesignerImportPlugin.class);

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        String url = (String)urls[0];
        try {
            PDMEntityMetadata metadata = this.getImportData(url);
            List designMetaList = this.getWriter().convertToDeltaDesignMeta(metadata);
            this.getWriter().save(designMetaList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private PDMEntityMetadata getImportData(String url) throws Exception {
        PDMEntityMetadata dataModel;
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inStream = cache.getInputStream(url);){
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(inStream);
            PDMReader pdmReader = new PDMReader(document);
            pdmReader.setBizAppId("bos");
            dataModel = pdmReader.convertToDesignMeta();
        }
        catch (DocumentException e) {
            throw new Exception(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6709\u7279\u6b8a\u5b57\u6bb5\uff0c\u6709\u7279\u6b8a\u5b57\u7b26\u8bf7\u53bb\u6389\u540e\u518d\u5c1d\u8bd5\u3002", (String)"DataModelDesignerImportPlugin_0", (String)"bos-datamodel-plugin", (Object[])new Object[0]), e);
        }
        return dataModel;
    }

    private IPDMDesignMetaWriter getWriter() {
        return PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
    }

    private void writeLog(DataModelDesignMeta designMeta) {
        try {
            MetadataLogService metadataLogService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58PDM\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a", (Throwable)e);
        }
    }
}

