/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.DeployPDMMetadataDao;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaWriter;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.designer.dao.DataModelDesignerData;
import kd.bos.designer.dao.DataModelValidator;
import kd.bos.designer.plugin.PDMModelCompare;
import kd.bos.designer.plugin.log.DataModelLogServiceImpl;
import kd.bos.designer.property.alias.DataModelPropertyConverterFactory;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageCallBackType;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.DataModelDesigner;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.control.events.datamodel.TableClickEvent;
import kd.bos.form.control.events.datamodel.TableClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;

public class DataModelDesignerPlugin
extends AbstractFormPlugin
implements DesignerBarListener,
TableClickListener,
PropertyListener {
    private static final String DATA_MODEL_DESIGNER = "datamodeldesignerap";
    private static final String BOS_MODELASSET_TABLE = "bos_modelasset_table";
    private static final String FORMID_DESIGNER = "bos_modelasset_designer";
    private static final String BOS_DM_SQL = "bos_dm_sql";
    private static final String MODEL_ID = "modelId";
    private static final String MORE_DATA_MODEL = "showModel";
    private static final String ACTION_ID = "actionId";
    private static final String SAVE = "temporaryStorage";
    private static final String SUBMIT = "submit";
    private static final String HISTORY = "history";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String TABLE_CALL_BACK = "tableClickCallBack";
    private static final String SQL_CALL_BACK = "sqlCallBack";
    private static final String PARAM = "param";
    private static final String MODEL_TYPE = "PhysicalDataModel";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BOS_DEVP_METALOG_NEW = "bos_devp_metalog_new";
    private static final String BOS_DATAMODEL_LOG_LAYOUT = "bos_datamodel_log_layout";
    private static final String HISTORY_CALL_BACK = "historyCallBack";
    private static final String FORM_ID = "formId";
    public static final String PARAM_MODEL_TYPE_1 = "modeltype";
    public static final String PARAM_ITEM_ID = "itemId";
    public static final String PARAM_PROPERTY_NAME = "propertyName";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_META_TYPE = "metaType";
    public static final String PARAM_CONTEXT = "context";
    public static final String PARAM_PROPERTY_EDIT = "propertyEdit";
    private static final String BOS_DM_MODELLIST = "bos_dm_modellist";
    private static final String BOS_DM_RESULT = "bos_dm_result";
    private static final String WARN = "warn";
    private static final String BOS_DM_SUBMIT = "bos_dm_submit";
    private static final String TRUE = "true";
    private static final String LOCK_MESSAGE = "lockMessage";
    private static final Log log = LogFactory.getLog(DataModelDesignerPlugin.class);

    public void registerListener(EventObject e) {
        DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
        designer.addBarListener((DesignerBarListener)this);
        designer.addTableClickListeners((TableClickListener)this);
        designer.addClickListener((ClickListener)this);
        designer.addPropertyListener((PropertyListener)this);
    }

    public void afterBindData(EventObject e) {
        String modelId = this.getModelId();
        DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
        if (!this.resourceCheck()) {
            designer.setDesignerBarVisible(Boolean.valueOf(false), new String[]{SAVE, SUBMIT});
        }
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        Map designMeta = reader.loadDesignMeta(modelId);
        designer.open(designMeta);
    }

    public void designerBarClick(DesignerBarEvent e) {
        String key;
        switch (key = e.getBarItemKey()) {
            case "temporaryStorage": {
                this.saveData();
                break;
            }
            case "submit": {
                this.submitData();
                break;
            }
            case "history": {
                this.showHistory();
                break;
            }
        }
    }

    public void tableClick(TableClickEvent tableClickEvent) {
        String itemId = tableClickEvent.getItemId();
        String tableName = tableClickEvent.getTableName();
        Map param = tableClickEvent.getParam();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_MODELASSET_TABLE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(PARAM, (Object)param);
        parameter.setCustomParam(PARAM_ITEM_ID, (Object)itemId);
        parameter.setCustomParam("tableName", (Object)tableName);
        parameter.setCustomParam("modelType", (Object)MODEL_TYPE);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, TABLE_CALL_BACK);
        callBack.setControlKey(((Control)tableClickEvent.getSource()).getKey());
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void click(EventObject evt) {
        ClickEvent event = (ClickEvent)evt;
        Map params = event.getParamsMap();
        String actionId = (String)params.get(ACTION_ID);
        if (MORE_DATA_MODEL.equals(actionId)) {
            this.showDataModel();
        }
    }

    public void click(PropertyEvent e) {
        Map openParameter = (Map)e.getParam().get("form");
        FormShowParameter parameter = openParameter.containsKey("showType") && openParameter.get("showType").equals("ListType") ? this.createListShowParameter(openParameter) : FormShowParameter.createFormShowParameter((Map)openParameter);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(PARAM_ITEM_ID, (Object)e.getItemId());
        parameter.setCustomParam(PARAM_PROPERTY_NAME, (Object)e.getPropertName());
        parameter.setCustomParam(PARAM_VALUE, e.getParam().get(PARAM_VALUE));
        parameter.setCustomParam(PARAM_CONTEXT, e.getParam().get(PARAM_CONTEXT));
        parameter.setCustomParam(PARAM_META_TYPE, (Object)e.getMetaType());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, PARAM_PROPERTY_EDIT);
        callBack.setControlKey(((Control)e.getSource()).getKey());
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private FormShowParameter createListShowParameter(Map<String, Object> openParameter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(openParameter.get(FORM_ID).toString());
        showParameter.setCustomParam("selectaction", (Object)"FieldEdit");
        StyleCss css = new StyleCss();
        if (openParameter.containsKey("width")) {
            css.setWidth(openParameter.get("width").toString());
        } else {
            css.setWidth("960px");
        }
        if (openParameter.containsKey("height")) {
            css.setWidth(openParameter.get("height").toString());
        } else {
            css.setHeight("580px");
        }
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)openParameter.get(FORM_ID).toString());
        showParameter.setFormId(formConfig.getF7ListFormId());
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        boolean isMultiSelect = false;
        if (openParameter.containsKey("multiSelect") && openParameter.get("multiSelect").equals(TRUE)) {
            isMultiSelect = true;
        }
        showParameter.setMultiSelect(isMultiSelect);
        showParameter.setShowTitle(false);
        if (openParameter.containsKey(PARAM_MODEL_TYPE_1)) {
            String formPara = openParameter.get(PARAM_MODEL_TYPE_1).toString();
            showParameter.setCustomParam(PARAM_MODEL_TYPE_1, (Object)formPara);
        } else if (openParameter.containsKey("listStyle")) {
            showParameter.setLookUp(false);
            showParameter.setFormId(formConfig.getListFormId());
        }
        return showParameter;
    }

    public void getPropertyAlias(PropertyEvent e) {
        Map openParameter = (Map)e.getParam().get("form");
        String formId = (String)openParameter.get(FORM_ID);
        IPropertyConverter cv = DataModelPropertyConverterFactory.create(formId);
        if (cv != null) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            cv.setContext(e.getParam().get(PARAM_CONTEXT), e.getItemId());
            Object value = e.getParam().get(PARAM_VALUE);
            cv.setModelType(MODEL_TYPE);
            Object alias = cv.convert(value);
            para.put(PARAM_ITEM_ID, e.getItemId());
            para.put(PARAM_META_TYPE, e.getMetaType());
            para.put(PARAM_PROPERTY_NAME, e.getPropertName());
            para.put(PARAM_VALUE, value);
            para.put("alias", alias);
            DataModelDesigner designer = (DataModelDesigner)e.getSource();
            designer.setProperty(para);
        }
    }

    private void saveData() {
        if (!this.validator()) {
            return;
        }
        DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
        Map content = designer.getContent();
        DataModelDesignerData designerData = new DataModelDesignerData();
        Map<String, Object> result = designerData.save(content, null, this.getModelId());
        String message = (String)result.get(MESSAGE);
        if (!((Boolean)result.get(SUCCESS)).booleanValue()) {
            this.getView().showErrorNotification(message);
            return;
        }
        this.getView().showSuccessNotification(message);
        IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
        PDMEntityMetadata pdmMetadata = writer.convertToMetadata(content);
        this.updateModelModifiedStatus(pdmMetadata);
        DataModelValidator validator = new DataModelValidator(pdmMetadata);
        validator.validatorDataModel();
        ArrayList warnInfo = new ArrayList();
        if (!pdmMetadata.getValidatorInfos().isEmpty()) {
            if (pdmMetadata.getValidatorInfos().stream().allMatch(error -> error.getLevel() == 1)) {
                warnInfo.addAll(pdmMetadata.getValidatorInfos());
            } else {
                List errors = pdmMetadata.getValidatorInfos().stream().filter(info -> info.getLevel() == 2).collect(Collectors.toList());
                result = new HashMap<String, Object>();
                result.put(SUCCESS, false);
                result.put(MESSAGE, errors);
                if (!errors.isEmpty()) {
                    this.showResult(result);
                }
                return;
            }
        }
        result.put(SUCCESS, true);
        if (!warnInfo.isEmpty()) {
            result.put(WARN, true);
            result.put("warnMessage", warnInfo);
            this.showResult(result);
        }
    }

    private void submitData() {
        Map<String, Map<String, String>> sqlParameter;
        if (!this.validator()) {
            return;
        }
        DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
        Map content = designer.getContent();
        IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
        PDMEntityMetadata pdmMetadata = writer.convertToMetadata(content);
        this.updateModelModifiedStatus(pdmMetadata);
        DataModelValidator validator = new DataModelValidator(pdmMetadata);
        validator.validatorDataModel();
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        if (!pdmMetadata.getValidatorInfos().isEmpty() && !pdmMetadata.getValidatorInfos().stream().allMatch(error -> error.getLevel() == 1)) {
            List errors = pdmMetadata.getValidatorInfos().stream().filter(error -> error.getLevel() == 2).collect(Collectors.toList());
            res.put(SUCCESS, false);
            res.put(MESSAGE, errors);
            this.showValidatorInfo(res);
            return;
        }
        String id = pdmMetadata.getId();
        List baseDeployFile = DeployPDMMetadataDao.getDataModelDeployFile((String)id);
        List dataModelDesignMetas = writer.convertToMDesignMeta(pdmMetadata);
        DataModelDesignMeta diagramDesignMeta = dataModelDesignMetas.size() > 1 ? (DataModelDesignMeta)dataModelDesignMetas.get(1) : null;
        this.handlerDesignMeta((DataModelDesignMeta)dataModelDesignMetas.get(0));
        this.handlerDesignMeta(diagramDesignMeta);
        List currentDeployFile = DeployPDMMetadataDao.getDataModelMetadata((DataModelDesignMeta)((DataModelDesignMeta)dataModelDesignMetas.get(0)), (DataModelDesignMeta)diagramDesignMeta);
        String lastXml = ((DeployFile)baseDeployFile.get(0)).getFileContent();
        String currentXml = currentDeployFile == null ? "" : ((DeployFile)currentDeployFile.get(0)).getFileContent();
        try {
            PDMModelCompare pdModelCompare = new PDMModelCompare();
            sqlParameter = pdModelCompare.comparePDModel(pdmMetadata);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            log.error((Throwable)e);
            return;
        }
        this.getPageCache().put("submitContent", SerializationUtils.toJsonString((Object)content));
        Map dmMeta = (Map)content.get("dmmeta");
        String number = (String)dmMeta.get("Number");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DM_SUBMIT);
        parameter.setCustomParam("openType", (Object)"designer");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SQL_CALL_BACK));
        parameter.setCustomParam("number", (Object)number);
        parameter.setCustomParam("lastXml", (Object)lastXml);
        parameter.setCustomParam("currentXml", (Object)currentXml);
        parameter.setCustomParam("oldCommitId", (Object)ResManager.loadKDString((String)"\u57fa\u51c6\u6a21\u578b", (String)"DataModelDesignerPlugin_7", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("newCommitId", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b", (String)"DataModelDesignerPlugin_8", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("sqlParameter", sqlParameter);
        this.getView().showForm(parameter);
    }

    private void handlerDesignMeta(DataModelDesignMeta designMeta) {
        if (designMeta == null) {
            return;
        }
        if (designMeta.getMasterId() == null) {
            designMeta.setMasterId("");
        }
        if (designMeta.getProduct() == null) {
            designMeta.setProduct("");
        }
        if (designMeta.getType() == null) {
            designMeta.setType("");
        }
        if (designMeta.getDescription() == null) {
            designMeta.setDescription("");
        }
        if (designMeta instanceof PDMEntityDesignMeta && ((PDMEntityDesignMeta)designMeta).getProductVer() == null) {
            ((PDMEntityDesignMeta)designMeta).setProductVer("");
        }
    }

    private String buildXml(PDMEntityMetadata metadata) {
        MetadataSerializer serializer = new MetadataSerializer(MODEL_TYPE);
        return serializer.buildDiffXml((Object)metadata, null, false);
    }

    private void showValidatorInfo(Map<String, Object> result) {
        boolean isSuccess = false;
        boolean isWarn = false;
        if (result.get(SUCCESS) != null && ((Boolean)result.get(SUCCESS)).booleanValue()) {
            isSuccess = true;
            if (result.get(WARN) != null && ((Boolean)result.get(WARN)).booleanValue()) {
                isWarn = true;
            }
        } else {
            Object errorList = result.get(MESSAGE);
            if (!(errorList instanceof List)) {
                this.getView().showErrorNotification(errorList.toString());
                return;
            }
        }
        if (isWarn || !isSuccess) {
            this.showResult(result);
        }
    }

    private void showResult(Map<String, Object> result) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DM_RESULT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String params = SerializationUtils.toJsonString(result);
        parameter.setCustomParam("params", (Object)params);
        this.getView().showForm(parameter);
    }

    private void showHistory() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(BOS_DATAMODEL_LOG_LAYOUT);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("880px");
        styleCss.setHeight("600px");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u6a21\u578b\u5386\u53f2\u8bb0\u5f55", (String)"DataModelDesignerPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HISTORY_CALL_BACK));
        parameter.setCustomParam("dataModel", (Object)TRUE);
        parameter.setCustomParam("id", (Object)this.getModelId());
        parameter.setCustomParam("gray", (Object)AppGroupUtils.isGrayGroup());
        parameter.setCustomParam("prod", (Object)EnvTypeHelper.isProductEnv());
        parameter.setCustomParam("deploy", (Object)EnvTypeHelper.isDeploying());
        boolean currentIsv = this.checkCurrentIsv();
        boolean isvIsSame = this.checkIsvIsSame();
        parameter.setCustomParam("currentIsvIsBank", (Object)currentIsv);
        parameter.setCustomParam("isvIsSame", (Object)isvIsSame);
        parameter.setCustomParam(LOCK_MESSAGE, (Object)this.getPageCache().get(LOCK_MESSAGE));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean checkIsvIsSame() {
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        DataModelDesignMeta designMeta = reader.loadEntityDesignMeta(this.getModelId());
        String metadataIsv = designMeta.getIsv();
        String currentIsv = ISVService.getISVInfo().getId();
        return StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv);
    }

    private boolean validator() {
        if (!this.resourceCheck()) {
            return false;
        }
        if (!this.hasPermission()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6570\u636e\u6a21\u578b\u5217\u8868\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataModelDesignerPlugin_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (AppGroupUtils.isGrayGroup()) {
            String errorMsg = ResManager.loadKDString((String)"\u7070\u5ea6\u529f\u80fd\u4e0d\u5141\u8bb8\u7f16\u8f91\u6570\u636e\u6a21\u578b\u3002", (String)"DataModelDesignerPlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        if (this.isProductEnv()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u6570\u636e\u6a21\u578b\u3002", (String)"DataModelDesignerPlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        if (EnvTypeHelper.isDeploying()) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataModelDesignerPlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    private void showDataModel() {
        List dataModelDesignMeta = PDMDesignMetaDao.getDataModelDesignMeta((boolean)true);
        dataModelDesignMeta.removeIf(designMeta -> this.getModelId().equals(designMeta.getId()));
        ArrayList dataModel = new ArrayList(dataModelDesignMeta.size());
        for (DataModelDesignMeta designMeta2 : dataModelDesignMeta) {
            LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>(2);
            String modelId = designMeta2.getId();
            String name = designMeta2.getName();
            meta.put(modelId, name);
            dataModel.add(meta);
        }
        DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
        designer.setDataModel(dataModel);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (TABLE_CALL_BACK.equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
            designer.setTableInfo(returnData);
        } else if (SQL_CALL_BACK.equals(actionId) && e.getReturnData() != null) {
            DataModelDesignerData designerData = new DataModelDesignerData();
            Map content = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("submitContent"), Map.class);
            Map<String, Object> res = designerData.submit(content);
            if (((Boolean)res.get(SUCCESS)).booleanValue()) {
                String msg = (String)res.get(MESSAGE);
                try {
                    IPDMDesignMetaWriter writer = PDMDesignMetaVisitFactory.getPDMDesignMetaWriter();
                    ArrayList<PDMEntityMetadata> pdmMetadataList = new ArrayList<PDMEntityMetadata>(1);
                    pdmMetadataList.add(writer.convertToMetadata(content));
                    PDMDesignMetaDao.genDictionary(pdmMetadataList);
                }
                catch (Exception ex) {
                    msg = msg + ResManager.loadKDString((String)"\u751f\u6210\u6570\u636e\u5b57\u5178\u5931\u8d25\u3002", (String)"DataModelDesignerPlugin_9", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]) + "error\uff1a" + ex.getMessage();
                }
                this.getView().showSuccessNotification(msg);
                Map result = (Map)e.getReturnData();
                Map sqlMap = (Map)result.get("sqlMap");
                Map dmMeta = (Map)content.get("dmmeta");
                String id = (String)dmMeta.get("Id");
                String number = (String)dmMeta.get("Number");
                String bizAppId = (String)dmMeta.get("BizAppId");
                String submit = (String)result.get(SUBMIT);
                String description = (String)result.get("description");
                this.writeLog(id, number, submit, description);
            } else {
                this.getView().showErrorNotification((String)res.get(MESSAGE));
            }
        } else if (HISTORY_CALL_BACK.equals(actionId) && e.getReturnData() != null) {
            Map res = (Map)e.getReturnData();
            String action = (String)res.get("action");
            if (StringUtils.equals((CharSequence)"restore", (CharSequence)action)) {
                String status = (String)res.get("status");
                if (StringUtils.equals((CharSequence)SUCCESS, (CharSequence)status)) {
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.addAction("f5Refresh", null);
                } else {
                    String message = (String)res.get(MESSAGE);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fd8\u539f\u5931\u8d25\uff1a%s\u3002", (String)"DataModelDesignerPlugin_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), message));
                }
            }
        } else if (PARAM_PROPERTY_EDIT.equals(actionId) && e.getReturnData() != null) {
            DataModelDesigner designer = (DataModelDesigner)this.getView().getControl(DATA_MODEL_DESIGNER);
            Map returnData = (Map)e.getReturnData();
            designer.setProperty(returnData);
        }
    }

    private void writeLog(String id, String number, String submit, String description) {
        try {
            DataModelLogServiceImpl logService = new DataModelLogServiceImpl();
            logService.addDataModelLog(id, number, submit, description);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6570\u636e\u6a21\u578b\u63d0\u4ea4\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private boolean checkCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        return StringUtils.isBlank((CharSequence)currentIsv);
    }

    private boolean isProductEnv() {
        return EnvTypeHelper.isProductEnv();
    }

    /*
     * WARNING - void declaration
     */
    private String buildMsg(List<ErrorInfo> errorList) {
        void var4_7;
        ArrayList<String> list = new ArrayList<String>(10);
        for (ErrorInfo errorInfo : errorList) {
            list.add(errorInfo.getError());
        }
        StringBuilder str = new StringBuilder();
        for (String c : list) {
            str.append(c);
        }
        boolean bl = false;
        while (var4_7 < str.length() - 1) {
            if (str.charAt((int)var4_7) == '\u3002') {
                str.setCharAt((int)var4_7, '\uff0c');
            }
            ++var4_7;
        }
        return str.toString();
    }

    private String getModelId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(MODEL_ID);
    }

    private boolean resourceCheck() {
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return Boolean.FALSE;
        }
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        DataModelDesignMeta designMeta = reader.loadEntityDesignMeta(this.getModelId());
        String metadataIsv = designMeta.getIsv();
        if (StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv)) {
            if (!this.requireLock(designMeta.getId())) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"DataModelDesignerPlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        this.getView().showErrorNotification(errorMsg);
        return Boolean.FALSE;
    }

    private boolean hasPermission() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        return PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, (String)appId, (String)BOS_DM_MODELLIST, (String)"4715a0df000000ac") == 1;
    }

    private boolean requireLock(String modelId) {
        StringBuilder errorMsg = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo(modelId, "", "", FORMID_DESIGNER, "modify", true, "DataModelDesigner");
        boolean success = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errorMsg);
        if (!success) {
            Map<String, String> lockedInfo = this.getLockInfo(FORMID_DESIGNER, "modify", modelId);
            if (!CollectionUtils.isEmpty(lockedInfo) && StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)lockedInfo.get("userid")) && StringUtils.equals((CharSequence)"modify", (CharSequence)lockedInfo.get("opkey"))) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bd5", (String)"BillController_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f3a\u5236\u8e22\u51fa", (String)"BillController_1", (String)"bos-form-mvc", (Object[])new Object[0]));
                HashMap<String, String> lockedRequireInfo = new HashMap<String, String>(16);
                lockedRequireInfo.put("MUTEX_ENTITY_KEY", FORMID_DESIGNER);
                lockedRequireInfo.put("MUTEX_OPER_KEY", "modify");
                lockedRequireInfo.put("MUTEX_OBJ_ID", modelId);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("lockedConfirm", "kd.bos.designer.plugin.DMDesignerConfirmCallBackPlugin", MessageCallBackType.Class);
                this.getView().showConfirm(errorMsg.toString(), null, MessageBoxOptions.YesNo, null, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(lockedRequireInfo));
            } else {
                this.getView().showErrorNotification(errorMsg.toString());
            }
        }
        String lockMessage = success ? null : errorMsg.toString();
        this.getPageCache().put(LOCK_MESSAGE, lockMessage);
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getLockInfo(String entityKey, String operationKey, String objId) {
        if (!StringUtils.isNotBlank((CharSequence)entityKey)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)objId)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)operationKey)) return Collections.emptyMap();
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        try (DataMutex dataMutex = DataMutex.create();){
            Map map = dataMutex.getLockInfo(objId, groupId, entityKey);
            return map;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return Collections.emptyMap();
    }

    private void updateModelModifiedStatus(PDMEntityMetadata pdmMetadata) {
        String modifiedStr = this.getPageCache().get("MODIFIEDPROP");
        if (modifiedStr == null) {
            return;
        }
        Map modifiedPropMap = (Map)SerializationUtils.fromJsonString((String)modifiedStr, Map.class);
        if (modifiedPropMap.isEmpty()) {
            return;
        }
        for (DMPackageAp pkg : pdmMetadata.getPackageAps()) {
            List tableAps = pkg.getTableAps();
            for (TableAp tableAp : tableAps) {
                List propList = (List)modifiedPropMap.get(tableAp.getTableName());
                if (propList == null || propList.isEmpty()) continue;
                for (ColumnAp col : tableAp.getColumns()) {
                    if (!propList.contains(col.getColumnName())) continue;
                    col.setModified(true);
                }
                for (IndexAp indexAp : tableAp.getIndexs()) {
                    if (!propList.contains(indexAp.getIndexName())) continue;
                    indexAp.setModified(true);
                }
                PrimaryKeyAp pkAp = tableAp.getPrimaryKey();
                if (!propList.contains(pkAp.getPk())) continue;
                pkAp.setModified(true);
            }
        }
    }
}

