/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.DataModelDesignMeta;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.designer.plugin.log.DataModelLogDao;
import kd.bos.designer.plugin.log.DataModelLogServiceImpl;
import kd.bos.designer.utils.DataModelUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.git.GitSaveFileHandler;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.systree.AppTree;
import kd.bos.util.ExceptionUtils;

public class DataModelListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(DataModelListPlugin.class);
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final String EntityId_App = "bos_devportal_bizapp";
    private static final String EntityId_User = "bos_user";
    private static final String BAR_NEW = "new";
    private static final String BAR_EXTEND = "extend";
    private static final String BAR_MODIFY = "modify";
    private static final String BAR_EXPORT = "export";
    private static final String BAR_IMPORT = "import";
    private static final String BAR_DELETE = "delete";
    private static final String BAR_REFRESH = "refresh";
    private static final String BAR_IMPORT_PDM = "importpdm";
    private static final String BAR_DBNEW = "dbnew";
    private static final String BAR_HISTORY = "history";
    private static final String Key_TreeEntryEntity = "treeentryentity";
    private static final String Key_TreeView = "treeviewap";
    private static final String Key_Search = "search";
    private static final String Key_SearchCloud = "searchcloud";
    protected static final String Key_root_Id = "rootNode";
    private static final String CacheId_CurrNode = "currnode";
    private static final String KEY_ID = "id";
    private static final String Key_Number = "number";
    private static final String Key_Name = "name";
    private static final String Key_Description = "description";
    private static final String CODE_MANAGE = "codemanage";
    private static final String GIT_OPERATE = "gitoperate";
    private static final String COMMIT = "commit";
    private static final String PUSH = "push";
    private static final String PULL = "pull";
    private static final String REVERT = "revert";
    private static final String LOG = "log";
    private static final String GIT = "git";
    private static final String GIT_SESSIONID = "gitSessionId";
    private static final String GIT_MSG = "gitmsg";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZAPPNUMBER = "bizappnumber";
    private static final String GITOPERATEKEY = "gitoperatekey";
    private static final String GITOPERATEID = "gitoperateid";
    private static final String GITOPERATETYPE = "gitoperatetype";
    private static final String GITMANAGECLOSECALLBACK = "gitmanageclosecallback";
    private static final String GIT_COMMIT_NEW_CALLBACK = "gitCommitNewCallBack";
    private static final String GIT_COMMIT_PUSH_CONFIRM_BACK = "gitCommitAndPushConfirmBack";
    private static final String GIT_PULL_UPDATE_METADATA_CALL_BACK = "gitPullUpdateMetaCallBack";
    private static final String GIT_RESTORE_CALL_BACK = "gitRestoreCallBack";
    private static final String GIT_PUSH_NEW_CALLBACK = "gitPushNewCallBack";
    private static final String GIT_OPERATE_CALL_BACK = "gitOperateCallBack";
    private static final String GIT_PULL_CONFLICT_CALLBACK = "gitPullConflictCallBack";
    private static final String BOS_DATAMODEL_LOG_LAYOUT = "bos_datamodel_log_layout";
    private static final String LOG_CALL_BACK = "logCallBack";
    private static final String SQL_CALL_BACK = "SQL_CALL_BACK";
    private static final String TRUE = "true";
    private static final String MODEL_COMPARE = "modelcompare";
    private static final String BOS_DM_COMPARE = "bos_dm_compare";
    private static final String MODEL_DATABASE_COMPARE_CALL_BACK = "modelDataBaseCallBack";
    private static final String BRANCH_COMPARE = "branchcompare";
    private static final String SUCCESS = "success";
    private TreeNode rootNode;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbar_main"});
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_Search);
        search.addEnterListener((SearchEnterListener)this);
        Search searchCloud = (Search)this.getControl(Key_SearchCloud);
        searchCloud.addEnterListener((SearchEnterListener)this);
        EntryGrid treeGrid = (EntryGrid)this.getView().getControl(Key_TreeEntryEntity);
        treeGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildTree();
        this.refreshView();
        this.initGit();
    }

    private void initGit() {
        DevportalCommonUtil.isGitManageType();
        boolean isGit = DevportalCommonUtil.isGitManageType();
        if (!isGit) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GIT_OPERATE});
        }
        if (!ISVServiceHelper.isKingdeeISV()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DBNEW});
        }
    }

    public void afterBindData(EventObject e) {
        boolean isGit = DevportalCommonUtil.isGitManageType();
        if (isGit) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.getClientLocalStorage(GIT_MSG);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key;
            Donothing op = (Donothing)args.getSource();
            switch (key = op.getOperateKey()) {
                case "new": {
                    this.newModel();
                    break;
                }
                case "extend": {
                    this.extendModel();
                    break;
                }
                case "modify": {
                    this.modify();
                    break;
                }
                case "delete": {
                    this.deleteConfirm();
                    break;
                }
                case "export": {
                    this.exportModel();
                    break;
                }
                case "import": {
                    this.importModel();
                    break;
                }
                case "importpdm": {
                    this.importPDMModel();
                    break;
                }
                case "dbnew": {
                    this.dbNew();
                    break;
                }
                case "history": {
                    this.showLog();
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.refreshView();
                break;
            }
            case "commit": 
            case "push": 
            case "pull": 
            case "revert": 
            case "log": {
                this.gitOperate(key);
                break;
            }
            case "modelcompare": {
                this.modelCompare();
                break;
            }
            case "branchcompare": {
                this.branchCompare();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (GIT_COMMIT_PUSH_CONFIRM_BACK.equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.handleGitCommitAndPushConfirmBack();
        } else if (GIT_OPERATE_CALL_BACK.equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.handleGitOperateConfirmCallBack();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String action;
        super.closedCallBack(closedCallBackEvent);
        switch (action = closedCallBackEvent.getActionId()) {
            case "importModelcallback": 
            case "importPDMModelcallback": 
            case "newModelCallBack": 
            case "extendModelCallBack": 
            case "dbNewModelCallBack": 
            case "modifyModelCallBack": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) break;
                this.refreshView();
                String modelId = (String)returnData.get("modelId");
                String number = (String)returnData.get(Key_Number);
                this.writeLog(modelId, number);
                this.markTargetPage(modelId);
                if ("newModelCallBack".equalsIgnoreCase(action)) {
                    this.openDesigner(modelId);
                }
                this.importCallBack(action, returnData);
                break;
            }
            case "datamodelDeleteCallback": {
                Map deleteData = (Map)closedCallBackEvent.getReturnData();
                if (deleteData == null || !((Boolean)deleteData.get(SUCCESS)).booleanValue()) break;
                this.refreshView();
                String modelId = (String)deleteData.get("modelId");
                this.deleteDataModelLog(modelId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataModelListPlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            case "gitCommitNewCallBack": {
                this.handleGitCommitNewCallBack(closedCallBackEvent);
                break;
            }
            case "gitPullUpdateMetaCallBack": {
                this.handleGitPullUpdateMetaCallBack(closedCallBackEvent);
                break;
            }
            case "gitRestoreCallBack": {
                this.handleGitRestoreCallBack(closedCallBackEvent);
                break;
            }
            case "gitPushNewCallBack": {
                this.handleGitPushCallBack(closedCallBackEvent);
                break;
            }
            case "gitPullConflictCallBack": {
                this.handleGitPullConflictCallBack(closedCallBackEvent);
                break;
            }
            case "logCallBack": {
                this.logCallBack(closedCallBackEvent);
                break;
            }
            case "SQL_CALL_BACK": {
                this.sqlCallBack(closedCallBackEvent);
                break;
            }
            case "modelDataBaseCallBack": {
                this.modelDataBaseCallBack(closedCallBackEvent);
            }
        }
    }

    private void sqlCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            Map result = (Map)e.getReturnData();
            Object exportSql = result.get("exportSql");
            Map sqlMap = (Map)result.get("sqlMap");
            String id = (String)result.get("modelId");
            String number = (String)result.get(Key_Number);
            String bizAppId = (String)result.get("bizAppId");
            if (TRUE.equals(exportSql)) {
                Map<String, Object> exportRes = DataModelUtils.exportSource(id, number, bizAppId, sqlMap, "sql");
                if (((Boolean)exportRes.get(SUCCESS)).booleanValue()) {
                    String url = (String)exportRes.get("urls");
                    this.getView().download(url);
                } else {
                    String msg = (String)exportRes.get("msg");
                    this.getView().showTipNotification(msg);
                }
            }
        }
    }

    private void modelDataBaseCallBack(ClosedCallBackEvent e) {
        this.sqlCallBack(e);
    }

    private void logCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            Map res = (Map)e.getReturnData();
            if ("close".equals(res.get("action"))) {
                return;
            }
            String number = (String)res.get(Key_Number);
            Map sqlParameter = (Map)res.get("sqlParameter");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_dm_submit");
            parameter.setCaption(ResManager.loadKDString((String)"\u751f\u6210\u5dee\u91cf\u811a\u672c", (String)"DataModelListPlugin_15", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SQL_CALL_BACK));
            parameter.setCustomParam("sqlParameter", (Object)sqlParameter);
            parameter.setCustomParam(Key_Number, (Object)number);
            parameter.setCustomParam("openType", (Object)"modelList");
            parameter.setCustomParam("modelId", res.get("modelId"));
            parameter.setCustomParam(Key_Number, res.get(Key_Number));
            parameter.setCustomParam("bizAppId", res.get("bizAppId"));
            this.getView().showForm(parameter);
        }
    }

    private void importCallBack(String action, Map<String, Object> returnData) {
        if (("importPDMModelcallback".equals(action) || "importModelcallback".equals(action)) && returnData.get(SUCCESS) != null && ((Boolean)returnData.get(SUCCESS)).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"AbstractDataModelImportPlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void handleGitCommitNewCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            Map res = (Map)e.getReturnData();
            String result = (String)res.get("result");
            if (SUCCESS.equals(result)) {
                String modelId = this.getSelectedModelId();
                DataModelLogDao.updateGitCommitStatus(modelId);
            }
            this.invokeGitProxy(GIT_COMMIT_NEW_CALLBACK, e);
        }
    }

    private void handleGitCommitAndPushConfirmBack() {
        this.invokeGitProxy(GIT_COMMIT_PUSH_CONFIRM_BACK, "");
    }

    private void handleGitRestoreCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            this.invokeGitProxy(GIT_RESTORE_CALL_BACK, e);
        }
    }

    private void deleteDataModelLog(String modelId) {
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return;
        }
        DataModelLogDao.deleteDataModelLog(modelId);
    }

    private void handleGitOperateConfirmCallBack() {
        JSONObject gitInfo = JSONObject.parseObject((String)this.getPageCache().get("gitinfo"));
        String id = gitInfo.getString(GITOPERATEID);
        String type = gitInfo.getString(GITOPERATETYPE);
        String operateKey = gitInfo.getString(GITOPERATEKEY);
        String sessionId = gitInfo.getString("gitoperatesessionid");
        this.getPageCache().remove("gitinfo");
        GitOperationUtil.beforeGitOperate((String)operateKey, (String)id, (String)type, (String)sessionId, (AbstractFormPlugin)this);
    }

    private void handleGitPullUpdateMetaCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            String gitContext = (String)e.getReturnData();
            GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
            if (context.getPullUpdate()) {
                GitOperationUtils.updateMetadata((GitContext)context, (AbstractFormPlugin)this);
            }
            if (context.isExportToLocal()) {
                GitSaveFileHandler saveFileHandler = new GitSaveFileHandler();
                saveFileHandler.handler(context, (AbstractFormPlugin)this);
            }
        }
    }

    private void handleGitPushCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            this.invokeGitProxy(GIT_PUSH_NEW_CALLBACK, e);
        }
    }

    private void handleGitPullConflictCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            this.invokeGitProxy(GIT_PULL_CONFLICT_CALLBACK, e);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map param = e.getParam();
        if (GIT_MSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String gitSessionId = (String)param.get("actonResult");
                this.getPageCache().put(GIT_SESSIONID, gitSessionId);
            } else {
                this.getPageCache().put(GIT_SESSIONID, "");
            }
        }
    }

    private void writeLog(String id, String number) {
        try {
            DataModelLogServiceImpl logService = new DataModelLogServiceImpl();
            logService.addDataModelLog(id, number, null, null);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u6a21\u578b\u63d0\u4ea4\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private void renderModelList(QFilter[] qFilters) {
        IDataEntityType mDesignMetaType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        ORM orm = ORM.create();
        orm.setDataEntityType(mDesignMetaType.getName(), mDesignMetaType);
        HashMap originMetaMap = new HashMap(10);
        HashMap master4Ext = new HashMap(16);
        AtomicInteger rowCount = new AtomicInteger();
        HashSet userIdList = new HashSet(16);
        HashSet bizAppIdList = new HashSet(16);
        Throwable throwable = null;
        try (DataSet ds = orm.queryDataSet("DataModelListPlugin.render", mDesignMetaType.getName(), "id,name,masterId,isv,version,bizAppId,number,product,modifierId,modifyDate,creator,createdDate,dataXml,description", qFilters);){
            ds.forEach(row -> {
                PDMEntityDesignMeta meta = this.convert((Row)row);
                String masterId = meta.getMasterId();
                userIdList.add(meta.getCreator());
                userIdList.add(meta.getModifierId());
                bizAppIdList.add(meta.getBizappId());
                if (StringUtils.isNotBlank((CharSequence)masterId)) {
                    ArrayList<PDMEntityDesignMeta> list = (ArrayList<PDMEntityDesignMeta>)master4Ext.get(masterId);
                    if (list == null) {
                        list = new ArrayList<PDMEntityDesignMeta>(10);
                    }
                    list.add(meta);
                    master4Ext.put(masterId, list);
                } else {
                    originMetaMap.put(meta.getId(), meta);
                }
                rowCount.getAndIncrement();
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : master4Ext.entrySet()) {
            List list = (List)entry.getValue();
            list.forEach(meta -> {
                if (!originMetaMap.containsKey(meta.getMasterId())) {
                    originMetaMap.put(meta.getId(), meta);
                }
            });
        }
        this.getModel().deleteEntryData(Key_TreeEntryEntity);
        if (rowCount.get() <= 0) {
            return;
        }
        MainEntityType userDt = EntityMetadataCache.getDataEntityType((String)EntityId_User);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)EntityId_App);
        Map users = BusinessDataReader.loadFromCache((Object[])userIdList.toArray(), (DynamicObjectType)userDt);
        Map apps = BusinessDataReader.loadFromCache((Object[])bizAppIdList.toArray(), (DynamicObjectType)mainEntityType);
        this.getModel().batchCreateNewEntryRow(Key_TreeEntryEntity, rowCount.get());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_TreeEntryEntity);
        int index = 0;
        for (Map.Entry entry : originMetaMap.entrySet()) {
            PDMEntityDesignMeta designMeta = (PDMEntityDesignMeta)entry.getValue();
            DynamicObject row2 = (DynamicObject)entryEntity.get(index);
            this.renderRow(row2, designMeta, 0L, users, apps);
            ++index;
            List extList = (List)master4Ext.get(designMeta.getId());
            if (extList == null) continue;
            long pid = row2.getLong(KEY_ID);
            for (PDMEntityDesignMeta ext : extList) {
                row2 = (DynamicObject)entryEntity.get(index);
                this.renderRow(row2, ext, pid, users, apps);
                ++index;
            }
        }
        this.getView().updateView(Key_TreeEntryEntity);
    }

    private void renderRow(DynamicObject row, PDMEntityDesignMeta designMeta, long pid, Map<Object, DynamicObject> users, Map<Object, DynamicObject> apps) {
        row.set("pid", (Object)pid);
        row.set("modelid", (Object)designMeta.getId());
        row.set(Key_Number, (Object)designMeta.getNumber());
        row.set(Key_Name, (Object)designMeta.getName());
        DynamicObject app = apps.get(designMeta.getBizappId());
        row.set("bizapp", (Object)app);
        row.set(Key_Description, (Object)designMeta.getDescription());
        row.set("dbms", (Object)0);
        row.set("isv", (Object)designMeta.getIsv());
        row.set("product", (Object)designMeta.getProduct());
        DynamicObject user = users.get(designMeta.getCreator());
        row.set("creater", (Object)user);
        row.set("createdate", (Object)designMeta.getCreatedDate());
        row.set("masterid", (Object)designMeta.getMasterId());
        DynamicObject modifierUser = users.get(designMeta.getModifierId());
        row.set("modifier", (Object)modifierUser);
        row.set("modifydate", (Object)designMeta.getModifyDate());
    }

    private PDMEntityDesignMeta convert(Row row) {
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        PDMEntityDesignMeta designMeta = (PDMEntityDesignMeta)dataEntityType.createInstance();
        designMeta.setId(row.getString(0));
        designMeta.setName(row.getString(1));
        designMeta.setMasterId(row.getString(2));
        designMeta.setIsv(row.getString(3));
        designMeta.setVersion(row.getLong(4).longValue());
        designMeta.setBizappId(row.getString(5));
        designMeta.setNumber(row.getString(6));
        designMeta.setProduct(row.getString(7));
        designMeta.setModifierId(row.getLong(8).longValue());
        designMeta.setModifyDate((Date)row.getTimestamp(9));
        designMeta.setCreator(row.getLong(10).longValue());
        designMeta.setCreatedDate((Date)row.getTimestamp(11));
        designMeta.setDataXml(row.getString(12));
        designMeta.setDescription(row.getString(13));
        return designMeta;
    }

    private String getSelectedModelId() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(Key_TreeEntryEntity);
        int[] selRows = grid.getSelectRows();
        if (selRows == null || selRows.length < 1) {
            return null;
        }
        int index = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        Object value = this.getModel().getValue("modelid", index);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private void newModel() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b", (String)"DataModelListPlugin_9", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        parameter.setFormId("bos_modellist_create");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newModelCallBack"));
        this.getView().showForm(parameter);
    }

    private void dbNew() {
        if (!ISVServiceHelper.isKingdeeISV()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd\u3002", (String)"DataModelListPlugin_8", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_modellist_dbnew");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dbNewModelCallBack"));
        this.getView().showForm(parameter);
    }

    private void showLog() {
        String modelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(BOS_DATAMODEL_LOG_LAYOUT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("880px");
        styleCss.setHeight("600px");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setCaption(ResManager.loadKDString((String)"\u6a21\u578b\u5386\u53f2\u8bb0\u5f55", (String)"DataModelDesignerPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LOG_CALL_BACK));
        parameter.setCustomParam("dataModel", (Object)TRUE);
        parameter.setCustomParam(KEY_ID, (Object)modelId);
        parameter.setCustomParam("gray", (Object)AppGroupUtils.isGrayGroup());
        parameter.setCustomParam("prod", (Object)EnvTypeHelper.isProductEnv());
        parameter.setCustomParam("deploy", (Object)EnvTypeHelper.isDeploying());
        boolean currentIsv = this.checkCurrentIsv();
        boolean isvIsSame = this.checkIsvIsSame(modelId);
        parameter.setCustomParam("currentIsvIsBank", (Object)currentIsv);
        parameter.setCustomParam("isvIsSame", (Object)isvIsSame);
        parameter.setCustomParam("openType", (Object)"modelList");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean checkCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        return StringUtils.isBlank((CharSequence)currentIsv);
    }

    private boolean checkIsvIsSame(String modelId) {
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        DataModelDesignMeta designMeta = reader.loadEntityDesignMeta(modelId);
        String metadataIsv = designMeta.getIsv();
        String currentIsv = ISVService.getISVInfo().getId();
        return StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv);
    }

    private void extendModel() {
        String modelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String currIsv = ISVService.getISVInfo().getId();
        int index = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        String modelIsv = (String)this.getModel().getValue("isv", index);
        if (currIsv.equalsIgnoreCase(modelIsv)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u578b\u5f00\u53d1\u5546\u4e0e\u5f53\u524d\u73af\u5883\u5f00\u53d1\u5546\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6269\u5c55\u3002", (String)"DataModelListPlugin_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int count = PDMDesignMetaDao.getParalleExtCountByIsv((String)modelId, (String)currIsv);
        if (count > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u53ea\u80fd\u6269\u5c551\u6b21\u3002", (String)"DataModelListPlugin_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        DataModelDesignMeta designMeta = reader.loadEntityDesignMeta(modelId);
        if ("2".equals(designMeta.getType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6269\u5c55\u6a21\u578b\u6682\u4e0d\u652f\u6301\u6269\u5c55\u3002", (String)"DataModelListPlugin_7", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp", index);
        String bizAppId = bizApp == null ? "" : bizApp.getString(KEY_ID);
        String number = (String)this.getModel().getValue(Key_Number);
        String name = (String)this.getModel().getValue(Key_Name);
        String description = (String)this.getModel().getValue(Key_Description);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u6269\u5c55\u6a21\u578b", (String)"DataModelListPlugin_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        parameter.setFormId("bos_modellist_create");
        parameter.setCustomParam("createType", (Object)BAR_EXTEND);
        parameter.setCustomParam("modelId", (Object)modelId);
        parameter.setCustomParam(Key_Number, (Object)number);
        parameter.setCustomParam(Key_Name, (Object)name);
        parameter.setCustomParam(Key_Description, (Object)description);
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "extendModelCallBack"));
        this.getView().showForm(parameter);
    }

    private boolean isSameIsv() {
        String currIsv = ISVService.getISVInfo().getId();
        int index = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        String modelIsv = (String)this.getModel().getValue("isv", index);
        return currIsv.equals(modelIsv);
    }

    private void modify() {
        String modelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        String number = (String)this.getModel().getValue(Key_Number, index);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_modellist_modify");
        parameter.setCustomParam("modelId", (Object)modelId);
        parameter.setCustomParam(Key_Number, (Object)number);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyModelCallBack"));
        this.getView().showForm(parameter);
    }

    private void openDesigner() {
        String modelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.openDesigner(modelId);
    }

    private void openDesigner(String modelId) {
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_modelasset_designer");
        parameter.setCustomParam("modelId", (Object)modelId);
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    private void exportModel() {
        String modelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.isSameIsv()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u4e0d\u652f\u6301\u5bfc\u51fa\u3002", (String)"DataModelListPlugin_12", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map<String, Object> map = DataModelUtils.exportSource(modelId, modelId);
        int index = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        String number = (String)this.getModel().getValue(Key_Number, index);
        DataModelUtils.addLog("bos_dm_modellist", "\u5bfc\u51fa", String.format("\u5bfc\u51fa\u6570\u636e\u6a21\u578b%s", number));
        boolean success = (Boolean)map.get(SUCCESS);
        if (success) {
            this.getView().openUrl((String)map.get("urls"));
        } else {
            this.getView().showErrorNotification((String)map.get("msg"));
        }
    }

    private void importModel() {
        String bizAppId = "";
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_dm_import");
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importModelcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void importPDMModel() {
        String bizAppId = "";
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_dm_importpage");
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPDMModelcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void deleteConfirm() {
        IPDMDesignMetaReader reader;
        DataModelDesignMeta designMeta;
        String modelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean exist = PDMDesignMetaDao.modelExist((String)modelId, (IDataEntityType)OrmUtils.getDataEntityType(PDMEntityDesignMeta.class));
        if (!exist) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c\u3002", (String)"DataModelListPlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String currIsv = ISVService.getISVInfo().getId();
        if (!currIsv.equalsIgnoreCase((designMeta = (reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader()).loadEntityDesignMeta(modelId)).getIsv())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"DataModelListPlugin_11", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean existsExt = PDMDesignMetaDao.modelExistExt((String)modelId, (IDataEntityType)OrmUtils.getDataEntityType(PDMEntityDesignMeta.class));
        if (existsExt) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u5b58\u5728\u6269\u5c55\u6a21\u578b\uff0c\u8bf7\u5148\u5220\u9664\u6269\u5c55\u6a21\u578b\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DataModelListPlugin_10", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_modellist_del");
        parameter.setCustomParam("modelId", (Object)modelId);
        parameter.setCustomParam("modelNumber", (Object)designMeta.getNumber());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "datamodelDeleteCallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void markTargetPage(String modelId) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(Key_TreeEntryEntity);
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            int rowIndex = this.findRowById(modelId);
            grid.selectRows(rowIndex, true);
            String masterId = (String)this.getModel().getValue("masterid", rowIndex);
            if (StringUtils.isNotBlank((CharSequence)masterId)) {
                int masterIndex = this.findRowById(masterId);
                grid.expand(masterIndex);
            }
        }
    }

    private int findRowById(String modelId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_TreeEntryEntity);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryEntity.get(i);
            if (!modelId.equals(info.getString("modelid"))) continue;
            return i;
        }
        return -1;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CacheId_CurrNode))) {
            return;
        }
        this.refreshView(newNodeId, "");
        this.getPageCache().put(CacheId_CurrNode, newNodeId);
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        this.openDesigner();
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)Key_Search, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.refreshView("", searchText);
            TreeNode root = new TreeNode();
            root.setId(Key_root_Id);
            TreeView tv = (TreeView)this.getControl(Key_TreeView);
            tv.focusNode(root);
        } else if (StringUtils.equals((CharSequence)Key_SearchCloud, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            TreeNode root = this.getRootNode();
            List clouds = root.getChildren();
            ArrayList<TreeNode> newClouds = new ArrayList<TreeNode>(10);
            if (StringUtils.isBlank((CharSequence)searchText)) {
                newClouds.addAll(clouds);
            } else if (clouds != null) {
                for (TreeNode node : clouds) {
                    String name = node.getText();
                    if (!StringUtils.isNotBlank((CharSequence)name) || !name.contains(searchText)) continue;
                    newClouds.add(node);
                }
            }
            root.setChildren(newClouds);
            TreeView tView = (TreeView)this.getControl(Key_TreeView);
            tView.updateNode(root);
        }
    }

    private void refreshView() {
        this.refreshView("", "");
    }

    private void refreshView(String nodeId, String searchText) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.isNotBlank((CharSequence)nodeId) && !Key_root_Id.equals(nodeId)) {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            List appIds = bizAppService.getAppsIdByCloudId(nodeId);
            filters.add(new QFilter("bizAppId", "in", (Object)appIds));
        }
        String searchContent = String.format("%s%s%s", "%", searchText, "%");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            QFilter numberFilter = new QFilter(Key_Number, "like", (Object)searchContent);
            numberFilter.or(new QFilter(Key_Name, "like", (Object)searchContent));
            numberFilter.or(new QFilter(KEY_ID, "like", (Object)searchContent));
            filters.add(numberFilter);
        }
        this.renderModelList(filters.toArray(new QFilter[filters.size()]));
    }

    private void gitOperate(String operateKey) {
        String currentAppId = this.getCurrentAppId();
        if (StringUtils.isBlank((CharSequence)currentAppId)) {
            return;
        }
        String sessionId = this.getPageCache().get(GIT_SESSIONID);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + "gitusername");
        }
        JSONObject arg = new JSONObject();
        arg.put(BIZAPPID, (Object)currentAppId);
        arg.put(GITOPERATEKEY, (Object)operateKey);
        arg.put(GIT_MSG, (Object)sessionId);
        arg.put("type", (Object)"dataModel");
        this.getPageCache().put("modelId", this.getSelectedModelId());
        this.invokeGitProxy("gitOperate", arg);
    }

    private void modelCompare() {
        String selectedModelId = this.getSelectedModelId();
        if (StringUtils.isBlank((CharSequence)selectedModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DM_COMPARE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("modelId", (Object)selectedModelId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MODEL_DATABASE_COMPARE_CALL_BACK));
        this.getView().showForm(parameter);
    }

    private void branchCompare() {
        String selectedModelId = this.getSelectedModelId();
        this.getPageCache().put("compareModelId", selectedModelId);
        this.gitOperate(BRANCH_COMPARE);
    }

    private void codeManage() {
        String codeManageType = DevportalCommonUtil.getCodeManageType();
        if (!GIT.equals(codeManageType)) {
            this.getView().showTipNotification("\u7248\u672c\u7ba1\u7406\u6682\u65f6\u53ea\u652f\u6301Git");
            return;
        }
        String currentAppId = this.getCurrentAppId();
        if (currentAppId == null) {
            return;
        }
        String bizAppNumber = MetadataDao.getAppNumberByAppId((String)currentAppId);
        String sessionId = this.getPageCache().get(GIT_SESSIONID);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = SessionManager.getCurrent().get(GitOperationUtil.getSessionByRequestContext() + "gitusername");
        }
        JSONObject arg = new JSONObject();
        arg.put(BIZAPPID, (Object)currentAppId);
        arg.put(GIT_MSG, (Object)sessionId);
        arg.put(BIZAPPNUMBER, (Object)bizAppNumber);
        this.invokeGitProxy("gitManagerNew", arg);
    }

    private void invokeGitProxy(String methodName, Object arg) {
        Map<String, Object> proxy = this.getGitAppPluginProxy();
        if (proxy == null) {
            this.getView().showTipNotification("\u7a0b\u5e8f\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7");
            return;
        }
        try {
            Method method = (Method)proxy.get("method");
            Object object = proxy.get("object");
            method.invoke(object, methodName, new Object[]{arg});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private Map<String, Object> getGitAppPluginProxy() {
        try {
            Class<?> proxy = Class.forName("kd.bos.devportal.git.proxy.GitAppPluginProxy");
            Method method = proxy.getDeclaredMethod("invoke", String.class, Object[].class);
            Constructor<?> constructor = proxy.getDeclaredConstructor(AbstractFormPlugin.class);
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(new Object[]{this});
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("method", method);
            map.put("object", instance);
            return map;
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u83b7\u53d6GitAppPluginProxy\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private void buildTree() {
        TreeNode node = this.getRootNode();
        TreeView tView = (TreeView)this.getControl(Key_TreeView);
        tView.addNode(node);
    }

    private TreeNode getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        AppTree appTree = new AppTree();
        appTree.setMoveNullChilden(false);
        this.rootNode = appTree.loadTree((parentId, nodeInfo) -> {
            if (parentId.equals(Key_root_Id) && nodeInfo == null) {
                String rootNodeName = ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"DataModelListPlugin_16", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
                return new TreeNode("", Key_root_Id, rootNodeName, (Object)"root");
            }
            if (nodeInfo instanceof AppInfo) {
                return null;
            }
            return new TreeNode(parentId, nodeInfo.getId(), nodeInfo.getName().getLocaleValue(), nodeInfo);
        });
        this.rootNode.setIsOpened(true);
        return this.rootNode;
    }

    private String getCurrentAppId() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(Key_TreeEntryEntity);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelListPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(Key_TreeEntryEntity);
        Object value = this.getModel().getValue("bizapp", entryCurrentRowIndex);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getPkValue().toString();
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u7684\u5e94\u7528id\u4e3a\u7a7a\u3002", (String)"DataModelListPlugin_14", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        return null;
    }
}

