/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.metadata.DMMetaCategory;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.pdm.model.PDModel;
import kd.bos.db.DBRoute;
import kd.bos.designer.dao.DataModelDesignerData;
import kd.bos.designer.plugin.DBToDataModelConverter;
import kd.bos.designer.plugin.PDMModelCompare;
import kd.bos.designer.plugin.compare.DataModelCompareImpl;
import kd.bos.designer.plugin.compare.PDModelUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataSerializer;

public class DataModelMergePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(DataModelMergePlugin.class);
    private static final String TREE_VIEW = "treeviewap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TREE_N0DE_CACHE = "treeNodeCache";
    private static final String ELEMENT_KEY = "elementkey";
    private static final String PROPERTY_KEY = "propertykey";
    private static final String BASE_VALUE = "basevalue";
    private static final String CURR_VALUE = "currvalue";
    private static final String DATA_MODEL_ENTITY = "baseEntity";
    private static final String DATA_BASE_ENTITY = "currEntity";
    private static final String DIFF = "diff";
    private static final String SQL = "sql";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";
    private static final String BTN_OK = "btnok";
    private static final String TABAP = "tabap";
    private static final String BOS_DM_SQL = "bos_dm_sql";
    private static final String SQL_FLEX = "sqlflex";
    private static final String TABLE = "table";
    private static final String SEARCH = "searchap";
    private static final String SEARCH_TEXT = "searchText";
    private static final String SEARCH_INDEX = "searchIndex";
    private static final String NODE_LIST = "nodeList";
    private static final String MODEL_NUMBER = "modelNumber";
    private static final String BIZAPP_ID = "bizappId";
    private static final String NODE_COLOR_ADD = "#1BA854";
    private static final String NODE_COLOR_REMOVE = "#FB2323";
    private static final String NODE_COLOR_EDIT = "#FF991C";
    private static final String IS_ERROR_STATUS = "isErrorStatus";
    private static final String TRUE = "true";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.setRestrictCheckEffectiveArea(true);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{PREVIOUS, NEXT, BTN_OK});
        Search search = (Search)this.getControl(SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelId = (String)parameter.getCustomParam("modelId");
        this.compareModelAndDb(modelId);
        this.setButtonVisible(DIFF);
    }

    private void setButtonVisible(String tabKey) {
        if (DIFF.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PREVIOUS, BTN_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{NEXT});
        } else if (SQL.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{NEXT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PREVIOUS, BTN_OK});
        }
    }

    private void compareModelAndDb(String modelId) {
        try {
            IPDMDesignMetaReader dataModelReader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
            PDMEntityMetadata dataModel = (PDMEntityMetadata)dataModelReader.loadBaseMeta(modelId, DMMetaCategory.MDataModel);
            this.getPageCache().put(MODEL_NUMBER, dataModel.getNumber());
            this.getPageCache().put(BIZAPP_ID, dataModel.getBizappId());
            PDMEntityMetadata dataBaseModel = this.getCurrentMeta(dataModel);
            DBRoute dbRoute = this.getDBRoute(dataModel.getBizappId());
            String tables = this.getBaseTables(dataModel);
            DBToDataModelConverter converter = new DBToDataModelConverter(dataBaseModel, dbRoute, tables);
            converter.covert();
            MetadataSerializer serializer = new MetadataSerializer("PhysicalDataModel");
            this.getPageCache().put(DATA_MODEL_ENTITY, SerializationUtils.toJsonString((Object)serializer.serializeToMap((Object)dataModel)));
            this.getPageCache().put(DATA_BASE_ENTITY, SerializationUtils.toJsonString((Object)serializer.serializeToMap((Object)dataBaseModel)));
            DataModelCompareImpl compare = new DataModelCompareImpl();
            PDModel dataPDModel = (PDModel)dataModel.buildDataModel();
            dataPDModel.getTables();
            PDModel dataBasePDModel = (PDModel)dataBaseModel.buildDataModel();
            dataBasePDModel.getTables();
            TreeNode treeNode = compare.compare(dataPDModel, dataBasePDModel);
            treeNode.setIsOpened(true);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
            treeView.addNode(treeNode);
            treeView.focusNode(treeNode);
            this.getPageCache().put(TREE_N0DE_CACHE, SerializationUtils.toJsonString((Object)treeNode));
            this.setEntryProperty(treeNode);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getPageCache().put(IS_ERROR_STATUS, TRUE);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u6570\u636e\u5e93\u6bd4\u8f83\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u3002", (String)"DataModelMergePlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private PDMEntityMetadata getCurrentMeta(PDMEntityMetadata metadata) {
        DataModelDesignerData designerData = new DataModelDesignerData();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("number", metadata.getNumber());
        param.put("key", metadata.getNumber());
        param.put("modelId", metadata.getId());
        param.put("name", metadata.getName());
        param.put("product", metadata.getProduct());
        param.put("bizAppId", metadata.getBizappId());
        PDMEntityMetadata currentMeta = designerData.createBlankMetadata(param);
        currentMeta.getPackageAps().clear();
        return currentMeta;
    }

    private DBRoute getDBRoute(String bizAppId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
        String dbRoute = appInfo.getDbRoute();
        return new DBRoute(dbRoute);
    }

    private String getBaseTables(PDMEntityMetadata baseMeta) {
        List packageAps = baseMeta.getPackageAps();
        ArrayList tables = new ArrayList(10);
        for (DMPackageAp packageAp : packageAps) {
            List tableAps = packageAp.getTableAps();
            tableAps.forEach(tableAp -> tables.add(tableAp.getTableName()));
        }
        if (tables.isEmpty()) {
            return null;
        }
        return SerializationUtils.toJsonString(tables);
    }

    public void click(EventObject evt) {
        String key;
        if (TRUE.equals(this.getPageCache().get(IS_ERROR_STATUS))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u6570\u636e\u5e93\u6bd4\u8f83\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u3002", (String)"DataModelMergePlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "previous": {
                this.previous();
                break;
            }
            case "next": {
                this.next();
                break;
            }
            case "btnok": {
                this.btnOk();
            }
        }
    }

    private void previous() {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.activeTab(DIFF);
        this.setButtonVisible(DIFF);
    }

    private void next() {
        this.buildSql();
    }

    private void btnOk() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        String modelNumber = this.getPageCache().get(MODEL_NUMBER);
        String bizAppId = this.getPageCache().get(BIZAPP_ID);
        Map<String, String> sqlMap = this.getSqlParameter();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("exportSql", TRUE);
        res.put("sqlMap", sqlMap);
        res.put("modelId", modelId);
        res.put("number", modelNumber);
        res.put("bizAppId", bizAppId);
        this.getView().returnDataToParent(res);
        this.getView().close();
    }

    private void buildSql() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        List selectedNodeId = treeView.getTreeState().getCheckedNodeIds();
        PDModel basePDModel = this.getPDModel(DATA_BASE_ENTITY);
        basePDModel.getTables();
        PDModel currPDModel = this.getPDModel(DATA_MODEL_ENTITY);
        currPDModel.getTables();
        PDModel newModel = this.getPDModel(DATA_BASE_ENTITY);
        newModel.getTables();
        PDModelUtil.setNumber2UpCase(basePDModel);
        PDModelUtil.setNumber2UpCase(newModel);
        PDModelUtil.setNumber2UpCase(currPDModel);
        if (selectedNodeId.isEmpty()) {
            newModel = basePDModel;
        } else {
            List checkedNodes = treeView.getTreeState().getCheckedNodes();
            String nodeCache = this.getPageCache().get(TREE_N0DE_CACHE);
            TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)nodeCache, TreeNode.class);
            TreeNode selectNode = this.buildSelectNode(checkedNodes, treeNode);
            DataModelCompareImpl compare = new DataModelCompareImpl();
            compare.merge(selectNode, currPDModel, newModel);
            this.removeNotSelectTable(selectNode, newModel, basePDModel);
        }
        Map<Object, Object> sqlParameter = new HashMap();
        try {
            PDMModelCompare pdmModelCompare = new PDMModelCompare();
            sqlParameter = pdmModelCompare.comparePDModel(newModel, basePDModel);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            log.error("compare model error", (Throwable)e);
        }
        if (sqlParameter.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u7684\u5dee\u91cf\u811a\u672c\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8282\u70b9\u540e\u91cd\u8bd5\u3002", (String)"DataModelMergePlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Tab tab = (Tab)this.getControl(TABAP);
        tab.activeTab(SQL);
        this.setButtonVisible(SQL);
        this.getPageCache().put("sqlParameter", SerializationUtils.toJsonString(sqlParameter));
        this.showSqlView(sqlParameter, currPDModel.getNumber());
    }

    private void removeNotSelectTable(TreeNode treeNode, PDModel newModel, PDModel basePDModel) {
        HashSet<String> tables = new HashSet<String>(10);
        this.getSelectTable(treeNode, tables);
        newModel.getTables().removeIf(table -> !tables.contains(table.getNumber()));
        basePDModel.getTables().removeIf(table -> !tables.contains(table.getNumber()));
    }

    private void getSelectTable(TreeNode treeNode, Set<String> tables) {
        if (TABLE.equals(treeNode.getType())) {
            tables.add(treeNode.getId());
        }
        if (treeNode.getChildren() != null && !treeNode.getChildren().isEmpty()) {
            for (TreeNode node : treeNode.getChildren()) {
                this.getSelectTable(node, tables);
            }
        }
    }

    private Map<String, String> getSqlParameter() {
        String parameter = this.getPageCache().get("sqlParameter");
        Map sqlParameter = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
        HashMap<String, String> sqlMap = new HashMap<String, String>(16);
        for (Map.Entry entry : sqlParameter.entrySet()) {
            Map value = (Map)entry.getValue();
            for (Map.Entry sql : value.entrySet()) {
                String sqlNumber = (String)sql.getKey();
                String sqlContent = (String)sql.getValue();
                sqlMap.put(sqlNumber, sqlContent);
            }
        }
        return sqlMap;
    }

    private void showSqlView(Map<String, Map<String, String>> sqlParameter, String number) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(BOS_DM_SQL);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(SQL_FLEX);
        formShowParameter.setCustomParam(MODEL_NUMBER, (Object)number);
        formShowParameter.setCustomParam("sqlParameter", sqlParameter);
        this.getView().showForm(formShowParameter);
    }

    private TreeNode buildSelectNode(List<Map<String, Object>> checkedNodes, TreeNode leftRoot) {
        TreeNode rootNode = new TreeNode(leftRoot.getParentid(), leftRoot.getId(), leftRoot.getText());
        for (Map<String, Object> node : checkedNodes) {
            String parentId = (String)node.get("parentid");
            String id = (String)node.get("id");
            String text = (String)node.get("text");
            TreeNode treeNode = rootNode.getTreeNode(id);
            if (null != treeNode) continue;
            TreeNode node2 = leftRoot.getTreeNode(id);
            TreeNode curNode = new TreeNode(parentId, id, text);
            curNode.setType(node2.getType());
            curNode.setColor(node2.getColor());
            curNode.setData(node2.getData());
            this.assembleSelectNode(leftRoot, rootNode, curNode);
        }
        return rootNode;
    }

    private void assembleSelectNode(TreeNode leftRoot, TreeNode rightRoot, TreeNode curNode) {
        String parentId = curNode.getParentid();
        TreeNode parentNode = rightRoot.getTreeNode(parentId);
        if (null == parentNode) {
            parentNode = leftRoot.getTreeNode(parentId);
            String parentid = parentNode.getParentid();
            TreeNode treeNode = new TreeNode(parentid, parentNode.getId(), parentNode.getText());
            treeNode.setColor(parentNode.getColor());
            treeNode.setType(parentNode.getType());
            treeNode.setData(parentNode.getData());
            treeNode.addChild(curNode);
            this.assembleSelectNode(leftRoot, rightRoot, treeNode);
        } else {
            parentNode.addChild(curNode);
        }
    }

    private PDModel getPDModel(String type) {
        String baseEntityCache = this.getPageCache().get(type);
        Map baseEntityMap = (Map)SerializationUtils.fromJsonString((String)baseEntityCache, Map.class);
        MetadataSerializer serializer = new MetadataSerializer("PhysicalDataModel");
        PDMEntityMetadata pdmEntityMetadata = (PDMEntityMetadata)serializer.deserializeFromMap(baseEntityMap, null);
        return (PDModel)pdmEntityMetadata.buildDataModel();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String treeNode = this.getPageCache().get(TREE_N0DE_CACHE);
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)treeNode, TreeNode.class);
        TreeNode nodeTreeNode = node.getTreeNode(nodeId);
        this.setEntryProperty(nodeTreeNode);
    }

    private void setEntryProperty(TreeNode node) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        boolean isLeaf = node.getChildren() != null && !node.getChildren().isEmpty();
        int size = 0;
        Map<TreeNode, List<Map<String, String>>> childProperties = this.getChildProperties(node, isLeaf);
        for (Map.Entry<TreeNode, List<Map<String, String>>> entry : childProperties.entrySet()) {
            if (entry.getValue() == null) {
                ++size;
                continue;
            }
            if (entry.getValue().isEmpty()) continue;
            size += entry.getValue().size();
        }
        if (size < 1) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, size);
        this.fillEntryProperty(childProperties);
    }

    private void fillEntryProperty(Map<TreeNode, List<Map<String, String>>> childProperties) {
        int index = 0;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(childProperties.size());
        for (Map.Entry<TreeNode, List<Map<String, String>>> entry : childProperties.entrySet()) {
            TreeNode node = entry.getKey();
            List<Map<String, String>> value = entry.getValue();
            this.setSimpleProperty(value, cellStyles, node, index);
            if (value == null) {
                ++index;
                continue;
            }
            index += value.size();
        }
        entryGrid.setCellStyle(cellStyles);
    }

    private void setSimpleProperty(List<Map<String, String>> map, List<CellStyle> cellStyles, TreeNode node, int index) {
        String key = node.getText();
        if (map == null || map.isEmpty()) {
            if (NODE_COLOR_ADD.equals(node.getColor()) || NODE_COLOR_REMOVE.equals(node.getColor())) {
                this.getModel().setValue(ELEMENT_KEY, (Object)key, index);
                cellStyles.add(this.getCellStyle(index, node));
            }
            return;
        }
        for (int i = 0; i < map.size(); ++i) {
            Map<String, String> diffNode = map.get(i);
            this.getModel().setValue(ELEMENT_KEY, (Object)node.getText(), i + index);
            this.getModel().setValue(PROPERTY_KEY, (Object)diffNode.get(PROPERTY_KEY), i + index);
            this.getModel().setValue(BASE_VALUE, (Object)diffNode.get(BASE_VALUE), i + index);
            this.getModel().setValue(CURR_VALUE, (Object)diffNode.get(CURR_VALUE), i + index);
            CellStyle cellStyle = this.getCellStyle(i + index, node);
            cellStyles.add(cellStyle);
        }
    }

    private Map<TreeNode, List<Map<String, String>>> getChildProperties(TreeNode node, boolean isLeaf) {
        LinkedHashMap<TreeNode, List<Map<String, String>>> properties = new LinkedHashMap<TreeNode, List<Map<String, String>>>(16);
        this.traversalTreeNode(node, properties, isLeaf, 0);
        return properties;
    }

    private void traversalTreeNode(TreeNode node, Map<TreeNode, List<Map<String, String>>> properties, boolean isLeaf, int level) {
        if (node != null) {
            List map;
            Object data = node.getData();
            List list = map = data == null ? null : (List)data;
            if (isLeaf) {
                if (NODE_COLOR_ADD.equals(node.getColor()) || NODE_COLOR_REMOVE.equals(node.getColor())) {
                    if (level == 0) {
                        properties.put(node, map);
                    } else {
                        properties.put(node, null);
                    }
                } else if (map != null && !map.isEmpty() && NODE_COLOR_EDIT.equals(node.getColor())) {
                    properties.put(node, map);
                }
            } else if (map != null && !map.isEmpty()) {
                properties.put(node, map);
            }
            ++level;
            if (node.getChildren() == null) {
                return;
            }
            for (TreeNode treeNode : node.getChildren()) {
                this.traversalTreeNode(treeNode, properties, isLeaf, level);
                ++level;
            }
        }
    }

    private CellStyle getCellStyle(int row, TreeNode node) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setForeColor(node.getColor());
        cellStyle.setFieldKey(ELEMENT_KEY);
        cellStyle.setRow(row);
        return cellStyle;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        String text = this.getPageCache().get(SEARCH_TEXT);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        if (searchText.equals(text)) {
            String list = this.getPageCache().get(NODE_LIST);
            List nodeList = SerializationUtils.fromJsonStringToList((String)list, TreeNode.class);
            if (nodeList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"DataModelMergePlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            int index = Integer.parseInt(this.getPageCache().get(SEARCH_INDEX));
            if (index >= nodeList.size()) {
                index = 0;
            }
            TreeNode treeNode = (TreeNode)nodeList.get(index);
            treeView.focusNode(treeNode);
            this.getPageCache().put(SEARCH_INDEX, String.valueOf(index + 1));
            return;
        }
        String node = this.getPageCache().get(TREE_N0DE_CACHE);
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)node, TreeNode.class);
        ArrayList selectNodes = new ArrayList(10);
        List nodeList = treeNode.getTreeNodeListByText(selectNodes, searchText, 100);
        this.getPageCache().put(SEARCH_TEXT, searchText);
        this.getPageCache().put(NODE_LIST, SerializationUtils.toJsonString((Object)nodeList));
        if (nodeList.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"DataModelMergePlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeNode selectTree = (TreeNode)nodeList.get(0);
        this.getPageCache().put(SEARCH_INDEX, String.valueOf(1));
        treeView.focusNode(selectTree);
    }
}

