/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DataModelSqlPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String NAME = "name";
    private static final String PACKAGE_NUMBER = "packagenumber";
    private static final String DATAMODEL = "datamodel";
    private static final String CONTENT = "content";
    private static final String BOS_DM_SQLCONTENT = "bos_dm_sqlcontent";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map sqlParameter = (Map)parameter.getCustomParam("sqlParameter");
        String modelNumber = (String)parameter.getCustomParam("modelNumber");
        List<SqlType> sqlTypes = this.getSqlType(sqlParameter);
        this.initEntryEntity(sqlTypes, modelNumber);
    }

    private void initEntryEntity(List<SqlType> sqlTypes, String modelNumber) {
        if (sqlTypes.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, sqlTypes.size());
        for (int i = 0; i < sqlTypes.size(); ++i) {
            SqlType sqlType = sqlTypes.get(i);
            this.getModel().setValue(NAME, (Object)sqlType.getNumber(), i);
            this.getModel().setValue(PACKAGE_NUMBER, (Object)sqlType.getPackageNumber(), i);
            this.getModel().setValue(DATAMODEL, (Object)modelNumber, i);
            this.getModel().setValue(CONTENT, (Object)sqlType.getContent(), i);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.buildSql();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u4e00\u884c");
                return;
            }
            String value = (String)this.getModel().getValue(CONTENT, selectRows[0]);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(BOS_DM_SQLCONTENT);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("sqlContent", (Object)value);
            this.getView().showForm(parameter);
        }
    }

    private void buildSql() {
        String sql = this.getPageCache().get("sqlMap");
        Map sqlMap = (Map)SerializationUtils.fromJsonString((String)sql, Map.class);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("exportSql", "true");
        result.put("sqlMap", sqlMap);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private List<SqlType> getSqlType(Map<String, Map<String, Object>> sqlParameter) {
        ArrayList<SqlType> sqlTypes = new ArrayList<SqlType>(10);
        HashMap<String, String> sqlMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Map<String, Object>> entry : sqlParameter.entrySet()) {
            String packageNumber = entry.getKey();
            Map<String, Object> value = entry.getValue();
            for (Map.Entry<String, Object> sql : value.entrySet()) {
                String sqlNumber = sql.getKey();
                String sqlContent = (String)sql.getValue();
                SqlType sqlType = new SqlType(sqlNumber, sqlContent, packageNumber);
                sqlTypes.add(sqlType);
                sqlMap.put(sqlNumber, sqlContent);
            }
        }
        this.getPageCache().put("sqlMap", SerializationUtils.toJsonString(sqlMap));
        return sqlTypes;
    }

    public static class SqlType {
        private String number;
        private String content;
        private String packageNumber;

        public SqlType(String number, String content, String packageNumber) {
            this.number = number;
            this.content = content;
            this.packageNumber = packageNumber;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getPackageNumber() {
            return this.packageNumber;
        }

        public void setPackageNumber(String packageNumber) {
            this.packageNumber = packageNumber;
        }
    }
}

