/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.util.VersionManageUtil;
import kd.bos.session.SessionKeys;

public class DataModelSubmitPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String IFRAME = "iframe";
    private static final String TAB_AP = "tabap";
    private static final String XML = "xml";
    private static final String SQL = "sql";
    private static final String BOS_DM_SQL = "bos_dm_sql";
    private static final String SQL_FLEX = "sqlflex";
    private static final String BTN_OK = "btnok";
    private static final String FLEX_PAMEL = "flexpanelap";
    private static final String MODEL_LIST = "modelList";
    private static final String DESIGNER = "designer";
    private static final String SUBMIT = "submit";
    private static final String LAST = "last";
    private static final String NEXT = "next";
    private static final String TRUE = "true";
    private static final String OPERATOR = "operator";
    private static final String DESCRIPTION = "description";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final Map<String, String> nextTabMap = new HashMap<String, String>(3);
    private static final Map<String, String> lastTabMap = new HashMap<String, String>(3);

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{BTN_OK, NEXT, LAST});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map sqlParameter = (Map)parameter.getCustomParam("sqlParameter");
        String openType = (String)parameter.getCustomParam("openType");
        Tab tab = (Tab)this.getControl(TAB_AP);
        if (MODEL_LIST.equals(openType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PAMEL, LAST, NEXT});
        } else {
            if (sqlParameter.isEmpty()) {
                tab.deleteControls(new String[]{SQL});
            }
            String reason = ResManager.loadKDString((String)"\u4fee\u6539\u539f\u56e0", (String)"DataModelSubmitPlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            String content = ResManager.loadKDString((String)"\u4fee\u6539\u5185\u5bb9", (String)"DataModelSubmitPlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.getModel().setValue(DESCRIPTION, (Object)("\u3010" + reason + "\u3011\r\n\u3010" + content + "\u3011"));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LAST, BTN_OK});
        }
        this.getPageCache().put("exportSql", String.valueOf(!sqlParameter.isEmpty()));
        String tabKey = DESIGNER.equals(openType) ? SUBMIT : (MODEL_LIST.equals(openType) ? SQL : XML);
        tab.activeTab(tabKey);
        this.buildSqlParameter();
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (XML.equals(tabKey)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String currentXml = (String)parameter.getCustomParam("currentXml");
            String lastXml = (String)parameter.getCustomParam("lastXml");
            this.handleXmlToIframe(currentXml, lastXml);
            this.handlerVisible();
        } else if (SQL.equals(tabKey)) {
            this.showSqlView();
            if (this.isDesignerOpen()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{NEXT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LAST, BTN_OK});
            }
        } else if (SUBMIT.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LAST, BTN_OK});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{NEXT});
        }
    }

    private void handlerVisible() {
        String exportSql = this.getPageCache().get("exportSql");
        if (this.isDesignerOpen()) {
            if (TRUE.equals(exportSql)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LAST, NEXT});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{NEXT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_OK, LAST});
            }
        } else if (TRUE.equals(exportSql)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK, LAST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{NEXT});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LAST, NEXT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_OK});
        }
    }

    private boolean isDesignerOpen() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String openType = (String)parameter.getCustomParam("openType");
        return DESIGNER.equals(openType);
    }

    public void click(EventObject evt) {
        Tab tab;
        String tabKey;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.buildSql();
        } else if (NEXT.equals(key)) {
            this.next();
        } else if (LAST.equals(key) && (tabKey = lastTabMap.get((tab = (Tab)this.getControl(TAB_AP)).getCurrentTab())) != null) {
            tab.activeTab(tabKey);
        }
    }

    private void next() {
        String tabKey;
        Tab tab = (Tab)this.getControl(TAB_AP);
        String currentTabKey = tab.getCurrentTab();
        if (SUBMIT.equals(currentTabKey)) {
            String operator = (String)this.getModel().getValue(OPERATOR);
            String description = (String)this.getModel().getValue(DESCRIPTION);
            if (StringUtils.isBlank((CharSequence)operator)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataModelSubmitPlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)description)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if ((tabKey = nextTabMap.get(currentTabKey)) != null) {
            tab.activeTab(tabKey);
        }
    }

    private void showSqlView() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String number = (String)parameter.getCustomParam("number");
        Map sqlParameter = (Map)parameter.getCustomParam("sqlParameter");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(BOS_DM_SQL);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(SQL_FLEX);
        formShowParameter.setCustomParam("modelNumber", (Object)number);
        formShowParameter.setCustomParam("sqlParameter", (Object)sqlParameter);
        this.getView().showForm(formShowParameter);
    }

    private void buildSqlParameter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map sqlParameter = (Map)parameter.getCustomParam("sqlParameter");
        HashMap<String, String> sqlMap = new HashMap<String, String>(16);
        for (Map.Entry entry : sqlParameter.entrySet()) {
            Map value = (Map)entry.getValue();
            for (Map.Entry sql : value.entrySet()) {
                String sqlNumber = (String)sql.getKey();
                String sqlContent = (String)sql.getValue();
                sqlMap.put(sqlNumber, sqlContent);
            }
        }
        this.getPageCache().put("sqlMap", SerializationUtils.toJsonString(sqlMap));
    }

    private void buildSql() {
        String sql = this.getPageCache().get("sqlMap");
        Map sqlMap = (Map)SerializationUtils.fromJsonString((String)sql, Map.class);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String exportSql = this.getPageCache().get("exportSql");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String modelId = (String)parameter.getCustomParam("modelId");
        String number = (String)parameter.getCustomParam("number");
        String bizAppId = (String)parameter.getCustomParam("bizAppId");
        String submit = (String)this.getModel().getValue(OPERATOR);
        String description = (String)this.getModel().getValue(DESCRIPTION);
        result.put("exportSql", exportSql);
        result.put("sqlMap", sqlMap);
        result.put("modelId", modelId);
        result.put("number", number);
        result.put("bizAppId", bizAppId);
        result.put(SUBMIT, submit);
        result.put(DESCRIPTION, description);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private void handleXmlToIframe(String currentXml, String lastXml) {
        IFrame frame = (IFrame)this.getView().getControl(IFRAME);
        String urlParams = this.getUrlParams(currentXml, lastXml);
        urlParams = this.getKdcdUrl(urlParams);
        frame.setSrc("devtools/built-compare/gitResolve.html?" + urlParams);
    }

    private String getKdcdUrl(String path) {
        return SessionKeys.isAccountSession((String)RequestContext.get().getTenantId()) ? path + "&kdcdc#" + RequestContext.get().getAccountId() : path;
    }

    private String getUrlParams(String currentXml, String lastXml) {
        String uuid = "test";
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String filePath = null;
        String number = (String)parameter.getCustomParam("number");
        if (StringUtils.isNotBlank((CharSequence)number)) {
            filePath = "/" + number + ".kpdm";
        }
        String personalgitrepository = "";
        String oldCommitId = (String)parameter.getCustomParam("oldCommitId");
        String newCommitId = (String)parameter.getCustomParam("newCommitId");
        filePath = filePath + "$$" + oldCommitId + "$$" + newCommitId;
        String type = "log";
        String gitrepository = Encrypters.encode((String)VersionManageUtil.compress((String)currentXml));
        String projectURL = Encrypters.encode((String)VersionManageUtil.compress((String)lastXml));
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String pageId = this.getView().getPageId();
        boolean isSave = false;
        return "uuid#" + uuid + "&pageid#" + pageId + "&projecturl#" + projectURL + "&gitrepository#" + gitrepository + "&personalgitrepository#" + personalgitrepository + "&filepath#" + filePath + "&id#" + id + "&bizappid#" + bizAppId + "&type#" + type + "&issave#" + isSave;
    }

    static {
        nextTabMap.put(SUBMIT, XML);
        nextTabMap.put(XML, SQL);
        lastTabMap.put(SQL, XML);
        lastTabMap.put(XML, SUBMIT);
    }
}

