/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DataModelValidatorPlugin
extends AbstractFormPlugin {
    private static final String MODEL = "model";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String RESULT = "result";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String LEVEL = "level";
    private static final String ERROR = "error";
    private static final String INFO = "info";
    private static final String INFO_COLOR = "#FF991C";
    private static final String ERROR_COLOR = "#FB2323";
    private static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        String params = (String)this.getView().getFormShowParameter().getCustomParam("params");
        Map result = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
        if (result.get(SUCCESS) != null && ((Boolean)result.get(SUCCESS)).booleanValue()) {
            Object warnMessage;
            if (result.get("warn") != null && ((Boolean)result.get("warn")).booleanValue() && (warnMessage = result.get("warnMessage")) instanceof List) {
                List warn = (List)warnMessage;
                this.fillEntryEntity(warn, true);
            }
        } else {
            Object errorList = result.get(MESSAGE);
            if (errorList instanceof List) {
                List error = (List)errorList;
                this.fillEntryEntity(error, false);
            }
        }
    }

    private void fillEntryEntity(List<Map<String, Object>> validatorInfos, boolean isSuccess) {
        if (validatorInfos.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, validatorInfos.size());
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(validatorInfos.size());
        for (int i = 0; i < validatorInfos.size(); ++i) {
            Map<String, Object> validatorInfo = validatorInfos.get(i);
            this.getModel().setValue(MODEL, validatorInfo.get("dataModelNumber"), i);
            this.getModel().setValue(TYPE, validatorInfo.get("validatorType"), i);
            this.getModel().setValue(KEY, validatorInfo.get("validatorNumber"), i);
            this.getModel().setValue(NAME, validatorInfo.get("validatorName"), i);
            this.getModel().setValue(RESULT, validatorInfo.get(RESULT), i);
            String level = isSuccess ? INFO : ERROR;
            String color = isSuccess ? INFO_COLOR : ERROR_COLOR;
            this.getModel().setValue(LEVEL, (Object)level, i);
            CellStyle style = new CellStyle();
            style.setFieldKey(LEVEL);
            style.setRow(i);
            style.setForeColor(color);
            cellStyles.add(style);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.setCellStyle(cellStyles);
        this.getView().updateView(ENTRY_ENTITY);
    }
}

