/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

class PDMCompare {
    private static Log logger = LogFactory.getLog(PDMCompare.class);
    public boolean generateAlertLog;
    private StringBuilder sbDropLog = new StringBuilder();
    private static Map<String, ModifyObjectNameEntity> dictMap = null;
    private Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(8);
    private boolean isOutDropSql;

    PDMCompare() {
    }

    public Map<String, Map<String, String>> getResult() {
        return this.result;
    }

    private void reset() {
        this.result.clear();
        this.sbDropLog = new StringBuilder();
    }

    public void setOutDropSql(boolean isOutDropSql) {
        this.isOutDropSql = isOutDropSql;
    }

    public boolean isGenerateAlertLog() {
        return this.generateAlertLog;
    }

    public String getSbDropLog() {
        return this.sbDropLog.toString();
    }

    public void setGenerateAlertLog(boolean generateAlertLog) {
        this.generateAlertLog = generateAlertLog;
    }

    public boolean compare(PDMEntityMetadata currObj, PDMEntityMetadata oldObj) throws Exception {
        this.reset();
        Map<String, ModifyObjectNameEntity> dict = PDMCompare.getModifyObjectName();
        return this.compare(currObj, oldObj, dict);
    }

    private static Map<String, ModifyObjectNameEntity> getModifyObjectName() throws Exception {
        if (dictMap == null) {
            dictMap = PDMCompare.getModifyObjectNameFromXml();
        }
        return dictMap;
    }

    private static Map<String, ModifyObjectNameEntity> getModifyObjectNameFromXml() throws DocumentException {
        HashMap<String, ModifyObjectNameEntity> dict = new HashMap<String, ModifyObjectNameEntity>();
        SAXReader saxReader = new SAXReader();
        URL url = PDMCompare.class.getResource("/ModifyObjectNameList.xml");
        String path = url == null ? "" : url.getPath();
        logger.info("ModifyObjectNameList path: " + path);
        Document document = saxReader.read(url);
        Element rootElement = document.getRootElement();
        List tableNames = rootElement.elements(new QName("TableName"));
        if (tableNames != null) {
            for (Element tableEl : tableNames) {
                String tableName = tableEl.attribute("key").getText();
                String oldTableName = tableEl.attribute("value").getText();
                ModifyObjectNameEntity entity = new ModifyObjectNameEntity(tableName);
                entity.setOldTableName(oldTableName);
                List columnNames = tableEl.elements(new QName("ColumnName"));
                if (columnNames != null) {
                    for (Element elCol : columnNames) {
                        String colName = elCol.attribute("key").getText();
                        String oldColName = elCol.attribute("value").getText();
                        entity.add(colName, oldColName);
                    }
                }
                dict.put(tableName, entity);
            }
        }
        return dict;
    }

    private boolean compare(PDMEntityMetadata currObj, PDMEntityMetadata oldObj, Map<String, ModifyObjectNameEntity> dict) throws Exception {
        boolean isDifferent = false;
        StringBuilder log = new StringBuilder();
        log.append(String.format("\u6a21\u578b%s\u548c\u6a21\u578b%s\u6bd4\u8f83\uff0c\u7b26\u5408\u6821\u9a8c\u7684\u6a21\u578b\uff1a", currObj.getBizappId(), oldObj.getBizappId()));
        this.appendLn(log);
        Map<String, DMPackageAp> oldPkgMap = this.toPkgDictMap(oldObj.getPackageAps());
        for (DMPackageAp currPkg : currObj.getPackageAps()) {
            try {
                log.append(String.format("%s \u5f00\u59cb\u751f\u6210\u6bd4\u8f83\u5dee\u91cf...", currPkg.getKey()));
                this.appendLn(log);
                DMPackageAp modifyObj = oldPkgMap.get(currPkg.getKey());
                if (modifyObj != null) {
                    if (!this.compareObj(currPkg, modifyObj, dict)) continue;
                    isDifferent = true;
                    continue;
                }
                DMPackageAp oldPkg = new DMPackageAp();
                oldPkg.setKey(currPkg.getKey());
                this.compareObj(currPkg, oldPkg, new HashMap<String, ModifyObjectNameEntity>(6));
                isDifferent = true;
            }
            catch (Exception e) {
                log.append(String.format("model name : %s, error:%s", currPkg.getKey(), e.getMessage()));
                logger.error("model name : {}", (Object)currPkg.getKey(), (Object)e);
                throw e;
            }
        }
        logger.info("scriptcompare.log", (Object)log);
        return isDifferent;
    }

    private boolean compareObj(DMPackageAp currObj, DMPackageAp oldObj, Map<String, ModifyObjectNameEntity> dict) throws Exception {
        boolean isDifferent = false;
        StringBuilder strAlterTableScript = new StringBuilder();
        StringBuilder strAlterConstraintScript = new StringBuilder();
        Map<String, TableAp> dictDropTabs = this.toTabDictMap(oldObj.getTableAps());
        for (TableAp tab : currObj.getTableAps()) {
            String indexSQL;
            TableAp oldTable;
            String tableName = tab.getTableName().toUpperCase(Locale.ENGLISH);
            ModifyObjectNameEntity modifyObj = dict.get(tableName);
            HashMap<String, String> dictModifyColumns = new HashMap(8);
            if (modifyObj != null) {
                if (StringUtils.isNotEmpty((CharSequence)modifyObj.getOldTableName()) && modifyObj.IsModifyTableName()) {
                    tableName = modifyObj.oldTableName;
                }
                dictModifyColumns = modifyObj.getColumns();
            }
            if ((oldTable = dictDropTabs.get(tableName)) != null) {
                dictDropTabs.remove(tableName);
                if (this.compare(tab, oldTable, strAlterTableScript, strAlterConstraintScript, dictModifyColumns)) continue;
                isDifferent = true;
                continue;
            }
            strAlterTableScript.append(tab.generateCreateSQL());
            this.appendLn(strAlterTableScript);
            String constraintSQL = tab.generateConstraintSQL();
            if (StringUtils.isNotEmpty((CharSequence)constraintSQL)) {
                strAlterConstraintScript.append(constraintSQL);
                this.appendLn(strAlterConstraintScript);
            }
            if (StringUtils.isNotEmpty((CharSequence)(indexSQL = tab.generateIndexSQL()))) {
                strAlterConstraintScript.append(indexSQL);
                this.appendLn(strAlterConstraintScript);
            }
            isDifferent = true;
        }
        for (TableAp tab : dictDropTabs.values()) {
            if (this.isOutDropSql) {
                strAlterTableScript.append("DROP TABLE ").append(tab.getTableName()).append(";");
            } else {
                strAlterTableScript.append(" --- drop TABLE --------- \u4e0d\u5141\u8bb8\u5220\u9664\u8868").append(tab.getTableName()).append("\uff0c\u8bf7\u6062\u590dpdm ------------------- ");
            }
            this.appendLn(strAlterTableScript);
            isDifferent = true;
        }
        String mod = currObj.getKey();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String date = dateFormat.format(new Date());
        String key = "kd_1.5.0_" + date;
        HashMap<String, String> map = new HashMap<String, String>(8);
        if (StringUtils.isNotBlank((CharSequence)strAlterTableScript.toString())) {
            map.put(key + "_table.sql", strAlterTableScript.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)strAlterConstraintScript.toString())) {
            map.put(key + "_constraint.sql", strAlterConstraintScript.toString());
        }
        if (this.generateAlertLog && this.sbDropLog.length() > 0) {
            map.put("kd" + mod + "scriptalert.log", this.sbDropLog.toString());
        }
        if (!map.isEmpty()) {
            this.result.put(mod, map);
        }
        return isDifferent;
    }

    private boolean compare(TableAp currTab, TableAp oldTab, StringBuilder strAlterTableScript, StringBuilder strAlterConstraintScript, Map<String, String> dictModifyColumns) throws Exception {
        boolean isAdd = false;
        boolean isAlter = false;
        if (!currTab.getTableName().equalsIgnoreCase(oldTab.getTableName())) {
            strAlterTableScript.append(String.format("exec p_ModifyObjectName '%s', '%s', '%s', 'OBJECT', '';/r/n ", oldTab.getTableName(), oldTab.getTableName(), currTab.getTableName()));
            this.appendLn(strAlterTableScript);
        }
        Map<String, ColumnAp> dictDrop = this.toColumnDictMap(oldTab.getColumns());
        HashMap<String, ColumnAp> dictAdd = new HashMap<String, ColumnAp>();
        for (ColumnAp col : currTab.getColumns()) {
            String oldColDef;
            Object colName = dictModifyColumns.get(col.getColumnName());
            if (colName != null) {
                strAlterTableScript.append(String.format("exec p_ModifyObjectName '%s', '%s', '%s', 'COLUMN', '%s';\r\n ", currTab.getTableName(), colName, col.getColumnName(), ColumnAp.columnPropertyScript((String)DataType.valueOf((int)col.getColunmType()).name(), (long)col.getColumnLength(), (long)col.getColumnPrecision(), (!col.isNotNull() ? 1 : 0) != 0, (Object)col.getColumnDef())));
                this.appendLn(strAlterTableScript);
            } else {
                colName = col.getColumnName();
            }
            ColumnAp objCol = dictDrop.get(colName);
            if (objCol == null) {
                dictAdd.put((String)colName, col);
                continue;
            }
            dictDrop.remove(colName);
            if (col.equals((Object)objCol)) continue;
            isAlter = true;
            String isModify = "";
            Object isNull = "";
            String colDef = "";
            String string = colDef = col.getColumnDef() == null ? "NULL" : String.valueOf(col.getColumnDef());
            if ("".equals(colDef)) {
                colDef = "NULL";
            }
            colDef = colDef.replace("'", "''");
            Object object = isNull = !col.isNotNull() ? "NULL" : "NOT NULL";
            if (col.getColunmType() != objCol.getColunmType()) {
                isModify = "1111";
            } else {
                isModify = "00";
                if (col.getColumnLength() != objCol.getColumnLength()) {
                    isModify = "01";
                }
                if (col.isNotNull() != objCol.isNotNull()) {
                    if (this.enablePrimaryColumnModify(currTab, col)) {
                        isModify = isModify + "1";
                    } else {
                        strAlterConstraintScript.append(String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getTableName(), col.getColumnName()));
                        this.appendLn(strAlterConstraintScript);
                    }
                } else {
                    isModify = isModify + "0";
                }
                if (col.getColumnDef() == null && objCol.getColumnDef() != null) {
                    if (this.enablePrimaryColumnModify(currTab, col)) {
                        isModify = isModify + "1";
                    } else {
                        strAlterConstraintScript.append(String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getTableName(), col.getColumnName()));
                        this.appendLn(strAlterConstraintScript);
                    }
                } else if (col.getColumnDef() != null && objCol.getColumnDef() == null || col.getColumnDef() != null && objCol.getColumnDef() != null && !col.getColumnDef().equals(objCol.getColumnDef())) {
                    if (this.enablePrimaryColumnModify(currTab, col)) {
                        isModify = isModify + "1";
                    } else {
                        strAlterConstraintScript.append(String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getTableName(), col.getColumnName()));
                        this.appendLn(strAlterConstraintScript);
                    }
                } else {
                    isModify = isModify + "0";
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)isModify) || "0000".equals(isModify)) continue;
            strAlterTableScript.append(String.format(" EXEC p_AlterColumn '%s', '%s', '%s', '%s', '%s', '%s';\r\n", currTab.getTableName(), col.getColumnName(), ColumnAp.columnPropertyScript((String)DataType.valueOf((int)col.getColunmType()).name(), (long)col.getColumnLength(), (long)col.getColumnPrecision(), (boolean)true, null), isNull, isModify, colDef));
            this.appendLn(strAlterTableScript);
            if (!this.generateAlertLog || !isModify.startsWith("1")) continue;
            String string2 = oldColDef = objCol.getColumnDef() == null ? "NULL" : String.valueOf(objCol.getColumnDef());
            if ("".equals(oldColDef)) {
                oldColDef = "NULL";
            }
            oldColDef = oldColDef.replace("'", "''");
            this.sbDropLog.append("alter column        ").append(currTab.getTableName()).append("        ").append(objCol.getColumnName()).append("        ").append(objCol.getColunmType()).append("(").append(objCol.getColumnLength()).append(",").append(objCol.getColumnPrecision()).append(")  ").append(!objCol.isNotNull() ? "NULL" : "NOT NULL").append(" (").append(oldColDef).append(")").append("        ").append(col.getColumnName()).append("        ").append(col.getColunmType()).append("(").append(col.getColumnLength()).append(",").append(col.getColumnPrecision()).append(")  ").append((String)isNull).append(" (").append(colDef).append(")");
            this.appendLn(this.sbDropLog);
        }
        if (currTab.getPrimaryKey() == null) {
            throw new Exception(String.format("\u8868%s\u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\u3002", currTab.getTableName()));
        }
        if (StringUtils.isEmpty((CharSequence)currTab.getPrimaryKey().getPk()) || currTab.getPrimaryKey().getPkColumnList().isEmpty()) {
            if (StringUtils.isEmpty((CharSequence)oldTab.getPrimaryKey().getPk()) || oldTab.getPrimaryKey().getPkColumnList().isEmpty()) {
                this.sbDropLog.append(String.format("--\u8868%s\u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\uff0c\u5e94\u5728\u4e0a\u4e2a\u7248\u672c\u6a21\u578b\u751f\u6210\u811a\u672c\u65f6\u68c0\u6d4b\u5e76\u4fee\u6539\uff0c\u6b64\u5904\u4e0d\u5e94\u8be5\u51fa\u73b0\uff08\u4e0a\u4e2a\u7248\u672c\u672a\u68c0\u6d4b\u6216\u672a\u4fee\u6539\uff09\u3002", currTab.getTableName()));
                this.appendLn(this.sbDropLog);
            } else {
                throw new Exception(String.format("\u8868%s\u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\uff0c\u5e94\u5728\u6a21\u578b\u751f\u6210\u811a\u672c\u65f6\u68c0\u6d4b\uff0c\u6b64\u5904\u4e0d\u5e94\u8be5\u51fa\u73b0\u3002", currTab.getTableName()));
            }
        }
        List currPkColumnList = currTab.getPrimaryKey().getPkColumnList();
        List<String> currpkColumnNamesList = new ArrayList<String>(currPkColumnList.size());
        for (RefColumnAp refColumnAp : currPkColumnList) {
            currpkColumnNamesList.add(refColumnAp.getRefId());
        }
        currpkColumnNamesList = this.getRefColumn(currTab, currpkColumnNamesList);
        String colnames = StringUtils.join((Object[])currpkColumnNamesList.toArray(), (String)",");
        if (!currTab.getPrimaryKey().equals((Object)oldTab.getPrimaryKey())) {
            strAlterConstraintScript.append(String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getTableName(), colnames));
            this.appendLn(strAlterConstraintScript);
        }
        if (this.generateAlertLog) {
            List oldPkColumnList = currTab.getPrimaryKey().getPkColumnList();
            ArrayList<String> oldpkColumnNamesList = new ArrayList<String>(oldPkColumnList.size());
            for (RefColumnAp refColumnAp : oldPkColumnList) {
                oldpkColumnNamesList.add(refColumnAp.getRefId());
            }
            String sCurrColNames = StringUtils.join(currpkColumnNamesList, (String)",");
            String sOldColNames = StringUtils.join(oldpkColumnNamesList, (String)",");
            this.sbDropLog.append("alter pk").append("        ").append(currTab.getName()).append("        ").append(oldTab.getPrimaryKey().getPk()).append("        ").append(sOldColNames).append("        ").append(currTab.getPrimaryKey().getPk()).append("        ").append(sCurrColNames).append("        ").append(currTab.getPrimaryKey().getPk().equals(oldTab.getPrimaryKey().getPk())).append("        ").append(sCurrColNames.equals(sOldColNames));
            this.appendLn(this.sbDropLog);
        }
        Map<String, IndexAp> dictDropIndexes = this.toIndexDictMap(oldTab.getIndexs());
        ArrayList<IndexAp> listAddIndexes = new ArrayList<IndexAp>(8);
        for (IndexAp idx : currTab.getIndexs()) {
            if (dictDropIndexes.containsKey(idx.getIndexName())) {
                IndexAp oldInd = dictDropIndexes.get(idx.getIndexName());
                if (!idx.equals((Object)oldInd)) {
                    isAlter = true;
                    strAlterConstraintScript.append(oldTab.generateDropIndex(idx.getIndexName()));
                    this.appendLn(strAlterConstraintScript);
                    listAddIndexes.add(idx);
                }
                dictDropIndexes.remove(idx.getIndexName());
                continue;
            }
            isAdd = true;
            listAddIndexes.add(idx);
        }
        for (IndexAp idx : dictDropIndexes.values()) {
            strAlterConstraintScript.append(oldTab.generateDropIndex(idx.getIndexName()));
            this.appendLn(strAlterConstraintScript);
        }
        for (IndexAp idx : listAddIndexes) {
            strAlterConstraintScript.append(idx.getIndexSQL(currTab));
            this.appendLn(strAlterConstraintScript);
        }
        if (!dictAdd.isEmpty()) {
            isAdd = true;
            for (ColumnAp item : dictAdd.values()) {
                strAlterTableScript.append(currTab.getAddColumnsSQL(item));
                this.appendLn(strAlterTableScript);
            }
        }
        for (ColumnAp item : dictDrop.values()) {
            strAlterTableScript.append(" --- drop column --------- \u4e0d\u5141\u8bb8\u5220\u9664\u8868").append(currTab.getTableName()).append("\u7684\u5b57\u6bb5").append(item.getColumnName()).append("\uff0c\u8bf7\u6062\u590dpdm\u4e2d\u7684\u5b57\u6bb5 ------------------- ");
            this.appendLn(strAlterTableScript);
        }
        return !isAdd && !isAlter;
    }

    private List<String> getRefColumn(TableAp tableAp, List<String> refId) {
        ArrayList<String> columns = new ArrayList<String>(refId.size());
        HashMap columnMap = new HashMap(refId.size());
        tableAp.getColumns().forEach(columnAp -> columnMap.put(columnAp.getId(), columnAp.getColumnName()));
        for (String columnId : refId) {
            String id = (String)columnMap.get(columnId);
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            columns.add(id);
        }
        return columns;
    }

    private Map<String, ColumnAp> toColumnDictMap(List<ColumnAp> list) {
        HashMap<String, ColumnAp> dict = new HashMap<String, ColumnAp>(list.size());
        for (ColumnAp columnAp : list) {
            dict.put(columnAp.getColumnName(), columnAp);
        }
        return dict;
    }

    private Map<String, IndexAp> toIndexDictMap(List<IndexAp> list) {
        HashMap<String, IndexAp> dict = new HashMap<String, IndexAp>(list.size());
        for (IndexAp indexAp : list) {
            dict.put(indexAp.getIndexName(), indexAp);
        }
        return dict;
    }

    private Map<String, TableAp> toTabDictMap(List<TableAp> list) {
        HashMap<String, TableAp> dict = new HashMap<String, TableAp>(list.size());
        for (TableAp tableApAp : list) {
            dict.put(tableApAp.getTableName().toUpperCase(Locale.ENGLISH), tableApAp);
        }
        return dict;
    }

    private Map<String, DMPackageAp> toPkgDictMap(List<DMPackageAp> list) {
        HashMap<String, DMPackageAp> dict = new HashMap<String, DMPackageAp>(list.size());
        for (DMPackageAp packageAp : list) {
            dict.put(packageAp.getKey(), packageAp);
        }
        return dict;
    }

    private boolean enablePrimaryColumnModify(TableAp currTab, ColumnAp col) {
        return !currTab.getPrimaryKey().getPkColumnList().contains(col.getColumnName());
    }

    private void appendLn(StringBuilder stringBuilder) {
        stringBuilder.append("\n");
    }

    static class ModifyObjectNameEntity {
        private String tableName;
        private String oldTableName;
        private Map<String, String> columns;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getOldTableName() {
            return this.oldTableName;
        }

        public void setOldTableName(String oldTableName) {
            this.oldTableName = oldTableName;
        }

        public Map<String, String> getColumns() {
            return this.columns;
        }

        public void setColumns(Map<String, String> columns) {
            this.columns = columns;
        }

        ModifyObjectNameEntity(String tableName) {
            this.tableName = tableName;
            this.columns = new HashMap<String, String>(6);
        }

        public boolean IsModifyTableName() {
            return !StringUtils.equalsIgnoreCase((CharSequence)this.tableName, (CharSequence)this.oldTableName);
        }

        public void add(String columnName, String oldColumnName) {
            this.columns.put(columnName, oldColumnName);
        }
    }
}

