/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.DMMetaCategory;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.pdm.model.PDModel;
import kd.bos.datamodel.pdm.utils.PDMCompare;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class PDMModelCompare {
    private static final Log logger = LogFactory.getLog(PDMModelCompare.class);
    static final String COMPARE_ITERATION = "iteration";
    static final String COMPARE_SINGLE = "single";
    String compareStrategy = "iteration";

    public void setCompareStrategy(String compareStrategy) {
        this.compareStrategy = compareStrategy;
    }

    public Map<String, Map<String, String>> comparePDModel(PDMEntityMetadata pdmMetadata) throws Exception {
        String id = pdmMetadata.getId();
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        PDMEntityMetadata baseMeta = (PDMEntityMetadata)reader.loadBaseMeta(id, DMMetaCategory.MDataModel);
        PDModel dataModel = (PDModel)pdmMetadata.buildDataModel();
        PDModel baseDataModel = (PDModel)baseMeta.buildDataModel();
        PDMCompare pdmCompare1 = new PDMCompare();
        pdmCompare1.compare(dataModel, baseDataModel);
        Map sqlMap = pdmCompare1.getSqlScript();
        String modelNumber = dataModel.getNumber();
        return this.outSqlMap(sqlMap, modelNumber);
    }

    public Map<String, Map<String, String>> comparePDModel(PDMEntityMetadata lastEntityMeta, PDMEntityMetadata currentEntityMeta) {
        PDModel dataModel = (PDModel)currentEntityMeta.buildDataModel();
        PDModel baseDataModel = (PDModel)lastEntityMeta.buildDataModel();
        Map<String, String> sqlMap = new HashMap<String, String>();
        try {
            PDMCompare pdmCompare = new PDMCompare();
            pdmCompare.compare(dataModel, baseDataModel);
            sqlMap = pdmCompare.getSqlScript();
        }
        catch (Exception e) {
            logger.error("build sql error ", (Throwable)e);
        }
        String modelNumber = dataModel.getNumber();
        return this.outSqlMap(sqlMap, modelNumber);
    }

    public Map<String, Map<String, String>> comparePDModel(PDModel dataModel, PDModel dataBaseModel) {
        Map<String, String> sqlMap = new HashMap<String, String>(2);
        try {
            PDMCompare pdmCompare = new PDMCompare();
            pdmCompare.compare(dataModel, dataBaseModel);
            sqlMap = pdmCompare.getSqlScript();
        }
        catch (Exception e) {
            logger.error("build sql error ", (Throwable)e);
        }
        String modelNumber = dataModel.getNumber();
        return this.outSqlMap(sqlMap, modelNumber);
    }

    public Map<String, Map<String, String>> outSqlMap(Map<String, String> sqlMap, String mod) {
        String prefix = this.getFilePrefix(this.getVer()) + "_" + mod + "_";
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : sqlMap.entrySet()) {
            String sql = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
            String key = prefix + entry.getKey() + ".sql";
            map.put(key, sql);
        }
        HashMap<String, Map<String, String>> sqlParameter = new HashMap<String, Map<String, String>>(8);
        if (!map.isEmpty()) {
            sqlParameter.put(mod, map);
        }
        return sqlParameter;
    }

    @NotNull
    protected String getFilePrefix(String ver) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Calendar calendar = Calendar.getInstance();
        if (COMPARE_SINGLE.equals(this.compareStrategy)) {
            int week = calendar.get(3) / 2;
            return "kd_" + ver + "." + week;
        }
        String date = dateFormat.format(new Date());
        return "kd_" + ver + "_" + date;
    }

    private String getVer() {
        return (String)DB.query((DBRoute)DBRoute.base, (String)"select fvalue from t_svc_customparam where fnumber = 'kd_developversion'", rs -> {
            String val;
            if (rs.next() && StringUtils.isNotBlank((CharSequence)(val = rs.getString(1)))) {
                return val;
            }
            return "1.5";
        });
    }
}

