/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.datamodel.meta.element.DMPackageAp;
import kd.bos.datamodel.meta.element.DataModelBaseElement;
import kd.bos.datamodel.meta.element.diagram.RelationShipSymbolAp;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.LineDirection;
import kd.bos.datamodel.meta.element.pdm.PhysicalDiagram;
import kd.bos.datamodel.meta.element.pdm.Position;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.ReferenceSymbolAp;
import kd.bos.datamodel.meta.element.pdm.RelNode;
import kd.bos.datamodel.meta.element.pdm.RelationShipAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.meta.element.pdm.TableSymbolAp;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.isv.ISVService;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

class PDMReader {
    private static final Namespace oNamespace = new Namespace("o", "object");
    private static final Namespace cNamespace = new Namespace("c", "collection");
    private static final Namespace aNamespace = new Namespace("a", "attribute");
    private static final String REF = "Ref";
    private static final String INDEX = "Index";
    private static final String KEY = "Key";
    private static final String UNIQUE = "Unique";
    private static final String INDEX_COLUMNS = "IndexColumns";
    private static final String INDEX_COLUMN = "IndexColumn";
    private static final String COLUMN = "Column";
    private static final String KEY_COLUMNS = "Key.Columns";
    private static final String DEFAULT_VALUE = "DefaultValue";
    private static final String DATA_TYPE = "DataType";
    private static final String LENGTH = "Length";
    private static final String COLUMN_MANDATORY = "Column.Mandatory";
    private static final String COMMENT = "Comment";
    private static final String ID = "Id";
    private static final String NAME = "Name";
    private static final String CODE = "Code";
    private static final String CREATION_DATE = "CreationDate";
    private static final String CREATOR = "Creator";
    private static final String MODIFICATION_DATE = "ModificationDate";
    private static final String MODIFIER = "Modifier";
    private static final String CLUSTER_OBJECT = "ClusterObject";
    private static final String PRIMARY_KEY = "PrimaryKey";
    private static final String INDEXES = "Indexes";
    private static final String KEYS = "Keys";
    private static final String COLUMNS = "Columns";
    private static final String JOINS = "Joins";
    private static final String REFERENCE_JOIN = "ReferenceJoin";
    private static final String CHILD_TABLE = "ChildTable";
    private static final String TABLE = "Table";
    private static final String SHORT_CUT = "Shortcut";
    private static final String PARENT_TABLE = "ParentTable";
    private static final String CARDINALITY = "Cardinality";
    private static final String REFERENCE = "Reference";
    private static final String REFERENCES = "References";
    private static final String PHYSICALDIAGRAMS = "PhysicalDiagrams";
    private static final String PHYSICALDIAGRAM = "PhysicalDiagram";
    private static final String SYMBOLS = "Symbols";
    private static final String TABLESYMBOL = "TableSymbol";
    private static final String OBJECT = "Object";
    private static final String REFERENCESYMBOL = "ReferenceSymbol";
    private static final String SOURCESYMBOL = "SourceSymbol";
    private static final String DESTINATIONSYMBOL = "DestinationSymbol";
    private static final String TABLES = "Tables";
    private static final String PACKAGE = "Package";
    private static final String PACKAGES = "Packages";
    private static final String KD_COMIS_BASE = "kd_comis_base";
    private static final String PRECISION = "Precision";
    private static final String RECT = "Rect";
    private static final String LISTOFPOINTS = "ListOfPoints";
    private static final String CONSTRAINTNAME = "ConstraintName";
    private final PDMEntityMetadata dataModel = new PDMEntityMetadata();
    private final Map<String, Object> itemMap = new HashMap<String, Object>(8);
    private final Document document;
    private String bizAppId;
    private String modelId;
    private String key;
    private LocaleString modelName;
    private String product;
    private LocaleString description;
    private long industry;
    private int itemIndex = 0;
    private final Set<String> itemKey = new HashSet<String>(8);

    public String getBizAppId() {
        return this.bizAppId;
    }

    public void setBizAppId(String bizAppId) {
        this.bizAppId = bizAppId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getIndustry() {
        return this.industry;
    }

    public void setIndustry(long industry) {
        this.industry = industry;
    }

    public PDMReader(Document document) {
        this.document = document;
    }

    public PDMReader(Document document, String modelId, String key, LocaleString modelName, String product, LocaleString description) {
        this.document = document;
        this.key = key;
        this.modelId = modelId;
        this.modelName = modelName;
        this.product = product;
        this.description = description;
    }

    public PDMEntityMetadata convertToDesignMeta() throws Exception {
        Element cPhysical;
        if (StringUtils.isEmpty((CharSequence)this.getBizAppId())) {
            throw new Exception("bizAppid must not be empty");
        }
        this.dataModel.beginInit();
        this.dataModel.setBizappId(this.getBizAppId());
        this.dataModel.setModelType("PhysicalDataModel");
        Element rootElement = this.document.getRootElement();
        Element rootObject = rootElement.element(new QName("RootObject", oNamespace));
        Element children = rootObject.element(new QName("Children", cNamespace));
        Element model = children.element(new QName("Model", oNamespace));
        Element code = model.element(new QName(CODE, aNamespace));
        String key = this.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            key = this.getTextFromEle(code);
        }
        String isv = ISVService.getISVInfo().getId();
        this.dataModel.setId(this.modelId);
        if (this.dataModel.getPdmDiagramMetadata() != null) {
            this.dataModel.getPdmDiagramMetadata().setId(this.modelId);
        }
        this.dataModel.setIsv(isv);
        this.dataModel.setNumber(key);
        this.dataModel.setName(this.modelName);
        this.dataModel.setProduct(this.product);
        this.dataModel.setCreator(RequestContext.get().getCurrUserId());
        this.dataModel.setCreatedDate(new Date());
        this.dataModel.setDescription(this.description);
        this.dataModel.setIndustry(this.getIndustry());
        Element packagesEle = model.element(new QName(PACKAGES, cNamespace));
        if (packagesEle != null) {
            List packageEles = packagesEle.elements(new QName(PACKAGE, oNamespace));
            ArrayList<DMPackageAp> packageAps = new ArrayList<DMPackageAp>(6);
            int i = 0;
            for (Element packageEle : packageEles) {
                Element physicalDiagrams;
                Element cReferences;
                DMPackageAp packageAp = new DMPackageAp();
                packageAp.setParentId(this.modelId);
                this.fillBaseProp(packageEle, (DataModelBaseElement)packageAp, i);
                Element tablesEle = packageEle.element(new QName(TABLES, cNamespace));
                if (tablesEle != null) {
                    int tableIdx = 0;
                    ArrayList<TableAp> tableAps = new ArrayList<TableAp>(6);
                    for (Element tableEle : tablesEle.elements(new QName(TABLE, oNamespace))) {
                        TableAp tableAp = this.getTableAp(tableEle, tableIdx);
                        tableAp.setParentId(packageAp.getId());
                        tableAps.add(tableAp);
                        ++tableIdx;
                    }
                    Collections.sort(tableAps, (o1, o2) -> {
                        if (o1.getTableName() == null && o2.getTableName() == null) {
                            return 0;
                        }
                        if (o1.getTableName() == null) {
                            return -1;
                        }
                        if (o2.getTableName() == null) {
                            return 1;
                        }
                        return o1.getTableName().compareTo(o2.getTableName());
                    });
                    for (int i1 = 0; i1 < tableAps.size(); ++i1) {
                        ((TableAp)tableAps.get(i1)).setSeq(i1);
                    }
                    packageAp.getTableAps().addAll(tableAps);
                }
                if ((cReferences = packageEle.element(new QName(REFERENCES, cNamespace))) != null) {
                    int refIdx = 0;
                    for (Element oReference : cReferences.elements(new QName(REFERENCE, oNamespace))) {
                        RelationShipAp relationshipAp = this.getRelationshipAp(oReference, refIdx);
                        if (relationshipAp != null) {
                            relationshipAp.setParentId(packageAp.getId());
                            packageAp.getRelationshipAps().add(relationshipAp);
                        }
                        ++refIdx;
                    }
                }
                if ((physicalDiagrams = packageEle.element(new QName(PHYSICALDIAGRAMS, cNamespace))) != null) {
                    int diaIdx = 0;
                    for (Element physicalDiagram : physicalDiagrams.elements(new QName(PHYSICALDIAGRAM, oNamespace))) {
                        PhysicalDiagram diagram = this.getPhySicalDiagram(physicalDiagram, diaIdx);
                        diagram.setParentId(packageAp.getId());
                        this.dataModel.getPdmDiagramMetadata().getPhysicalDiagramAps().add(diagram);
                        ++diaIdx;
                    }
                }
                packageAps.add(packageAp);
                ++i;
            }
            Collections.sort(packageAps, (o1, o2) -> {
                if (o1.getKey() == null && o2.getKey() == null) {
                    return 0;
                }
                if (o1.getKey() == null) {
                    return -1;
                }
                if (o2.getKey() == null) {
                    return 1;
                }
                return o1.getKey().compareTo(o2.getKey());
            });
            for (int i1 = 0; i1 < packageAps.size(); ++i1) {
                ((DMPackageAp)packageAps.get(i1)).setSeq(i1);
            }
            this.dataModel.getPackageAps().addAll(packageAps);
        }
        if ((cPhysical = model.element(new QName(PHYSICALDIAGRAMS, cNamespace))) != null) {
            List oPhysicalGrams = cPhysical.elements(new QName(PHYSICALDIAGRAM, oNamespace));
            int phyGramIdx = 0;
            for (Element oPhysicalGram : oPhysicalGrams) {
                PhysicalDiagram diagram = this.getPhySicalDiagram(oPhysicalGram, phyGramIdx);
                diagram.setParentId(this.dataModel.getId());
                this.dataModel.getPdmDiagramMetadata().getPhysicalDiagramAps().add(diagram);
                ++phyGramIdx;
            }
        }
        this.dataModel.getPdmDiagramMetadata().setBizappId(this.dataModel.getBizappId());
        this.dataModel.getPdmDiagramMetadata().setNumber(this.dataModel.getNumber());
        this.dataModel.getPdmDiagramMetadata().setName(this.dataModel.getName());
        this.dataModel.getPdmDiagramMetadata().setProduct(this.dataModel.getProduct());
        this.dataModel.getPdmDiagramMetadata().setIsv(this.dataModel.getIsv());
        this.dataModel.getPdmDiagramMetadata().setCreatedDate(this.dataModel.getCreatedDate());
        this.dataModel.getPdmDiagramMetadata().setCreator(this.dataModel.getCreator());
        this.dataModel.getPdmDiagramMetadata().setDescription(this.dataModel.getDescription());
        this.dataModel.getPdmDiagramMetadata().setIndustry(this.dataModel.getIndustry());
        this.dataModel.endInit();
        return this.dataModel;
    }

    private PhysicalDiagram getPhySicalDiagram(Element oPhysicalDiagram, int index) {
        PhysicalDiagram physicalDiagram = new PhysicalDiagram();
        this.fillBaseProp(oPhysicalDiagram, (DataModelBaseElement)physicalDiagram, index);
        Element cSymbols = oPhysicalDiagram.element(new QName(SYMBOLS, cNamespace));
        if (cSymbols != null) {
            List oTableSymbols = cSymbols.elements(new QName(TABLESYMBOL, oNamespace));
            for (Element tableSymbol : oTableSymbols) {
                List objects = tableSymbol.elements(new QName(OBJECT, cNamespace));
                int refTableIdx = 0;
                for (Element object : objects) {
                    String refTable;
                    Element oTable = object.element(new QName(TABLE, oNamespace));
                    if (oTable != null && this.itemMap.get(refTable = oTable.attribute(REF).getValue()) instanceof TableAp) {
                        TableSymbolAp tableSymbolAP = new TableSymbolAp();
                        this.fillBaseProp(tableSymbol, (DataModelBaseElement)tableSymbolAP, refTableIdx);
                        this.setPosition(tableSymbol, tableSymbolAP);
                        tableSymbolAP.setTableId(((TableAp)this.itemMap.get(refTable)).getId());
                        tableSymbolAP.setParentId(physicalDiagram.getId());
                        physicalDiagram.getTableSymbolAps().add(tableSymbolAP);
                    }
                    ++refTableIdx;
                }
            }
            List oRefSymbols = cSymbols.elements(new QName(REFERENCESYMBOL, oNamespace));
            int refIdx = 0;
            for (Element oRefSymbol : oRefSymbols) {
                Object cSourceSymbol2;
                ReferenceSymbolAp referenceSymbolAp = new ReferenceSymbolAp();
                this.fillBaseProp(oRefSymbol, (DataModelBaseElement)referenceSymbolAp, refIdx);
                List cSourceSymbols = oRefSymbol.elements(new QName(SOURCESYMBOL, cNamespace));
                for (Object cSourceSymbol2 : cSourceSymbols) {
                    Element sourceSymbol = cSourceSymbol2.element(new QName(TABLESYMBOL, oNamespace));
                    if (sourceSymbol == null) continue;
                    String refId = sourceSymbol.attribute(REF).getValue();
                    TableSymbolAp symbolAP = new TableSymbolAp();
                    if (!(this.itemMap.get(refId) instanceof TableSymbolAp)) continue;
                    TableSymbolAp tableSymbolAp = (TableSymbolAp)this.itemMap.get(refId);
                    String tableId = tableSymbolAp.getTableId();
                    symbolAP.setParentId(referenceSymbolAp.getId());
                    symbolAP.setTableId(tableId);
                    referenceSymbolAp.setSourceSymbol(symbolAP);
                }
                List cDesSymbols = oRefSymbol.elements(new QName(DESTINATIONSYMBOL, cNamespace));
                cSourceSymbol2 = cDesSymbols.iterator();
                while (cSourceSymbol2.hasNext()) {
                    String refId;
                    Element cDesSymbol = (Element)cSourceSymbol2.next();
                    Element desSymbol = cDesSymbol.element(new QName(TABLESYMBOL, oNamespace));
                    if (desSymbol == null || !(this.itemMap.get(refId = desSymbol.attribute(REF).getValue()) instanceof TableSymbolAp)) continue;
                    TableSymbolAp symbolAP = new TableSymbolAp();
                    TableSymbolAp ap = (TableSymbolAp)this.itemMap.get(refId);
                    String tableId = ap.getTableId();
                    symbolAP.setParentId(referenceSymbolAp.getId());
                    symbolAP.setTableId(tableId);
                    referenceSymbolAp.setDestinationSymbol(symbolAP);
                }
                Element cObject = oRefSymbol.element(new QName(OBJECT, cNamespace));
                if (cObject != null) {
                    List cReferences = cObject.elements(new QName(REFERENCE, oNamespace));
                    for (Element cReference : cReferences) {
                        String refId = cReference.attribute(REF).getValue();
                        if (!(this.itemMap.get(refId) instanceof RelationShipAp)) continue;
                        RelationShipAp relationShipAp = (RelationShipAp)this.itemMap.get(refId);
                        RelationShipSymbolAp symbolAp = new RelationShipSymbolAp();
                        symbolAp.setParentId(referenceSymbolAp.getId());
                        symbolAp.setRelationShipId(relationShipAp.getId());
                        referenceSymbolAp.setRelationShipSymbol(symbolAp);
                    }
                }
                referenceSymbolAp.setParentId(physicalDiagram.getId());
                if (referenceSymbolAp.getSourceSymbol() != null && referenceSymbolAp.getDestinationSymbol() != null) {
                    physicalDiagram.getReferenceSymbolAps().add(referenceSymbolAp);
                }
                ++refIdx;
            }
        }
        this.handleCoordinate(physicalDiagram);
        return physicalDiagram;
    }

    private void handleCoordinate(PhysicalDiagram physicalDiagram) {
        Position position;
        if (physicalDiagram.getTableSymbolAps().isEmpty()) {
            return;
        }
        List tableSymbolAps = physicalDiagram.getTableSymbolAps();
        int xMin = 0;
        int yMax = 0;
        for (int i = 0; i < tableSymbolAps.size(); ++i) {
            TableSymbolAp tableSymbolAp = (TableSymbolAp)tableSymbolAps.get(i);
            position = tableSymbolAp.getPosition();
            if (i == 0) {
                xMin = position.getX();
                yMax = position.getY();
                continue;
            }
            if (xMin > position.getX()) {
                xMin = position.getX();
            }
            if (yMax >= position.getY()) continue;
            yMax = position.getY();
        }
        for (TableSymbolAp tableSymbolAp : tableSymbolAps) {
            position = tableSymbolAp.getPosition();
            int x = position.getX();
            int y = position.getY();
            if (xMin < 0) {
                position.setX(Math.abs(x + Math.abs(xMin) + 50));
            }
            if (yMax <= 0) continue;
            position.setY(Math.abs(y - yMax) + 50);
        }
    }

    private void setLinePoint(Element oRefSymbol, ReferenceSymbolAp referenceSymbolAp) {
        Element element = oRefSymbol.element(new QName(LISTOFPOINTS, aNamespace));
        Element element1 = oRefSymbol.element(new QName(RECT, aNamespace));
        if (element != null && element1 != null) {
            String listPointValue = element.getText();
            String rectValue = element1.getText();
            List<Integer> rct = this.getLinePoints(rectValue);
            List<Integer> lpv = this.getLinePoints(listPointValue);
            Integer t_x1 = rct.get(0);
            Integer t_y1 = rct.get(1);
            Integer t_x2 = rct.get(2);
            Integer t_y2 = rct.get(3);
            Integer x1 = lpv.get(0);
            Integer y1 = lpv.get(1);
            Integer x2 = lpv.get(lpv.size() - 2);
            Integer y2 = lpv.get(lpv.size() - 1);
            if (x1.equals(t_x1)) {
                referenceSymbolAp.setSourceLinePoint(LineDirection.left.name());
            } else if (x1.equals(t_x2)) {
                referenceSymbolAp.setSourceLinePoint(LineDirection.right.name());
            } else if (y1.equals(t_y1)) {
                referenceSymbolAp.setSourceLinePoint(LineDirection.bottom.name());
            } else if (y1.equals(t_y2)) {
                referenceSymbolAp.setSourceLinePoint(LineDirection.top.name());
            }
            if (x2.equals(t_x1)) {
                referenceSymbolAp.setDestinationLinePoint(LineDirection.left.name());
            } else if (x2.equals(t_x2)) {
                referenceSymbolAp.setDestinationLinePoint(LineDirection.right.name());
            } else if (y2.equals(t_y1)) {
                referenceSymbolAp.setDestinationLinePoint(LineDirection.bottom.name());
            } else if (y2.equals(t_y2)) {
                referenceSymbolAp.setDestinationLinePoint(LineDirection.top.name());
            }
        }
    }

    private void setPosition(Element tableSymbol, TableSymbolAp symbolAp) {
        Element element = tableSymbol.element(new QName(RECT, aNamespace));
        if (element != null) {
            String rectValue = element.getText();
            List<Integer> coordinate = this.getCoordinate(rectValue);
            if (coordinate.size() != 4) {
                return;
            }
            Position position = new Position();
            position.setX(coordinate.get(0).intValue());
            position.setY(coordinate.get(3).intValue());
            symbolAp.setPosition(position);
        }
    }

    private List<Integer> getLinePoints(String value) {
        Pattern pattern = Pattern.compile("-?\\d+");
        Matcher matcher = pattern.matcher(value);
        ArrayList<Integer> cds = new ArrayList<Integer>(4);
        while (matcher.find()) {
            int coordinate = Integer.parseInt(matcher.group());
            cds.add(coordinate);
        }
        return cds;
    }

    private List<Integer> getCoordinate(String value) {
        Pattern pattern = Pattern.compile("-?\\d+");
        Matcher matcher = pattern.matcher(value);
        ArrayList<Integer> coordinates = new ArrayList<Integer>(4);
        int i = 0;
        while (matcher.find()) {
            int coordinate = Integer.parseInt(matcher.group());
            if (i % 2 == 0) {
                coordinates.add((int)Math.floor((double)coordinate / 30.0));
            } else {
                coordinates.add((int)Math.floor((double)coordinate / 20.0));
            }
            ++i;
        }
        return coordinates;
    }

    private RelationShipAp getRelationshipAp(Element oReference, int index) throws Exception {
        List cJoins;
        RelationShipAp relationshipAp = new RelationShipAp();
        this.fillBaseProp(oReference, (DataModelBaseElement)relationshipAp, index);
        Element aCardinality = oReference.element(new QName(CARDINALITY, aNamespace));
        relationshipAp.setType(this.getTextFromEle(aCardinality));
        Element cParentTable = oReference.element(new QName(PARENT_TABLE, cNamespace));
        Element oParentTable = cParentTable.element(new QName(TABLE, oNamespace));
        if (oParentTable == null) {
            return null;
        }
        Element shortCut = cParentTable.element(new QName(SHORT_CUT, oNamespace));
        if (shortCut != null) {
            return null;
        }
        String parentRefid = oParentTable.attribute(REF).getValue();
        Object parentTable = this.itemMap.get(parentRefid);
        if (!(parentTable instanceof TableAp)) {
            throw new Exception(String.format("Reference[%s] ParentTable can not found ref [%s]", relationshipAp.getName(), parentRefid));
        }
        RelNode startNode = new RelNode();
        startNode.setId(Uuid16.create().toString());
        startNode.setParentId(relationshipAp.getParentId());
        startNode.setTableId(((TableAp)parentTable).getId());
        relationshipAp.setRelStart(startNode);
        Element cChildTable = oReference.element(new QName(CHILD_TABLE, cNamespace));
        Element oChildTable = cChildTable.element(new QName(TABLE, oNamespace));
        String childRefid = oChildTable.attribute(REF).getValue();
        Object childTable = this.itemMap.get(childRefid);
        if (!(childTable instanceof TableAp)) {
            throw new Exception(String.format("Reference[%s] ChildTable can not found ref [%s]", relationshipAp.getName(), childRefid));
        }
        Element cJoinsEle = oReference.element(new QName(JOINS, cNamespace));
        if (cJoinsEle != null && (cJoins = cJoinsEle.elements(new QName(REFERENCE_JOIN, oNamespace))) != null) {
            for (Element join : cJoins) {
                Element Object1 = join.element(new QName("Object1", cNamespace));
                Element oColumn1 = Object1.element(new QName(COLUMN, oNamespace));
                String refid1 = oColumn1.attribute(REF).getValue();
                Object column1 = this.itemMap.get(refid1);
                if (!(column1 instanceof ColumnAp)) {
                    throw new Exception(String.format("Reference[%s] cJoins can not found ref [%s]", relationshipAp.getName(), refid1));
                }
                RefColumnAp refColumnAp = new RefColumnAp();
                refColumnAp.setId(Uuid16.create().toString());
                refColumnAp.setParentId(startNode.getId());
                refColumnAp.setRefId(((ColumnAp)column1).getId());
                startNode.getColumnIds().add(refColumnAp);
                Element Object2 = join.element(new QName("Object2", cNamespace));
                if (Object2 == null) continue;
                Element oColumn2 = Object2.element(new QName(COLUMN, oNamespace));
                String refid2 = oColumn2.attribute(REF).getValue();
                Object column2 = this.itemMap.get(refid2);
                if (!(column2 instanceof ColumnAp)) {
                    throw new Exception(String.format("Reference[%s] cJoins can not found ref [%s]", relationshipAp.getName(), refid2));
                }
                RelNode endNode = new RelNode();
                endNode.setId(Uuid16.create().toString());
                endNode.setParentId(relationshipAp.getId());
                endNode.setTableId(((TableAp)childTable).getId());
                RefColumnAp refColumnAp1 = new RefColumnAp();
                refColumnAp1.setId(Uuid16.create().toString());
                refColumnAp1.setParentId(endNode.getId());
                refColumnAp1.setRefId(((ColumnAp)column2).getId());
                endNode.getColumnIds().add(refColumnAp1);
                relationshipAp.setRelEnd(endNode);
            }
        }
        return relationshipAp;
    }

    private TableAp getTableAp(Element tableEle, int seq) throws Exception {
        Element cCluster;
        Element cPrimaryKey;
        List indexes;
        Element indexesEle;
        List keys;
        Element keysEle;
        List columns;
        Element columnsEle;
        String name;
        TableAp tableAp = new TableAp();
        this.fillBaseProp(tableEle, (DataModelBaseElement)tableAp, seq);
        Element code = tableEle.element(new QName(CODE, aNamespace));
        tableAp.setTableName(this.getTextFromEle(code));
        Element modifyDate = tableEle.element(new QName(MODIFICATION_DATE, aNamespace));
        String textFromEle = this.getTextFromEle(modifyDate);
        tableAp.setVersion((long)Integer.parseInt(textFromEle) * 1000L);
        LocaleString localeName = tableAp.getName();
        if (localeName != null && StringUtils.isNotEmpty((CharSequence)(name = localeName.getLocaleValue_zh_CN()))) {
            int indexEnd;
            int indexStart = name.indexOf("(") > 0 ? name.indexOf("(") : name.indexOf("\uff08");
            int n = indexEnd = name.indexOf(")") > 0 ? name.indexOf(")") : name.indexOf("\uff09");
            if (indexStart > 0 && indexEnd > 0) {
                tableAp.setName(new LocaleString(name.substring(indexStart + 1, indexEnd)));
            }
        }
        if ((columnsEle = tableEle.element(new QName(COLUMNS, cNamespace))) != null && (columns = columnsEle.elements(new QName(COLUMN, oNamespace))) != null) {
            int columnIdx = 0;
            for (Object columnEle : columns) {
                ColumnAp ColumnAp2 = this.getColumnAp((Element)columnEle, columnIdx);
                ColumnAp2.setParentId(tableAp.getId());
                tableAp.getColumns().add(ColumnAp2);
                ++columnIdx;
            }
        }
        if ((keysEle = tableEle.element(new QName(KEYS, cNamespace))) != null && (keys = keysEle.elements(new QName(KEY, oNamespace))) != null) {
            int keyIdx = 0;
            for (Element keyEle : keys) {
                this.initDMKey(keyEle, tableAp, keyIdx);
                ++keyIdx;
            }
        }
        if ((indexesEle = tableEle.element(new QName(INDEXES, cNamespace))) != null && (indexes = indexesEle.elements(new QName(INDEX, oNamespace))) != null) {
            int idxIdx = 0;
            for (Element index : indexes) {
                IndexAp IndexAp2 = this.getIndexAp(index, tableAp, idxIdx);
                IndexAp2.setParentId(tableAp.getId());
                tableAp.getIndexs().add(IndexAp2);
                ++idxIdx;
            }
        }
        if ((cPrimaryKey = tableEle.element(new QName(PRIMARY_KEY, cNamespace))) != null) {
            PrimaryKeyAp primaryKey = this.getPrimaryKeyAp(cPrimaryKey, tableAp);
            if (primaryKey != null) {
                primaryKey.setParentId(tableAp.getId());
            }
            tableAp.setPrimaryKey(primaryKey);
        }
        if ((cCluster = tableEle.element(new QName(CLUSTER_OBJECT, cNamespace))) != null) {
            this.initDmCluster(cCluster, tableAp);
        }
        return tableAp;
    }

    private void initDmCluster(Element cCluster, TableAp tableAp) throws Exception {
        Element oKey;
        if (cCluster == null) {
            return;
        }
        Element oIndex = cCluster.element(new QName(INDEX, oNamespace));
        if (oIndex != null) {
            String refid = oIndex.attribute(REF).getValue();
            Object index = this.itemMap.get(refid);
            if (!(index instanceof IndexAp)) {
                throw new Exception(String.format("tableAp [%s] ClusterObject Index can not found ref [%s]", tableAp, refid));
            }
            ((IndexAp)index).setCluster(true);
        }
        if ((oKey = cCluster.element(new QName(KEY, oNamespace))) != null) {
            String refid = oKey.attribute(REF).getValue();
            Object key = this.itemMap.get(refid);
            if (!(key instanceof PrimaryKeyAp)) {
                throw new Exception(String.format("tableAp [%s] ClusterObject Key can not found ref [%s]", tableAp, refid));
            }
            ((PrimaryKeyAp)key).setCluster(true);
        }
    }

    private PrimaryKeyAp getPrimaryKeyAp(Element cPrimaryKey, TableAp tableAp) throws Exception {
        Element oPrimaryKey = cPrimaryKey.element(new QName(KEY, oNamespace));
        if (oPrimaryKey == null) {
            return null;
        }
        String refid = oPrimaryKey.attribute(REF).getValue();
        Object dmKey = this.itemMap.get(refid);
        if (!(dmKey instanceof PrimaryKeyAp)) {
            throw new Exception(String.format("tableAp[%s] PrimaryKey can not found ref [%s]", tableAp, refid));
        }
        return (PrimaryKeyAp)dmKey;
    }

    private IndexAp getIndexAp(Element element, TableAp tableAp, int seq) throws Exception {
        List indexColumns;
        IndexAp IndexAp2 = new IndexAp();
        this.fillBaseProp(element, (DataModelBaseElement)IndexAp2, seq);
        IndexAp2.setTableName(tableAp.getTableName());
        Element code = element.element(new QName(CODE, aNamespace));
        IndexAp2.setIndexName(this.getTextFromEle(code));
        Element aUnique = element.element(new QName(UNIQUE, aNamespace));
        IndexAp2.setUnique(this.getBooleanFromEle(aUnique));
        Element indexColumnsEle = element.element(new QName(INDEX_COLUMNS, cNamespace));
        if (indexColumnsEle != null && (indexColumns = indexColumnsEle.elements(new QName(INDEX_COLUMN, oNamespace))) != null) {
            int cloumnIdx = 0;
            for (Element indexColumn : indexColumns) {
                RefColumnAp indexColumnAp = new RefColumnAp();
                this.fillBaseProp(indexColumn, (DataModelBaseElement)indexColumnAp, cloumnIdx);
                Element cColumn = indexColumn.element(new QName(COLUMN, cNamespace));
                Element oColumn = cColumn.element(new QName(COLUMN, oNamespace));
                String refid = oColumn.attribute(REF).getValue();
                Object columnAp = this.itemMap.get(refid);
                if (!(columnAp instanceof ColumnAp)) {
                    throw new Exception(String.format("tableAp[%s] RefColumnAp [%s] Column not found, Ref is %s", tableAp, indexColumnAp.getId(), refid));
                }
                indexColumnAp.setParentId(IndexAp2.getId());
                indexColumnAp.setRefId(((ColumnAp)columnAp).getId());
                IndexAp2.getIndexColumnAps().add(indexColumnAp);
                ++cloumnIdx;
            }
        }
        return IndexAp2;
    }

    private void initDMKey(Element element, TableAp tableAp, int keyIdx) throws Exception {
        List columnEles;
        PrimaryKeyAp dmKey = new PrimaryKeyAp();
        this.fillBaseProp(element, (DataModelBaseElement)dmKey, keyIdx);
        Element constraint = element.element(new QName(CONSTRAINTNAME, aNamespace));
        if (constraint == null) {
            String pk = "PK_" + tableAp.getTableName().toUpperCase(Locale.ENGLISH);
            dmKey.setPk(pk);
        } else {
            dmKey.setPk(this.getTextFromEle(constraint));
        }
        dmKey.setTableName(tableAp.getTableName());
        dmKey.setParentId(tableAp.getId());
        Element keyColumnsEle = element.element(new QName(KEY_COLUMNS, cNamespace));
        if (keyColumnsEle != null && (columnEles = keyColumnsEle.elements(new QName(COLUMN, oNamespace))) != null) {
            for (Element columnEle : columnEles) {
                RefColumnAp refColumnAp = new RefColumnAp();
                String refid = columnEle.attribute(REF).getValue();
                Object ColumnAp2 = this.itemMap.get(refid);
                if (!(ColumnAp2 instanceof ColumnAp)) {
                    throw new Exception(String.format("tableAp[%s] PrimaryKey [%s] Column not found, Ref is %s", tableAp, dmKey.getTableName(), refid));
                }
                ((ColumnAp)ColumnAp2).setPrimaryKey(true);
                refColumnAp.setId(Uuid16.create().toString());
                refColumnAp.setParentId(dmKey.getId());
                refColumnAp.setRefId(((ColumnAp)ColumnAp2).getId());
                dmKey.getPkColumnList().add(refColumnAp);
            }
        }
    }

    private ColumnAp getColumnAp(Element element, int seq) {
        ColumnAp ColumnAp2 = new ColumnAp();
        this.fillBaseProp(element, (DataModelBaseElement)ColumnAp2, seq);
        Element code = element.element(new QName(CODE, aNamespace));
        ColumnAp2.setColumnName(this.getTextFromEle(code));
        Element defaultValueEle = element.element(new QName(DEFAULT_VALUE, aNamespace));
        ColumnAp2.setColumnDef((Object)this.getTextFromEle(defaultValueEle));
        Element cDataType = element.element(new QName(DATA_TYPE, aNamespace));
        String dataType = this.getTextFromEle(cDataType);
        if (dataType != null && dataType.length() > 0) {
            int index = dataType.indexOf("(");
            if (index > 0) {
                dataType = dataType.substring(0, index);
            }
            if (StringUtils.isNotBlank((CharSequence)dataType)) {
                dataType = dataType.trim();
            }
        }
        ColumnAp2.setColunmType((int)DataType.valueOfName((String)this.DataTypeConvert(dataType)).getValue());
        Element cLength = element.element(new QName(LENGTH, aNamespace));
        int length = 0;
        if (StringUtils.isNotEmpty((CharSequence)this.getTextFromEle(cLength))) {
            length = Integer.parseInt(this.getTextFromEle(cLength));
        }
        ColumnAp2.setColumnLength(length);
        Element aPrecision = element.element(new QName(PRECISION, aNamespace));
        int digits = 0;
        if (StringUtils.isNotEmpty((CharSequence)this.getTextFromEle(aPrecision))) {
            digits = Integer.parseInt(this.getTextFromEle(aPrecision));
        }
        ColumnAp2.setColumnPrecision(digits);
        Element nullable = element.element(new QName(COLUMN_MANDATORY, aNamespace));
        ColumnAp2.setNotNull(this.getBooleanFromEle(nullable));
        Element aComment = element.element(new QName(COMMENT, aNamespace));
        ColumnAp2.setDescription(this.getTextFromEle(aComment));
        return ColumnAp2;
    }

    private void fillBaseProp(Element element, DataModelBaseElement apInfo, int index) {
        Attribute idAttr = element.attribute(ID);
        if (idAttr == null) {
            return;
        }
        Element name = element.element(new QName(NAME, aNamespace));
        apInfo.setName(new LocaleString(this.getTextFromEle(name)));
        Element code = element.element(new QName(CODE, aNamespace));
        String key = this.getTextFromEle(code);
        if (!this.itemKey.add(key)) {
            key = key + "_" + this.itemIndex;
            ++this.itemIndex;
        }
        this.itemKey.add(key);
        apInfo.setKey(key);
        String id = idAttr.getValue();
        apInfo.setId(id);
        apInfo.setSeq(index);
        this.itemMap.put(id, apInfo);
    }

    private String getTextFromEle(Element element) {
        String text = null;
        if (element != null) {
            text = element.getText();
        }
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    private boolean getBooleanFromEle(Element element) {
        return "1".equals(this.getTextFromEle(element));
    }

    private String DataTypeConvert(String type) {
        if (type == null) {
            return "VARCHAR";
        }
        String dataType = type = type.toLowerCase();
        switch (type) {
            case "vchar": 
            case "vachar": 
            case "varchar2": {
                dataType = "VARCHAR";
                break;
            }
            case "nvarchar2": {
                dataType = "NVARCHAR";
                break;
            }
            case "ntext": {
                dataType = "NCLOB";
                break;
            }
            case "image": {
                dataType = "BLOB";
                break;
            }
            case "text": {
                dataType = "CLOB";
            }
        }
        return dataType;
    }
}

