/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.datamodel.meta.element.BaseControl;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.IndexAp;
import kd.bos.datamodel.meta.element.pdm.PrimaryKeyAp;
import kd.bos.datamodel.meta.element.pdm.RefColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.datamodel.metadata.DMClientMetadata;
import kd.bos.datamodel.model.validator.IValidateResult;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResult;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.PDMValidator;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.datamodel.pdm.sqlscript.ScriptGenerator;
import kd.bos.designer.table.AbstractValidator;
import kd.bos.designer.table.ColumnValidator;
import kd.bos.designer.table.IndexValidator;
import kd.bos.designer.table.ValidatorResult;
import kd.bos.designer.utils.DataModelUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.mvc.SessionManager;

public class TablePlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String COLUMN = "column";
    private static final String TAB_AP = "tabap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String COLUMN_ENTRYENTITY = "columnentryentity";
    private static final String INDEX_ENTRYENTITY = "indexentryentity";
    private static final String PRIMARY_ENTRYENTITY = "primarykeyentryentity";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String COLUMN_TYPE = "columntype";
    private static final String LENGTH = "length";
    private static final String PRECISION = "precision";
    private static final String ISNOTNULL = "isnotnull";
    private static final String DEFAULT = "default";
    private static final String ISPRIMARYKEY = "isprimarykey";
    private static final String INDEX_ID = "indexid";
    private static final String INDEX_NAME = "indexname";
    private static final String INDEX_NUMBER = "indexnumber";
    private static final String TABLE_NAME = "tablename";
    private static final String UNIQUE = "unique";
    private static final String INDEX_CLUSTER = "indexcluster";
    private static final String INDEX_COLUMNS = "index_columns";
    private static final String REF_MAPPING = "refidmapping";
    private static final String INDEX_CURRENT_ROW = "indexCurrentRow";
    private static final String PRIMARYKEY_ID = "primarykeyid";
    private static final String PRIMARYKEY_NAME = "primarykeyname";
    private static final String PRIMARYKEY_NUMBER = "primarykeynumber";
    private static final String PRIMARYKEY_COLUMNS = "primarykeycolumns";
    private static final String NEW_ENTRY = "newentry";
    private static final String CURRENT_TAB = "currentTab";
    private static final String BTN_OK = "btnok";
    private static final String PARAM = "param";
    private static final String MODEL_TYPE = "PhysicalDataModel";
    private static final String BOS_MODELASSET_COLUMN = "bos_modelasset_column";
    private static final String COLUMN_CALL_BACK = "columnCallBack";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final String BOS_MODELASSET_DEFAULT = "bos_modelasset_default";
    private static final String DEFAULT_CALL_BACK = "defaultCallBack";
    private static final String TABLE_ID = "tableId";
    private static final String TABLE_INFO = "tableInfo";
    private static final String PRIMARY_MAPPING = "primarymapping";
    private static final String KING_DEE = "kingdee";
    private static final String FFIELD = "ffield_";
    private static final String TABLE_NUMBER = "tablenumber";
    private static final String TB_NAME = "tbname";
    private static final String DESCRIPTION = "description";
    private static final String TABLENAME = "table_name";
    private static final String CODE_EDIT_AP = "codeeditap";
    private static final String DDL = "ddl";
    private static final String PRIMARY_CLUSTER = "primarycluster";
    private static final String INDEX = "index";
    private static final String BASEINFO = "baseinfo";
    private static final String PRIMARY_KEY = "primarykey";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String COLUMN_DESCRIPTION = "columndescription";

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
        tab.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{BTN_OK, DEFAULT});
    }

    public void afterCreateNewData(EventObject e) {
        this.tabSelected(new TabSelectEvent((Object)this, BASEINFO));
        ComboEdit dataTypeEdit = (ComboEdit)this.getControl(COLUMN_TYPE);
        DataType[] dataTypes = DataType.values();
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        Arrays.stream(dataTypes).forEach(dataType -> {
            if (DataType.CLOB != dataType) {
                String name = dataType.name();
                if (DataType.BLOB == dataType) {
                    name = name + "(IMAGE)";
                }
                if (DataType.NCLOB == dataType) {
                    name = name + "(NTEXT)";
                }
                itemList.add(new ComboItem(new LocaleString(name), String.valueOf(dataType.getValue())));
            }
        });
        itemList.sort(Comparator.comparing(o -> o.getCaption().getLocaleValue()));
        dataTypeEdit.setComboItems(itemList);
        TableAp tableAp = this.convertParam();
        this.initIndexColumn(tableAp);
        if (tableAp != null) {
            tableAp.createIndex(false);
            this.fillBaseInfo(tableAp);
            this.fillColumnEntity(tableAp);
            this.fillIndexEntity(tableAp);
            this.fillPrimaryKeyEntity(tableAp);
        }
    }

    private void initIndexColumn(TableAp tableAp) {
        if (tableAp == null || tableAp.getColumns().isEmpty()) {
            return;
        }
        this.initIndexColumn(tableAp.getColumns());
    }

    private void initIndexColumn() {
        List<ColumnAp> columns = this.getColumns();
        this.initIndexColumn(columns);
    }

    private void changePrimaryRefColumn(String oldColumnValue, String newColumnValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PRIMARY_ENTRYENTITY);
        if (entryEntity.isEmpty() || StringUtils.isBlank((CharSequence)newColumnValue) || StringUtils.isBlank((CharSequence)oldColumnValue)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String[] items;
            String value = (String)this.getModel().getValue(PRIMARYKEY_COLUMNS, i);
            ArrayList<String> primaryRefColumns = new ArrayList<String>(10);
            if (!StringUtils.isNotBlank((CharSequence)value) || !value.contains(oldColumnValue)) continue;
            for (String item : items = value.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)item)) continue;
                if (item.equals(oldColumnValue)) {
                    primaryRefColumns.add(newColumnValue);
                    continue;
                }
                primaryRefColumns.add(item);
            }
            String v = StringUtils.join((Object[])primaryRefColumns.toArray(), (String)",");
            this.getModel().setValue(PRIMARYKEY_COLUMNS, (Object)v, i);
        }
    }

    private void changeIndexRefColumn(String oldColumnValue, String newColumnValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INDEX_ENTRYENTITY);
        if (entryEntity.isEmpty() || StringUtils.isBlank((CharSequence)newColumnValue) || StringUtils.isBlank((CharSequence)oldColumnValue)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String[] items;
            String value = (String)this.getModel().getValue(INDEX_COLUMNS, i);
            ArrayList<String> refColumnValue = new ArrayList<String>(10);
            if (!StringUtils.isNotBlank((CharSequence)value) || !value.contains(oldColumnValue)) continue;
            for (String item : items = value.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)item)) continue;
                if (item.equals(oldColumnValue)) {
                    refColumnValue.add(newColumnValue);
                    continue;
                }
                refColumnValue.add(item);
            }
            String v = "," + StringUtils.join((Object[])refColumnValue.toArray(), (String)",") + ",";
            this.getModel().setValue(INDEX_COLUMNS, (Object)v, i);
        }
    }

    private void initIndexColumn(List<ColumnAp> columnAps) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(columnAps.size());
        for (ColumnAp columnAp : columnAps) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(columnAp.getColumnName()));
            comboItem.setValue(columnAp.getColumnName());
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(INDEX_COLUMNS);
        comboEdit.setComboItems(comboItems);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getOperationKey();
        String currentTab = this.getPageCache().get(CURRENT_TAB);
        String currentEntryEntity = currentTab + ENTRY_ENTITY;
        if (NEW_ENTRY.equals(key)) {
            this.newEntry(currentEntryEntity);
        } else if (DELETE_ENTRY.equals(key) && COLUMN.equals(evt.getItemKey())) {
            this.deleteEntry();
        }
    }

    private void newEntry(String currentEntryEntity) {
        int newEntryRow = this.getModel().createNewEntryRow(currentEntryEntity);
        if (COLUMN_ENTRYENTITY.equals(currentEntryEntity)) {
            String columnNumber = this.getColumnNumber(newEntryRow + 1);
            this.getModel().beginInit();
            this.getModel().setValue(NAME, (Object)columnNumber, newEntryRow);
            this.getModel().setValue(NUMBER, (Object)columnNumber, newEntryRow);
            this.getModel().setValue(COLUMN_TYPE, (Object)"1", newEntryRow);
            this.getModel().setValue(ID, (Object)Uuid16.create().toString(), newEntryRow);
            this.getModel().setValue(LENGTH, (Object)50, newEntryRow);
            this.getModel().setValue(ISNOTNULL, (Object)true, newEntryRow);
            this.handleColumnDefault(newEntryRow);
            this.getModel().endInit();
            this.getView().updateView(COLUMN_ENTRYENTITY);
        } else if (INDEX_ENTRYENTITY.equals(currentEntryEntity)) {
            String indexName = "idx_" + (newEntryRow + 1);
            this.getModel().setValue(INDEX_NAME, (Object)indexName.toUpperCase(Locale.ENGLISH), newEntryRow);
            this.getModel().setValue(INDEX_NUMBER, (Object)indexName.toUpperCase(Locale.ENGLISH), newEntryRow);
            this.getModel().setValue(INDEX_ID, (Object)Uuid16.create().toString(), newEntryRow);
        } else if (PRIMARY_ENTRYENTITY.equals(currentEntryEntity)) {
            String pkName = "pk_" + (newEntryRow + 1);
            this.getModel().setValue(PRIMARYKEY_NAME, (Object)pkName.toUpperCase(Locale.ENGLISH), newEntryRow);
            this.getModel().setValue(PRIMARYKEY_NUMBER, (Object)pkName.toUpperCase(Locale.ENGLISH), newEntryRow);
            this.getModel().setValue(PRIMARYKEY_ID, (Object)Uuid16.create().toString(), newEntryRow);
        }
    }

    private void deleteEntry() {
        this.checkIndexRefColumn();
        this.checkPrimaryKeyRefColumn();
    }

    private void checkIndexRefColumn() {
        List<ColumnAp> columns = this.getColumns();
        this.checkIndexRefColumn(columns);
    }

    private void checkIndexRefColumn(List<ColumnAp> columns) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INDEX_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return;
        }
        HashSet newColumn = new HashSet(columns.size());
        columns.forEach(c -> newColumn.add(c.getColumnName()));
        for (int i = 0; i < entryEntity.size(); ++i) {
            String[] items;
            String value = (String)this.getModel().getValue(INDEX_COLUMNS, i);
            ArrayList<String> newValue = new ArrayList<String>(10);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            for (String item : items = value.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)item) || !newColumn.contains(item)) continue;
                newValue.add(item);
            }
            if (!newValue.isEmpty()) {
                String comValue = "," + StringUtils.join((Object[])newValue.toArray(), (String)",") + ",";
                this.getModel().setValue(INDEX_COLUMNS, (Object)comValue, i);
                continue;
            }
            this.getModel().setValue(INDEX_COLUMNS, null, i);
        }
    }

    private void checkPrimaryKeyRefColumn() {
        List<ColumnAp> columns = this.getColumns();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PRIMARY_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return;
        }
        String primaryKeyValue = (String)this.getModel().getValue(PRIMARYKEY_COLUMNS, 0);
        if (StringUtils.isNotBlank((CharSequence)primaryKeyValue)) {
            String[] items;
            HashSet newColumn = new HashSet(columns.size());
            columns.forEach(c -> newColumn.add(c.getColumnName()));
            ArrayList<String> newValue = new ArrayList<String>(10);
            for (String item : items = primaryKeyValue.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)item) || !newColumn.contains(item)) continue;
                newValue.add(item);
            }
            if (!newValue.isEmpty()) {
                String comValue = StringUtils.join((Object[])newValue.toArray(), (String)",");
                this.getModel().setValue(PRIMARYKEY_COLUMNS, (Object)comValue, 0);
            } else {
                this.getModel().deleteEntryRow(PRIMARY_ENTRYENTITY, 0);
            }
        }
    }

    private String getColumnNumber(int suffix) {
        String id = ISVService.getISVInfo().getId();
        String number = KING_DEE.equals(id) ? FFIELD + suffix : "fk_" + id + "_" + FFIELD + suffix;
        return number.toUpperCase(Locale.ENGLISH);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.btnOk();
        } else if (DEFAULT.equals(key)) {
            this.showDefaultView();
        }
    }

    private void btnOk() {
        TableAp tableAp = this.buildTableInfo();
        this.updateModelModifiedStatus(tableAp);
        try {
            Table table = (Table)tableAp.createDMO();
            PDMValidator pdmValidator = new PDMValidator();
            List<Table> tableList = Collections.singletonList(table);
            pdmValidator.setNoModifiedErrorLevel(MessageType.Warn);
            List resultList = pdmValidator.validate(tableList);
            ArrayList<ValidateResultItem> validate = new ArrayList<ValidateResultItem>();
            for (IValidateResult result : resultList) {
                if (!(result instanceof ValidateResult)) continue;
                validate.addAll(((ValidateResult)result).getResultItems());
            }
            validate.removeIf(validateResultItem -> validateResultItem.getMessageType() != MessageType.Error);
            if (!validate.isEmpty()) {
                StringBuilder message = new StringBuilder();
                validate.forEach(v -> message.append(v.getMessage()));
                this.getView().showErrorNotification(message.toString());
                return;
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        tableAp.createIndex(true);
        List items = tableAp.getItems();
        DMClientMetadata dmClientMetadata = new DMClientMetadata();
        items.add(0, tableAp);
        dmClientMetadata.setItems(items);
        MetadataSerializer serializer = new MetadataSerializer(MODEL_TYPE);
        Map dm = serializer.serializeToMap((Object)dmClientMetadata);
        List fields = (List)dm.get("Items");
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(2);
        res.put("table", fields.get(0));
        fields.remove(0);
        this.handlerColumnType(fields);
        res.put("fields", fields);
        this.getView().returnDataToParent(res);
        this.getView().close();
    }

    private void handlerColumnType(List<Object> fields) {
        if (fields.isEmpty()) {
            return;
        }
        for (Object field : fields) {
            Map f = (Map)field;
            String type = (String)f.get("_Type_");
            if (!"ColumnAp".equals(type)) continue;
            ((Map)field).putIfAbsent("ColumnType", 0);
        }
    }

    private TableAp buildTableInfo() {
        TableAp tableAp = new TableAp();
        String str = this.getPageCache().get(TABLE_INFO);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Map oldTable = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            String parentId = (String)oldTable.get("ParentId");
            Boolean allowDict = (Boolean)oldTable.get("AllowDict");
            String id = (String)oldTable.get("Id");
            tableAp.setId(id);
            tableAp.setParentId(parentId);
            if (allowDict != null) {
                tableAp.setAllowDict(allowDict.booleanValue());
            }
        }
        String tableNumber = (String)this.getModel().getValue(TABLE_NUMBER);
        String tableName = (String)this.getModel().getValue(TABLENAME);
        String name = (String)this.getModel().getValue(TB_NAME);
        String description = (String)this.getModel().getValue(DESCRIPTION);
        tableAp.setKey(tableNumber);
        tableAp.setName(new LocaleString(name));
        tableAp.setTableName(tableName);
        tableAp.setDescription(description);
        tableAp.setVersion(System.currentTimeMillis());
        tableAp.setColumns(this.getColumns(true));
        tableAp.setIndexs(this.getIndex());
        tableAp.setPrimaryKey(this.getPrimaryKey(tableAp.getTableName()));
        return tableAp;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (DEFAULT_CALL_BACK.equals(actionId) && e.getReturnData() != null) {
            Map res = (Map)e.getReturnData();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(COLUMN_ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            this.getModel().setValue(DEFAULT, res.get("value"), selectRows[0]);
        }
    }

    private List<ColumnAp> getColumns() {
        return this.getColumns(false);
    }

    private List<ColumnAp> getColumns(boolean isCollectColumn) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(COLUMN_ENTRYENTITY);
        ArrayList<ColumnAp> columns = new ArrayList<ColumnAp>(entryEntity.size());
        String tableId = this.getPageCache().get(TABLE_ID);
        HashMap<String, String> columnIdMapping = new HashMap<String, String>(entryEntity.size());
        for (DynamicObject object : entryEntity) {
            ColumnAp columnAp = new ColumnAp();
            columnAp.setId(object.getString(ID));
            columnAp.setParentId(tableId);
            columnAp.setColumnDef((Object)object.getString(DEFAULT));
            columnAp.setPrimaryKey(object.getBoolean(ISPRIMARYKEY));
            columnAp.setColunmType(this.getColumnType(object));
            columnAp.setNotNull(object.getBoolean(ISNOTNULL));
            columnAp.setColumnLength(object.getInt(LENGTH));
            columnAp.setColumnPrecision(object.getInt(PRECISION));
            columnAp.setName(new LocaleString(object.getString(NAME)));
            columnAp.setDescription(object.getString(COLUMN_DESCRIPTION));
            columnAp.setColumnName(object.getString(NUMBER));
            columnAp.setKey(object.getString(NUMBER).toLowerCase());
            columns.add(columnAp);
            if (!isCollectColumn) continue;
            columnIdMapping.put(columnAp.getColumnName(), columnAp.getId());
        }
        if (!columnIdMapping.isEmpty()) {
            this.getPageCache().put("columnIdMapping", SerializationUtils.toJsonString(columnIdMapping));
        }
        return columns;
    }

    private List<IndexAp> getIndex() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INDEX_ENTRYENTITY);
        ArrayList<IndexAp> indexAps = new ArrayList<IndexAp>(entryEntity.size());
        String tableId = this.getPageCache().get(TABLE_ID);
        String columnIdMapping = this.getPageCache().get("columnIdMapping");
        LinkedHashMap<String, String> columnIdMappings = new LinkedHashMap(10);
        if (StringUtils.isNotBlank((CharSequence)columnIdMapping)) {
            columnIdMappings = (Map)SerializationUtils.fromJsonString((String)columnIdMapping, Map.class);
        }
        for (DynamicObject object : entryEntity) {
            IndexAp indexAp = new IndexAp();
            indexAp.setId(object.getString(INDEX_ID));
            indexAp.setParentId(tableId);
            indexAp.setIndexName(object.getString(INDEX_NAME));
            indexAp.setTableName((String)this.getModel().getValue(TABLENAME));
            indexAp.setKey(object.getString(INDEX_NUMBER));
            indexAp.setName(new LocaleString(object.getString(INDEX_NAME)));
            indexAp.setCluster(object.getBoolean(INDEX_CLUSTER));
            indexAp.setUnique(object.getBoolean(UNIQUE));
            List<RefColumnAp> refColumnAps = this.getIndexRefColumnAps(object, indexAp.getId(), columnIdMappings);
            if (refColumnAps != null) {
                indexAp.setIndexColumnAps(refColumnAps);
            }
            indexAps.add(indexAp);
        }
        return indexAps;
    }

    private List<RefColumnAp> getIndexRefColumnAps(DynamicObject object, String indexId, Map<String, String> columnIdMappings) {
        String indexRefs;
        String mapping = object.getString(REF_MAPPING);
        Map refMapping = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)mapping)) {
            refMapping = (Map)SerializationUtils.fromJsonString((String)object.getString(REF_MAPPING), Map.class);
        }
        if (StringUtils.isBlank((CharSequence)(indexRefs = object.getString(INDEX_COLUMNS)))) {
            return null;
        }
        if (indexRefs.startsWith(",")) {
            indexRefs = indexRefs.substring(1);
        }
        if (indexRefs.endsWith(",")) {
            indexRefs = indexRefs.substring(0, indexRefs.length() - 1);
        }
        String[] split = indexRefs.trim().split(",");
        ArrayList<RefColumnAp> refColumnApList = new ArrayList<RefColumnAp>(split.length);
        for (String s : split) {
            RefColumnAp refColumnAp = new RefColumnAp();
            String refCoId = columnIdMappings.get(s);
            if (StringUtils.isBlank((CharSequence)refCoId)) continue;
            String id = (String)refMapping.get(refCoId);
            refColumnAp.setRefId(refCoId);
            refColumnAp.setId(id == null ? Uuid16.create().toString() : id);
            refColumnAp.setParentId(indexId);
            refColumnApList.add(refColumnAp);
        }
        return refColumnApList;
    }

    private PrimaryKeyAp getPrimaryKey(String tableName) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PRIMARY_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return null;
        }
        String tableId = this.getPageCache().get(TABLE_ID);
        String columnIdMapping = this.getPageCache().get("columnIdMapping");
        HashMap<String, String> columnIdMappings = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)columnIdMapping)) {
            columnIdMappings = (Map)SerializationUtils.fromJsonString((String)columnIdMapping, Map.class);
        }
        PrimaryKeyAp primaryKeyAp = new PrimaryKeyAp();
        for (DynamicObject object : entryEntity) {
            primaryKeyAp.setId(object.getString(PRIMARYKEY_ID));
            primaryKeyAp.setParentId(tableId);
            primaryKeyAp.setKey(object.getString(PRIMARYKEY_NUMBER));
            primaryKeyAp.setName(new LocaleString(object.getString(PRIMARYKEY_NAME)));
            primaryKeyAp.setPk(object.getString(PRIMARYKEY_NAME));
            primaryKeyAp.setTableName(tableName);
            primaryKeyAp.setCluster(object.getBoolean(PRIMARY_CLUSTER));
            List<RefColumnAp> pkColumnList = this.getPrimaryKeyRefColumnAps(object, primaryKeyAp.getId(), columnIdMappings);
            primaryKeyAp.setPkColumnList(pkColumnList);
        }
        return primaryKeyAp;
    }

    private List<RefColumnAp> getPrimaryKeyRefColumnAps(DynamicObject object, String primaryId, Map<String, String> columnIdMappings) {
        String indexRefs = object.getString(PRIMARYKEY_COLUMNS);
        String mapping = object.getString(PRIMARY_MAPPING);
        Map primaryMapping = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)mapping)) {
            primaryMapping = (Map)SerializationUtils.fromJsonString((String)mapping, Map.class);
        }
        String[] split = indexRefs.trim().split(",");
        ArrayList<RefColumnAp> refColumnApList = new ArrayList<RefColumnAp>(split.length);
        for (String s : split) {
            RefColumnAp refColumnAp = new RefColumnAp();
            String refColId = columnIdMappings.get(s);
            String id = (String)primaryMapping.get(refColId);
            refColumnAp.setRefId(refColId);
            refColumnAp.setId(id == null ? Uuid16.create().toString() : id);
            refColumnAp.setParentId(primaryId);
            refColumnApList.add(refColumnAp);
        }
        return refColumnApList;
    }

    private int getColumnType(DynamicObject object) {
        return Integer.parseInt(object.getString(COLUMN_TYPE));
    }

    private boolean checkColumn() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(COLUMN_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TablePlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        ColumnValidator validator = new ColumnValidator(entryEntity);
        validator.setValidatorField(Arrays.asList(NAME, NUMBER, COLUMN_TYPE, LENGTH, PRECISION));
        ValidatorResult result = ((AbstractValidator)validator).validator();
        if (!result.isSuccess()) {
            this.showMessage(result);
        }
        return result.isSuccess();
    }

    private boolean checkIndex() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INDEX_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return true;
        }
        IndexValidator validator = new IndexValidator(entryEntity);
        validator.setValidatorField(Arrays.asList(INDEX_NAME, INDEX_NUMBER, INDEX_COLUMNS));
        ValidatorResult result = ((AbstractValidator)validator).validator();
        if (!result.isSuccess()) {
            this.showMessage(result);
        }
        return result.isSuccess();
    }

    private boolean checkPrimaryKey() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PRIMARY_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TablePlugin_16", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        IndexValidator validator = new IndexValidator(entryEntity);
        validator.setValidatorField(Arrays.asList(PRIMARYKEY_NAME, PRIMARYKEY_COLUMNS));
        ValidatorResult result = ((AbstractValidator)validator).validator();
        if (!result.isSuccess()) {
            this.showMessage(result);
        }
        return result.isSuccess();
    }

    private void showMessage(ValidatorResult result) {
        StringBuilder builder = new StringBuilder();
        result.getMessage().forEach(message -> builder.append((String)message).append(" "));
        this.getView().showTipNotification(builder.toString());
    }

    private TableAp convertParam() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = (Map)parameter.getCustomParam(PARAM);
        if (params == null) {
            return null;
        }
        Map tableInfo = (Map)params.get("table");
        this.getPageCache().put(TABLE_INFO, SerializationUtils.toJsonString((Object)tableInfo));
        this.getPageCache().put(TABLE_ID, (String)tableInfo.get("Id"));
        this.getPageCache().put(TABLE_NAME, (String)tableInfo.get("TableName"));
        ArrayList<Map> columnAp = new ArrayList<Map>(10);
        ArrayList<Map> indexAp = new ArrayList<Map>(10);
        Map primaryKeyAp = null;
        List param = (List)params.get("fields");
        for (Map map : param) {
            String type = (String)map.get("_Type_");
            if ("ColumnAp".equals(type)) {
                columnAp.add(map);
                continue;
            }
            if ("IndexAp".equals(type)) {
                indexAp.add(map);
                continue;
            }
            if (!"PrimaryKeyAp".equals(type)) continue;
            primaryKeyAp = map;
        }
        HashMap<String, Object> tableParam = new HashMap<String, Object>();
        tableParam.put("_Type_", "TableAp");
        tableParam.put("TableName", tableInfo.get("TableName"));
        tableParam.put("Id", tableInfo.get("Id"));
        tableParam.put("Comment", tableInfo.get("Comment"));
        tableParam.put("Name", tableInfo.get("Name"));
        tableParam.put("Key", tableInfo.get("Key"));
        if (!columnAp.isEmpty()) {
            tableParam.put("Columns", columnAp);
        }
        if (!indexAp.isEmpty()) {
            tableParam.put("Indexs", indexAp);
        }
        if (primaryKeyAp != null) {
            tableParam.put("DMPrimaryKey", primaryKeyAp);
        }
        String modelType = (String)parameter.getCustomParam("modelType");
        MetadataSerializer serializer = new MetadataSerializer(modelType);
        return (TableAp)serializer.deserializeFromMap(tableParam, null);
    }

    private void fillBaseInfo(TableAp tableAp) {
        this.getModel().setValue(TABLE_NUMBER, (Object)tableAp.getKey());
        if (StringUtils.isBlank((CharSequence)tableAp.getTableName())) {
            String id = ISVService.getISVInfo().getId();
            if (KING_DEE.equals(id)) {
                this.getModel().setValue(TABLENAME, (Object)"T_TABLE");
            } else {
                this.getModel().setValue(TABLENAME, (Object)String.format("TK_%s_TABLE", id.toUpperCase()));
            }
        } else {
            this.getModel().setValue(TABLENAME, (Object)tableAp.getTableName());
        }
        this.getModel().setValue(TB_NAME, (Object)tableAp.getName().getLocaleValue_zh_CN());
        this.getModel().setValue(DESCRIPTION, (Object)tableAp.getDescription());
    }

    private void fillColumnEntity(TableAp tableAp) {
        List columnList = tableAp.getColumns();
        if (columnList.isEmpty()) {
            return;
        }
        int[] row = this.getModel().batchCreateNewEntryRow(COLUMN_ENTRYENTITY, columnList.size());
        this.getModel().beginInit();
        for (int i = 0; i < row.length; ++i) {
            ColumnAp columnAp = (ColumnAp)columnList.get(i);
            this.getModel().setValue(ID, (Object)columnAp.getId(), i);
            this.getModel().setValue(NAME, (Object)columnAp.getName().getLocaleValue(), i);
            this.getModel().setValue(NUMBER, (Object)columnAp.getColumnName(), i);
            this.getModel().setValue(COLUMN_TYPE, (Object)columnAp.getColunmType(), i);
            this.getModel().setValue(LENGTH, (Object)columnAp.getColumnLength(), i);
            this.getModel().setValue(PRECISION, (Object)columnAp.getColumnPrecision(), i);
            this.getModel().setValue(ISNOTNULL, (Object)columnAp.isNotNull(), i);
            this.getModel().setValue(DEFAULT, columnAp.getColumnDef(), i);
            this.getModel().setValue(ISPRIMARYKEY, (Object)columnAp.isPrimaryKey(), i);
            this.getModel().setValue(COLUMN_DESCRIPTION, (Object)columnAp.getDescription(), i);
        }
        this.getModel().endInit();
    }

    private void fillIndexEntity(TableAp tableAp) {
        if (tableAp == null || tableAp.getIndexs().isEmpty()) {
            return;
        }
        List indexList = tableAp.getIndexs();
        int[] row = this.getModel().batchCreateNewEntryRow(INDEX_ENTRYENTITY, indexList.size());
        for (int i = 0; i < row.length; ++i) {
            IndexAp indexAp = (IndexAp)indexList.get(i);
            this.getModel().setValue(INDEX_ID, (Object)indexAp.getId(), i);
            this.getModel().setValue(INDEX_NAME, (Object)indexAp.getIndexName(), i);
            this.getModel().setValue(INDEX_NUMBER, (Object)indexAp.getKey(), i);
            this.getModel().setValue(UNIQUE, (Object)indexAp.isUnique(), i);
            this.getModel().setValue(INDEX_CLUSTER, (Object)indexAp.isCluster(), i);
            List<String> indexColumn = this.getIndexColumn(indexAp, tableAp);
            this.getModel().setValue(INDEX_COLUMNS, (Object)indexColumn.get(0), i);
            this.getModel().setValue(REF_MAPPING, (Object)indexColumn.get(1), i);
        }
    }

    private void fillPrimaryKeyEntity(TableAp tableAp) {
        if (tableAp == null || tableAp.getPrimaryKey() == null) {
            return;
        }
        PrimaryKeyAp primaryKey = tableAp.getPrimaryKey();
        this.getModel().batchCreateNewEntryRow(PRIMARY_ENTRYENTITY, 1);
        this.getModel().setValue(PRIMARYKEY_ID, (Object)primaryKey.getId(), 0);
        this.getModel().setValue(PRIMARYKEY_NAME, (Object)primaryKey.getPk(), 0);
        this.getModel().setValue(PRIMARYKEY_NUMBER, (Object)primaryKey.getKey(), 0);
        this.getModel().setValue(PRIMARY_CLUSTER, (Object)primaryKey.isCluster(), 0);
        List<String> primaryMapping = this.getPrimaryColumns(tableAp, primaryKey);
        this.getModel().setValue(PRIMARYKEY_COLUMNS, (Object)primaryMapping.get(0), 0);
        this.getModel().setValue(PRIMARY_MAPPING, (Object)primaryMapping.get(1), 0);
    }

    private List<String> getPrimaryColumns(TableAp tableAp, PrimaryKeyAp primaryKey) {
        List pkColumnList = primaryKey.getPkColumnList();
        StringBuilder builder = new StringBuilder();
        ArrayList<String> primaryMapping = new ArrayList<String>(2);
        HashMap<String, String> primaryMap = new HashMap<String, String>(pkColumnList.size());
        for (int i = 0; i < pkColumnList.size(); ++i) {
            ColumnAp columnAp;
            RefColumnAp refColumnAp = (RefColumnAp)pkColumnList.get(i);
            String refId = refColumnAp.getRefId();
            if (tableAp.getMapItems() == null || (columnAp = (ColumnAp)tableAp.getMapItems().get(refId)) == null) continue;
            builder.append(columnAp.getColumnName());
            primaryMap.put(refId, refColumnAp.getId());
            if (i >= pkColumnList.size() - 1) continue;
            builder.append(",");
        }
        primaryMapping.add(builder.toString());
        primaryMapping.add(SerializationUtils.toJsonString(primaryMap));
        return primaryMapping;
    }

    private List<String> getIndexColumn(IndexAp IndexAp2, TableAp tableAp) {
        List indexColumnApList = IndexAp2.getIndexColumnAps();
        ArrayList<String> refColumnInfo = new ArrayList<String>(2);
        HashMap<String, String> refIdMapping = new HashMap<String, String>(indexColumnApList.size());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indexColumnApList.size(); ++i) {
            RefColumnAp indexColumnAp = (RefColumnAp)indexColumnApList.get(i);
            refIdMapping.put(indexColumnAp.getRefId(), indexColumnAp.getId());
            String indexRefId = indexColumnAp.getRefId();
            BaseControl baseControl = (BaseControl)tableAp.getMapItems().get(indexRefId);
            if (baseControl instanceof ColumnAp) {
                builder.append(((ColumnAp)baseControl).getColumnName());
            }
            if (i >= indexColumnApList.size() - 1) continue;
            builder.append(",");
        }
        refColumnInfo.add(builder.toString());
        refColumnInfo.add(SerializationUtils.toJsonString(refIdMapping));
        return refColumnInfo;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String propertyName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (!Objects.equals(oldValue, newValue = e.getChangeSet()[0].getNewValue())) {
            this.recordModifiedInfo(propertyName);
        }
        if (TABLENAME.equals(propertyName)) {
            String tableName = (String)newValue;
            if (StringUtils.isBlank((CharSequence)tableName) || tableName.equals(oldValue)) {
                return;
            }
            String name = ResManager.loadKDString((String)"\u8868\u540d", (String)"TablePlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            Map<String, Object> res = DataModelUtils.checkNumber(tableName, name);
            if (!res.isEmpty()) {
                String numberAndReturnValue = DataModelUtils.checkNumberAndReturnValue((String)oldValue, false);
                this.setTableInfo(TABLENAME, numberAndReturnValue);
                this.getView().showTipNotification((String)res.get("message"));
                return;
            }
            return;
        }
        if (TABLE_NUMBER.equals(propertyName)) {
            String tableNumber = (String)newValue;
            if (StringUtils.isBlank((CharSequence)tableNumber) || tableNumber.equals(oldValue)) {
                return;
            }
            String name = ResManager.loadKDString((String)"\u6807\u8bc6", (String)"TablePlugin_10", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            Map<String, Object> res = DataModelUtils.checkNumber2(tableNumber, name);
            if (!res.isEmpty()) {
                String numberAndReturnValue = DataModelUtils.checkNumberAndReturnValue((String)oldValue, true);
                this.setTableInfo(TABLE_NUMBER, numberAndReturnValue);
                this.getView().showTipNotification((String)res.get("message"));
            }
            return;
        }
        String tab = this.getPageCache().get(CURRENT_TAB);
        if (BASEINFO.equals(tab) || DDL.equals(tab)) {
            return;
        }
        String currentEntryEntity = tab + ENTRY_ENTITY;
        EntryGrid grid = (EntryGrid)this.getControl(currentEntryEntity);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        if (ISPRIMARYKEY.equals(propertyName)) {
            boolean isSelect = (Boolean)newValue;
            String number = (String)this.getModel().getValue(NUMBER, selectRows[0]);
            this.setPrimaryEntryEntity(number, isSelect);
        } else if (NUMBER.equals(propertyName)) {
            boolean isPrimaryKey;
            String columnNumber = (String)newValue;
            if (StringUtils.isBlank((CharSequence)columnNumber) || columnNumber.equals(oldValue)) {
                return;
            }
            boolean isContains = this.getColumnNumbers(selectRows[0]).stream().anyMatch(columnNumber::equals);
            if (isContains) {
                this.getModel().setValue(NUMBER, null, selectRows[0]);
                boolean isPrimaryKey2 = (Boolean)this.getModel().getValue(ISPRIMARYKEY, selectRows[0]);
                if (isPrimaryKey2) {
                    this.getModel().setValue(ISPRIMARYKEY, (Object)false, selectRows[0]);
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u503c%s\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"TablePlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), columnNumber));
                return;
            }
            String name = ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"TablePlugin_17", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            Map<String, Object> res = this.checkNumber(NUMBER, name, e, selectRows[0]);
            if (res.isEmpty() && (isPrimaryKey = ((Boolean)this.getModel().getValue(ISPRIMARYKEY, selectRows[0])).booleanValue())) {
                this.changePrimaryRefColumn((String)oldValue, columnNumber);
            }
            this.changeIndexRefColumn((String)oldValue, columnNumber);
        } else if (COLUMN_TYPE.equals(propertyName)) {
            this.handleColumnDefault(selectRows[0]);
        } else if (PRECISION.equals(propertyName)) {
            int length;
            if (newValue == null || oldValue != null && ((Integer)newValue).intValue() == ((Integer)oldValue).intValue()) {
                return;
            }
            int precision = (Integer)this.getModel().getValue(PRECISION, selectRows[0]);
            if (precision > (length = ((Integer)this.getModel().getValue(LENGTH, selectRows[0])).intValue())) {
                this.getModel().setValue(PRECISION, oldValue, selectRows[0]);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cbe\u5ea6\u4e0d\u80fd\u5927\u4e8e\u957f\u5ea6\u3002", (String)"TablePlugin_14", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            }
        } else if (INDEX_NAME.equals(propertyName)) {
            String name = ResManager.loadKDString((String)"\u7d22\u5f15\u540d\u79f0", (String)"TablePlugin_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.checkNumber(INDEX_NAME, name, e, selectRows[0]);
        } else if (INDEX_NUMBER.equals(propertyName)) {
            String name = ResManager.loadKDString((String)"\u7d22\u5f15\u7f16\u7801", (String)"TablePlugin_6", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.checkNumber(INDEX_NUMBER, name, e, selectRows[0]);
        } else if (PRIMARYKEY_NAME.equals(propertyName)) {
            String name = ResManager.loadKDString((String)"\u4e3b\u952e\u540d\u79f0", (String)"TablePlugin_7", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.checkNumber(PRIMARYKEY_NAME, name, e, selectRows[0]);
        } else if (PRIMARYKEY_NUMBER.equals(propertyName)) {
            String name = ResManager.loadKDString((String)"\u4e3b\u952e\u7f16\u7801", (String)"TablePlugin_8", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.checkNumber(PRIMARYKEY_NUMBER, name, e, selectRows[0]);
        }
    }

    private Map<String, Object> checkNumber(String number, String name, PropertyChangedArgs e, int rowIndex) {
        Map<String, Object> res = new HashMap<String, Object>(1);
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isBlank((CharSequence)newValue) || newValue.equals(oldValue)) {
            return res;
        }
        res = DataModelUtils.checkNumber(newValue, name);
        if (!res.isEmpty()) {
            String numberAndReturnValue = DataModelUtils.checkNumberAndReturnValue((String)oldValue, false);
            this.getModel().setValue(number, (Object)numberAndReturnValue, rowIndex);
            this.getView().showTipNotification((String)res.get("message"));
        }
        return res;
    }

    private void setTableInfo(String key, String value) {
        this.getModel().beginInit();
        this.getModel().setValue(key, (Object)value);
        this.getModel().endInit();
        this.getView().updateView(key);
    }

    private void handleColumnDefault(int rowIndex) {
        String columnTypeValue = (String)this.getModel().getValue(COLUMN_TYPE, rowIndex);
        if (StringUtils.isBlank((CharSequence)columnTypeValue)) {
            return;
        }
        int value = Integer.parseInt(columnTypeValue);
        DataType dataType = DataType.valueOf((int)value);
        String columnValue = "' '";
        columnValue = dataType == DataType.CHAR ? "'0'" : (dataType == DataType.VARCHAR || dataType == DataType.NVARCHAR || dataType == DataType.NCHAR ? "' '" : (dataType == DataType.SMALLINT || dataType == DataType.BIGINT || dataType == DataType.INT ? "0" : (dataType == DataType.DATETIME ? "getdate()" : (dataType == DataType.DECIMAL ? "0" : ""))));
        this.getModel().setValue(DEFAULT, (Object)columnValue, rowIndex);
    }

    private List<String> getColumnNumbers(int excludeRowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(COLUMN_ENTRYENTITY);
        ArrayList<String> columns = new ArrayList<String>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (i == excludeRowIndex) continue;
            columns.add(((DynamicObject)entryEntity.get(i)).getString(NUMBER));
        }
        return columns;
    }

    private void showDefaultView() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(COLUMN_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        String columnType = (String)this.getModel().getValue(COLUMN_TYPE, selectRows[0]);
        String columnDefault = (String)this.getModel().getValue(DEFAULT, selectRows[0]);
        int precision = (Integer)this.getModel().getValue(PRECISION, selectRows[0]);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_MODELASSET_DEFAULT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(COLUMN_TYPE, (Object)columnType);
        parameter.setCustomParam("columnValue", (Object)columnDefault);
        parameter.setCustomParam(PRECISION, (Object)precision);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DEFAULT_CALL_BACK));
        this.getView().showForm(parameter);
    }

    private void setPrimaryEntryEntity(String columnKey, boolean isSelect) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PRIMARY_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            if (isSelect) {
                this.newEntry(PRIMARY_ENTRYENTITY);
                this.getModel().setValue(PRIMARYKEY_COLUMNS, (Object)columnKey, 0);
            }
        } else {
            String value = (String)this.getModel().getValue(PRIMARYKEY_COLUMNS, 0);
            if (isSelect) {
                value = StringUtils.isBlank((CharSequence)value) ? columnKey : value + String.format("%s%s", ",", columnKey);
                this.getModel().setValue(PRIMARYKEY_COLUMNS, (Object)value, 0);
            } else {
                String[] split = value.split(",");
                List<String> columns = Arrays.asList(split);
                ArrayList<String> columnList = new ArrayList<String>(columns);
                columnList.removeIf(columnKey::equals);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < columnList.size(); ++i) {
                    String col = (String)columnList.get(i);
                    if (!StringUtils.isNotBlank((CharSequence)col)) continue;
                    builder.append(col);
                    if (i >= columnList.size() - 1) continue;
                    builder.append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
                    this.getModel().setValue(PRIMARYKEY_COLUMNS, (Object)builder.toString(), 0);
                } else {
                    this.getModel().deleteEntryRow(PRIMARY_ENTRYENTITY, 0);
                }
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tabKey);
        if (DDL.equals(tabKey)) {
            this.buildTableDDL();
        } else if (INDEX.equals(tabKey)) {
            this.initIndexColumn();
        }
    }

    private void buildTableDDL() {
        try {
            String indexSQL;
            String pkSql;
            TableAp tableAp = this.buildTableInfo();
            Table table = (Table)tableAp.createDMO();
            ScriptGenerator scriptGenerator = ScriptGenerator.createScriptGenerator();
            StringBuilder sql = new StringBuilder(scriptGenerator.createTableSql(table));
            if (tableAp.getPrimaryKey() != null && StringUtils.isNotBlank((CharSequence)(pkSql = scriptGenerator.createConstraintSql(table)))) {
                sql.append(pkSql).append("\n");
            }
            if (!tableAp.getIndexs().isEmpty() && StringUtils.isNotBlank((CharSequence)(indexSQL = scriptGenerator.createIndexesSql(table)))) {
                sql.append("\n").append(indexSQL);
            }
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(CODE_EDIT_AP);
            codeEdit.setText(sql.toString());
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void updateModelModifiedStatus(TableAp tableAp) {
        String modifiedStr = this.getParentPageCache().get("MODIFIEDPROP");
        if (modifiedStr == null) {
            return;
        }
        Map modifiedPropMap = (Map)SerializationUtils.fromJsonString((String)modifiedStr, Map.class);
        if (modifiedPropMap.isEmpty()) {
            return;
        }
        List propList = (List)modifiedPropMap.get(tableAp.getTableName());
        if (propList == null || propList.isEmpty()) {
            return;
        }
        for (ColumnAp col : tableAp.getColumns()) {
            if (!propList.contains(col.getColumnName())) continue;
            col.setModified(true);
        }
        for (IndexAp indexAp : tableAp.getIndexs()) {
            if (!propList.contains(indexAp.getIndexName())) continue;
            indexAp.setModified(true);
        }
        PrimaryKeyAp pkAp = tableAp.getPrimaryKey();
        if (pkAp != null && propList.contains(pkAp.getPk())) {
            pkAp.setModified(true);
        }
    }

    private void recordModifiedInfo(String propertyName) {
        String propName = "";
        switch (propertyName) {
            case "number": 
            case "columntype": 
            case "length": 
            case "precision": 
            case "isnotnull": 
            case "default": 
            case "isprimarykey": {
                propName = (String)this.getModel().getValue(NUMBER);
                if (!StringUtils.isBlank((CharSequence)propName)) break;
                return;
            }
            case "indexname": 
            case "unique": 
            case "indexcluster": 
            case "index_columns": {
                propName = (String)this.getModel().getValue(INDEX_NAME);
                if (!StringUtils.isBlank((CharSequence)propName)) break;
                return;
            }
            case "primarykeyname": 
            case "primarycluster": 
            case "primarykeycolumns": {
                propName = (String)this.getModel().getValue(PRIMARYKEY_NAME);
                if (!StringUtils.isBlank((CharSequence)propName)) break;
                return;
            }
        }
        String modifiedStr = this.getParentPageCache().get("MODIFIEDPROP");
        HashMap<String, ArrayList<String>> modifiedPropMap = modifiedStr != null ? (HashMap<String, ArrayList<String>>)SerializationUtils.fromJsonString((String)modifiedStr, Map.class) : new HashMap<String, ArrayList<String>>(2);
        String tableName = (String)this.getModel().getValue(TABLENAME);
        ArrayList<String> propList = (ArrayList<String>)modifiedPropMap.get(tableName);
        if (propList == null) {
            propList = new ArrayList<String>(5);
            modifiedPropMap.put(tableName, propList);
        }
        propList.add(propName);
        this.getParentPageCache().put("MODIFIEDPROP", SerializationUtils.toJsonString(modifiedPropMap));
    }

    private IPageCache getParentPageCache() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        return SessionManager.getCurrent().getPageCache(parentPageId);
    }
}

