/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueTextItem;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;

public class TablesSelectPlugin
extends AbstractFormPlugin
implements F7SelectedListRemoveListener,
RowClickEventListener {
    private static final String OK = "btnok";
    private static final String CANCEL = "btncancel";
    private static final String TABLENAME = "tablename";
    private static final String ENTRYENTITY = "entryentity";
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String DBROUTE = "dbRoute";
    private static final String KEY_VALUE = "value";
    private static final String KEY_TEXT = "text";
    private static final String SELECT_TABLES = "selectTables";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OK});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7SELECTEDLISTAP);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dbRoute = (String)this.getView().getFormShowParameter().getCustomParam(DBROUTE);
        List tableList = DB.getTables((DBRoute)new DBRoute(dbRoute));
        if (tableList != null) {
            this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            entryEntity.clear();
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(ENTRYENTITY);
            for (String tableName : tableList) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(TABLENAME, (Object)tableName);
                entryEntity.add((Object)row);
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String selectTableStr = (String)this.getView().getFormShowParameter().getCustomParam(SELECT_TABLES);
        if (StringUtil.isNotBlank((String)selectTableStr)) {
            List selectTables = SerializationUtils.fromJsonStringToList((String)selectTableStr, String.class);
            ArrayList<Integer> rows = new ArrayList<Integer>(10);
            for (String selectTable : selectTables) {
                int rowIndex = this.findRow(selectTable);
                rows.add(rowIndex);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = rows.stream().mapToInt(Integer::intValue).toArray();
            entryGrid.selectRows(selectRows, 0);
            this.addItems(selectTables);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btnok": {
                String selectedTableStr = this.getPageCache().get(SELECT_TABLES);
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put(SELECT_TABLES, selectedTableStr);
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null) {
            ArrayList<String> currSelectTables = new ArrayList<String>(10);
            for (int i = 0; i < selectRows.length; ++i) {
                String tableName = (String)this.getModel().getValue(TABLENAME, selectRows[i]);
                currSelectTables.add(tableName);
            }
            this.addItems(currSelectTables);
            this.getPageCache().put(SELECT_TABLES, SerializationUtils.toJsonString(currSelectTables));
        } else {
            List<String> selectedTables = this.getSelectedTables();
            F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
            for (String value : selectedTables) {
                f7SelectedList.removeItem((Object)value);
            }
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent arg0) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (arg0.getParam() != null) {
            String tableName = (String)arg0.getParam();
            int[] selectRows = entryGrid.getSelectRows();
            List<String> selectedTables = this.getSelectedTables();
            int rowIndex = 0;
            for (DynamicObject row2 : entryEntity) {
                String table = (String)row2.get(TABLENAME);
                if (table.equalsIgnoreCase(tableName)) {
                    selectedTables.remove(table);
                    break;
                }
                ++rowIndex;
            }
            if (selectRows != null) {
                int finalRowIndex = rowIndex;
                ArrayList list = new ArrayList(10);
                Arrays.stream(selectRows).forEach(row -> {
                    if (row != finalRowIndex) {
                        list.add(row);
                    }
                });
                int[] newRows = list.stream().mapToInt(Integer::intValue).toArray();
                entryGrid.selectRows(newRows, 0);
            }
            this.getPageCache().put(SELECT_TABLES, SerializationUtils.toJsonString(selectedTables));
        } else {
            entryGrid.selectRows(new int[0], 0);
            this.getPageCache().put(SELECT_TABLES, SerializationUtils.toJsonString(new ArrayList(0)));
        }
    }

    private int findRow(String selectTable) {
        DynamicObject row;
        String table;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        int rowIndex = 0;
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext() && !(table = (String)(row = (DynamicObject)iterator.next()).get(TABLENAME)).equalsIgnoreCase(selectTable)) {
            ++rowIndex;
        }
        return rowIndex;
    }

    private List<String> getSelectedTables() {
        String selectedTableStr = this.getPageCache().get(SELECT_TABLES);
        List<String> selectedTables = new ArrayList<String>(1);
        if (StringUtil.isNotBlank((String)selectedTableStr)) {
            selectedTables = SerializationUtils.fromJsonStringToList((String)selectedTableStr, String.class);
        }
        return selectedTables;
    }

    private void addItems(List<String> selectTables) {
        ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>(selectTables.size());
        for (String table : selectTables) {
            listValue.add(new ValueTextItem(table, table));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        f7SelectedList.addItems(listValue);
    }
}

