/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.compare;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.DMMetaCategory;
import kd.bos.datamodel.metadata.dao.PDMEntityMetaBuilder;
import kd.bos.datamodel.metadata.pdm.IPDMDesignMetaReader;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaVisitFactory;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.designer.plugin.PDMModelCompare;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class DataModelBranchComparePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(DataModelBranchComparePlugin.class);
    private static final String PATH = "path";
    private static final String BRANCH = "branch";
    private static final String BTN_OK = "btnok";
    private static final String GITROOTPATH = "gitrootpath";
    private static final String PERSONALGITREPOSITORY = "personalgitrepository";
    private static final String SQL_CALL_BACK = "SQL_CALL_BACK";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String personalRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        String path = (String)parameter.getCustomParam(GITROOTPATH);
        this.initBranch(personalRepository);
        this.setDataModelPath(path);
    }

    private void initBranch(String personalRepository) {
        String path = personalRepository + File.separator + ".git";
        File file = new File(path);
        try (Git git = Git.open((File)file);){
            List refList = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(refList.size());
            for (Ref ref : refList) {
                String name = ref.getName();
                if (name.contains("cherry-pick")) continue;
                if (name.contains("refs/heads/")) {
                    name = name.replace("refs/heads/", "");
                }
                if (name.contains("refs/")) {
                    name = name.replace("refs/", "");
                }
                ComboItem item = new ComboItem(new LocaleString(name), name);
                items.add(item);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(BRANCH);
            comboEdit.setComboItems(items);
        }
        catch (IOException | GitAPIException e) {
            log.error(e);
        }
    }

    private void setDataModelPath(String path) {
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizAppId");
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
        String appNumber = appInfo.getNumber();
        String[] splitPath = path.split("/");
        StringBuilder builder = new StringBuilder();
        for (String p : splitPath) {
            if (NumberUtils.isParsable((String)p)) {
                builder.append(p).append("/");
                break;
            }
            builder.append(p).append("/");
        }
        builder.append("pdm").append("/").append(appNumber);
        this.getModel().setValue(PATH, (Object)builder.toString());
    }

    public void click(EventObject evt) {
        String branch = (String)this.getModel().getValue(BRANCH);
        if (StringUtils.isBlank((CharSequence)branch)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u652f\u3002", (String)"DataModelBranchComparePlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String id = (String)parameter.getCustomParam("id");
        String path = (String)this.getModel().getValue(PATH);
        String personalRepository = (String)parameter.getCustomParam(PERSONALGITREPOSITORY);
        IPDMDesignMetaReader reader = PDMDesignMetaVisitFactory.getPDMDesignMetaReader();
        PDMEntityMetadata designMeta = (PDMEntityMetadata)reader.loadBaseMeta(id, DMMetaCategory.MDataModel);
        String number = designMeta.getNumber();
        String bizAppId = designMeta.getBizappId();
        String name = number + ".kpdm";
        branch = branch.contains("remotes") ? "refs/" + branch : "refs/heads/" + branch;
        String pdmPath = path + "/" + name;
        String lastCommitFile = GitOperationUtils.getRemoteLastCommitFile((String)personalRepository, (String)pdmPath, (String)branch);
        if (StringUtils.isBlank((CharSequence)lastCommitFile)) {
            String tips = ResManager.loadKDString((String)"\u5728Git\u4ed3\u5e93\u6ca1\u6709\u627e\u5230\u8be5\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5728\u4ed3\u5e93\u662f\u5426\u5b58\u5728\u6216\u8005\u6a21\u578b\u76ee\u5f55\u662f\u5426\u6b63\u786e\u3002", (String)"DataModelBranchComparePlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        PDMEntityMetadata branchEntityMeta = PDMEntityMetaBuilder.buildPDMEntityMetadata((String)lastCommitFile);
        if (branchEntityMeta != null) {
            PDMModelCompare compare = new PDMModelCompare();
            Map<String, Map<String, String>> sqlParameter = compare.comparePDModel(branchEntityMeta, designMeta);
            if (sqlParameter.isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u4e0eGit\u4ed3\u5e93\u6a21\u578b\u65e0\u5dee\u5f02\u3002", (String)"DataModelBranchComparePlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                return;
            }
            this.buildSql(sqlParameter, id, number, bizAppId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && SQL_CALL_BACK.equals(e.getActionId())) {
            this.getView().returnDataToParent(e.getReturnData());
            this.getView().close();
        }
    }

    private void buildSql(Map<String, Map<String, String>> sqlParameter, String id, String number, String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_dm_submit");
        parameter.setCaption(ResManager.loadKDString((String)"\u751f\u6210\u811a\u672c", (String)"DataModelBranchComparePlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("sqlParameter", sqlParameter);
        parameter.setCustomParam("number", (Object)number);
        parameter.setCustomParam("openType", (Object)"modelList");
        parameter.setCustomParam("modelId", (Object)id);
        parameter.setCustomParam("number", (Object)number);
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SQL_CALL_BACK));
        this.getView().showForm(parameter);
    }
}

