/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.Default;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.PDModel;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.designer.plugin.compare.DataModelCompare;
import kd.bos.designer.plugin.compare.DataModelProperty;
import kd.bos.designer.plugin.compare.PDModelUtil;
import kd.bos.entity.tree.TreeNode;

public class DataModelCompareImpl
implements DataModelCompare {
    private static final String COLUMNS = "_columns";
    private static final String INDEXS = "_indexs";
    private static final String PRIMARY = "_primary";
    private static final String SEPARATOR = "$$";
    private static final String SEPARATOR2 = "\\$\\$";
    private static final String COLUMN = "column";
    private static final String INDEX = "index";
    private static final String PRIMARY_KEY = "primary";
    private static final String TABLE = "table";
    private static final String NODE_COLOR_ADD = "#1BA854";
    private static final String NODE_COLOR_REMOVE = "#FB2323";
    private static final String NODE_COLOR_EDIT = "#FF991C";
    private static final String PROPERTY_KEY = "propertykey";
    private static final String BASE_VALUE = "basevalue";
    private static final String CURR_VALUE = "currvalue";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";

    @Override
    public TreeNode compare(PDModel currentDataModel, PDModel baseDataModel) {
        PDModelUtil.setNumber2UpCase(baseDataModel);
        PDModelUtil.setNumber2UpCase(currentDataModel);
        TreeNode rootNode = new TreeNode("", currentDataModel.getNumber(), currentDataModel.getName());
        HashMap<String, Table> oldTabMap = new HashMap<String, Table>(20);
        for (Table oldTable : baseDataModel.getTables()) {
            oldTabMap.put(oldTable.getNumber(), oldTable);
        }
        for (Table table : currentDataModel.getTables()) {
            TreeNode treeNode;
            String tableNumber = table.getNumber();
            Table oldTable = (Table)oldTabMap.get(tableNumber);
            if (oldTable != null) {
                oldTabMap.remove(tableNumber);
                treeNode = this.compareTable(table, oldTable, currentDataModel);
            } else {
                treeNode = this.addTable(table, currentDataModel);
            }
            if (treeNode.getChildren().isEmpty()) continue;
            rootNode.addChild(treeNode);
        }
        for (Table table : oldTabMap.values()) {
            this.buildNode(null, rootNode, (PDMObject)table, NODE_COLOR_REMOVE, null);
        }
        return rootNode;
    }

    @Override
    public void merge(TreeNode treeNode, PDModel currModel, PDModel newModel) {
        LinkedHashMap<String, Table> currTableMap = new LinkedHashMap<String, Table>(currModel.getTables().size());
        for (Table table : currModel.getTables()) {
            currTableMap.put(table.getNumber(), table);
        }
        LinkedHashMap<String, Table> newTableMap = new LinkedHashMap<String, Table>(newModel.getTables().size());
        for (Table table : newModel.getTables()) {
            newTableMap.put(table.getNumber(), table);
        }
        for (TreeNode node : treeNode.getChildren()) {
            if (!TABLE.equals(node.getType())) continue;
            String tableNumber = node.getId();
            if (NODE_COLOR_ADD.equals(node.getColor())) {
                Table table = new Table(tableNumber);
                this.mergeNewTable(node, (Table)currTableMap.get(tableNumber), table);
                newModel.getTables().add(table);
                continue;
            }
            if (!NODE_COLOR_EDIT.equals(node.getColor())) continue;
            Table currTable = (Table)currTableMap.get(tableNumber);
            Table newTable = (Table)newTableMap.get(tableNumber);
            this.modifyTable(node, currTable, newTable);
        }
    }

    private void modifyTable(TreeNode treeNode, Table currTable, Table newTable) {
        if (treeNode.getChildren() == null) {
            return;
        }
        for (TreeNode node : treeNode.getChildren()) {
            String id = node.getId();
            if (id.endsWith(COLUMNS)) {
                this.modifyColumn(node, currTable, newTable);
                continue;
            }
            if (id.endsWith(INDEXS)) {
                this.modifyIndex(node, currTable, newTable);
                continue;
            }
            if (!id.endsWith(PRIMARY)) continue;
            this.modifyPrimary(node, currTable, newTable);
        }
    }

    private void modifyColumn(TreeNode treeNode, Table currTable, Table newTable) {
        HashMap<String, Column> columnMap = new HashMap<String, Column>(currTable.getColumns().size());
        for (Column column2 : currTable.getColumns()) {
            columnMap.put(column2.getNumber(), column2);
        }
        for (TreeNode node : treeNode.getChildren()) {
            String[] ids = node.getId().split(SEPARATOR2);
            if (NODE_COLOR_ADD.equals(node.getColor())) {
                newTable.addColumn((Column)columnMap.get(ids[1]));
                continue;
            }
            if (NODE_COLOR_EDIT.equals(node.getColor())) {
                newTable.getColumns().removeIf(column -> column.getNumber().equals(ids[1]));
                newTable.addColumn((Column)columnMap.get(ids[1]));
                continue;
            }
            if (!NODE_COLOR_REMOVE.equals(node.getColor())) continue;
            newTable.getColumns().removeIf(column -> column.getNumber().equals(ids[1]));
        }
    }

    private void modifyIndex(TreeNode treeNode, Table currTable, Table newTable) {
        HashMap<String, Index> indexMap = new HashMap<String, Index>(currTable.getIndexes().size());
        for (Index index2 : currTable.getIndexes()) {
            indexMap.put(index2.getNumber(), index2);
        }
        for (TreeNode node : treeNode.getChildren()) {
            String[] ids = node.getId().split(SEPARATOR2);
            if (NODE_COLOR_ADD.equals(node.getColor())) {
                newTable.addIndex((Index)indexMap.get(ids[1]));
                continue;
            }
            if (NODE_COLOR_EDIT.equals(node.getColor())) {
                newTable.getIndexes().removeIf(index -> index.getNumber().equals(ids[1]));
                newTable.addIndex((Index)indexMap.get(ids[1]));
                continue;
            }
            if (!NODE_COLOR_REMOVE.equals(node.getColor())) continue;
            newTable.getIndexes().removeIf(index -> index.getNumber().equals(ids[1]));
        }
    }

    private void modifyPrimary(TreeNode treeNode, Table currTable, Table newTable) {
        for (TreeNode node : treeNode.getChildren()) {
            String[] ids = node.getId().split(SEPARATOR2);
            if (NODE_COLOR_ADD.equals(node.getColor()) || NODE_COLOR_EDIT.equals(node.getColor())) {
                newTable.setPrimaryKey(currTable.getPrimaryKey());
                continue;
            }
            if (!NODE_COLOR_REMOVE.equals(node.getColor())) continue;
        }
    }

    private void mergeNewTable(TreeNode treeNode, Table currTable, Table newTable) {
        for (TreeNode node : treeNode.getChildren()) {
            String id = node.getId();
            if (id.endsWith(COLUMNS)) {
                this.mergeNewColumn(node, currTable, newTable);
                continue;
            }
            if (id.endsWith(INDEXS)) {
                this.mergeNewIndex(node, currTable, newTable);
                continue;
            }
            if (!id.endsWith(PRIMARY)) continue;
            newTable.setPrimaryKey(currTable.getPrimaryKey());
        }
    }

    private void mergeNewColumn(TreeNode treeNode, Table currTable, Table newTable) {
        HashMap<String, Column> columnMap = new HashMap<String, Column>(currTable.getColumns().size());
        for (Column column : currTable.getColumns()) {
            columnMap.put(column.getNumber(), column);
        }
        for (TreeNode node : treeNode.getChildren()) {
            String id = node.getId();
            String[] ids = id.split(SEPARATOR2);
            Column column = (Column)columnMap.get(ids[1]);
            if (column == null) continue;
            newTable.addColumn(column);
        }
    }

    private void mergeNewIndex(TreeNode treeNode, Table currTable, Table newTable) {
        HashMap<String, Index> indexMap = new HashMap<String, Index>(currTable.getIndexes().size());
        for (Index index : currTable.getIndexes()) {
            indexMap.put(index.getNumber(), index);
        }
        for (TreeNode node : treeNode.getChildren()) {
            String id = node.getId();
            String[] ids = id.split(SEPARATOR2);
            Index idx = (Index)indexMap.get(ids[1]);
            if (idx == null) continue;
            newTable.addIndex(idx);
        }
    }

    private TreeNode compareTable(Table currentTable, Table baseTable, PDModel pdModel) {
        Map<String, Column> baseColumnMap = this.toColumnDictMap(baseTable.getColumns());
        TreeNode tableNode = new TreeNode(pdModel.getNumber(), currentTable.getNumber(), currentTable.getNumber());
        tableNode.setColor(NODE_COLOR_EDIT);
        tableNode.setType(TABLE);
        String columnsNode = ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DataModelCompareImpl_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        TreeNode columns = new TreeNode(currentTable.getNumber(), currentTable.getNumber() + COLUMNS, columnsNode);
        for (Column column : currentTable.getColumns()) {
            List<Map<String, Object>> data;
            Column col = baseColumnMap.get(column.getNumber());
            if (col == null) {
                data = this.addColumn(column);
                this.buildNode((PDMObject)currentTable, columns, (PDMObject)column, NODE_COLOR_ADD, data);
                continue;
            }
            baseColumnMap.remove(column.getNumber());
            data = this.compareColumn(column, col);
            if (data == null || data.isEmpty()) continue;
            this.buildNode((PDMObject)currentTable, columns, (PDMObject)column, NODE_COLOR_EDIT, data);
        }
        for (Column column : baseColumnMap.values()) {
            this.buildNode((PDMObject)currentTable, columns, (PDMObject)column, NODE_COLOR_REMOVE, null);
        }
        if (columns.getChildren() != null && !columns.getChildren().isEmpty()) {
            tableNode.addChild(columns);
        }
        this.compareIndex(currentTable, baseTable, tableNode);
        this.comparePrimary(currentTable, baseTable, tableNode);
        return tableNode;
    }

    private void compareIndex(Table currentTable, Table baseTable, TreeNode tableNode) {
        String indexNode = ResManager.loadKDString((String)"\u7d22\u5f15", (String)"DataModelCompareImpl_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        TreeNode indexs = new TreeNode(currentTable.getNumber(), currentTable.getNumber() + INDEXS, indexNode);
        Map<String, Index> baseIndexMap = this.toIndexDictMap(baseTable.getIndexes());
        for (Index idx : currentTable.getIndexes()) {
            List<Map<String, Object>> data;
            Index index = baseIndexMap.get(idx.getNumber());
            if (index == null) {
                data = this.addIndex(idx);
                this.buildNode((PDMObject)currentTable, indexs, (PDMObject)idx, NODE_COLOR_ADD, data);
                continue;
            }
            baseIndexMap.remove(idx.getNumber());
            data = this.compareIndex(idx, index);
            if (data == null || data.isEmpty()) continue;
            this.buildNode((PDMObject)currentTable, indexs, (PDMObject)idx, NODE_COLOR_EDIT, data);
        }
        for (Index index : baseIndexMap.values()) {
            this.buildNode((PDMObject)currentTable, indexs, (PDMObject)index, NODE_COLOR_REMOVE, null);
        }
        if (indexs.getChildren() != null && !indexs.getChildren().isEmpty()) {
            tableNode.addChild(indexs);
        }
    }

    private List<Map<String, Object>> compareIndex(Index currIndex, Index baseIndex) {
        LinkedHashMap<String, String> data;
        if (currIndex.equals((Object)baseIndex)) {
            return null;
        }
        ArrayList<Map<String, Object>> diffNodes = new ArrayList<Map<String, Object>>();
        if (currIndex.isCluster() != baseIndex.isCluster()) {
            data = new LinkedHashMap<String, String>();
            data.put(PROPERTY_KEY, DataModelProperty.isCluster.getValue());
            data.put(BASE_VALUE, String.valueOf(baseIndex.isCluster()));
            data.put(CURR_VALUE, String.valueOf(currIndex.isCluster()));
            diffNodes.add(data);
        }
        if (currIndex.isUnique() != baseIndex.isUnique()) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.isUnique.getValue());
            data.put(BASE_VALUE, String.valueOf(baseIndex.isUnique()));
            data.put(CURR_VALUE, String.valueOf(currIndex.isUnique()));
            diffNodes.add(data);
        }
        if (!currIndex.getColNumbers().equals(baseIndex.getColNumbers())) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.indexColumnAps.getValue());
            data.put(BASE_VALUE, StringUtils.join((Object[])baseIndex.getColNumbers().toArray(), (String)","));
            data.put(CURR_VALUE, StringUtils.join((Object[])currIndex.getColNumbers().toArray(), (String)","));
            diffNodes.add(data);
        }
        return diffNodes;
    }

    private void comparePrimary(Table currTable, Table baseTable, TreeNode tableNode) {
        PrimaryKey currPrimary = currTable.getPrimaryKey();
        PrimaryKey basePrimary = baseTable.getPrimaryKey();
        if (currPrimary == null && basePrimary == null) {
            return;
        }
        String primaryNode = ResManager.loadKDString((String)"\u4e3b\u952e", (String)"DataModelCompareImpl_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        TreeNode primarys = new TreeNode(currTable.getNumber(), currTable.getNumber() + PRIMARY, primaryNode);
        if (currPrimary == null) {
            this.buildNode((PDMObject)currTable, primarys, (PDMObject)basePrimary, NODE_COLOR_REMOVE, null);
            if (primarys.getChildren() != null && !primarys.getChildren().isEmpty()) {
                tableNode.addChild(primarys);
            }
            return;
        }
        if (basePrimary == null) {
            List<Map<String, Object>> data = this.addPrimary(currPrimary);
            this.buildNode((PDMObject)currTable, primarys, (PDMObject)currPrimary, NODE_COLOR_ADD, data);
            if (!primarys.getChildren().isEmpty()) {
                tableNode.addChild(primarys);
            }
            return;
        }
        if (!currPrimary.equals((Object)basePrimary)) {
            List<Map<String, Object>> data = this.comparePrimary(currPrimary, basePrimary);
            if (!data.isEmpty()) {
                this.buildNode((PDMObject)currTable, primarys, (PDMObject)currPrimary, NODE_COLOR_EDIT, data);
            }
            if (primarys.getChildren() != null && !primarys.getChildren().isEmpty()) {
                tableNode.addChild(primarys);
            }
        }
    }

    private List<Map<String, Object>> comparePrimary(PrimaryKey currPrimary, PrimaryKey basePrimary) {
        LinkedHashMap<String, String> data;
        ArrayList<Map<String, Object>> diffNodes = new ArrayList<Map<String, Object>>();
        if (currPrimary.isCluster() != basePrimary.isCluster()) {
            data = new LinkedHashMap<String, String>();
            data.put(PROPERTY_KEY, DataModelProperty.isCluster.getValue());
            data.put(BASE_VALUE, String.valueOf(basePrimary.isCluster()));
            data.put(CURR_VALUE, String.valueOf(currPrimary.isCluster()));
            diffNodes.add(data);
        }
        if (!currPrimary.getNumber().equalsIgnoreCase(basePrimary.getNumber())) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.pk.getValue());
            data.put(BASE_VALUE, String.valueOf(basePrimary.getNumber()));
            data.put(CURR_VALUE, String.valueOf(currPrimary.getNumber()));
            diffNodes.add(data);
        }
        if (!currPrimary.getColNumbers().equals(basePrimary.getColNumbers())) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.pkColumnList.getValue());
            data.put(BASE_VALUE, StringUtils.join((Object[])basePrimary.getColNumbers().toArray(), (String)","));
            data.put(CURR_VALUE, StringUtils.join((Object[])currPrimary.getColNumbers().toArray(), (String)","));
            diffNodes.add(data);
        }
        return diffNodes;
    }

    private List<Map<String, Object>> addPrimary(PrimaryKey primaryKey) {
        ArrayList<Map<String, Object>> diffNodes = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put(PROPERTY_KEY, DataModelProperty.isCluster.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, String.valueOf(primaryKey.isCluster()));
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.pk.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, primaryKey.getNumber());
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.pkColumnList.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, StringUtils.join((Object[])primaryKey.getColNumbers().toArray(), (String)","));
        diffNodes.add(data);
        return diffNodes;
    }

    private List<Map<String, Object>> addIndex(Index index) {
        ArrayList<Map<String, Object>> diffNodes = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put(PROPERTY_KEY, DataModelProperty.isUnique.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, String.valueOf(index.isUnique()));
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.isCluster.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, String.valueOf(index.isCluster()));
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.indexColumnAps.getValue());
        data.put(BASE_VALUE, "");
        String colNumber = StringUtils.join((Object[])index.getColNumbers().toArray(), (String)",");
        data.put(CURR_VALUE, colNumber);
        diffNodes.add(data);
        return diffNodes;
    }

    private Map<String, Index> toIndexDictMap(List<Index> list) {
        HashMap<String, Index> indexMap = new HashMap<String, Index>(list.size());
        for (Index index : list) {
            indexMap.put(index.getNumber(), index);
        }
        return indexMap;
    }

    private List<Map<String, Object>> addColumn(Column currCol) {
        ArrayList<Map<String, Object>> diffNodes = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put(PROPERTY_KEY, DataModelProperty.columnType.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, currCol.getDataType().name());
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.columnLength.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, String.valueOf(currCol.getLength()));
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.columnPrecision.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, String.valueOf(currCol.getPrecision()));
        diffNodes.add(data);
        data = new LinkedHashMap();
        data.put(PROPERTY_KEY, DataModelProperty.isNotNull.getValue());
        data.put(BASE_VALUE, "");
        data.put(CURR_VALUE, String.valueOf(currCol.isAllowNull()));
        diffNodes.add(data);
        Default colDefault = currCol.getColDefault();
        if (colDefault != null) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.columnDef.getValue());
            data.put(BASE_VALUE, "");
            data.put(CURR_VALUE, String.valueOf(colDefault.getValue()));
            diffNodes.add(data);
        }
        return diffNodes;
    }

    private List<Map<String, Object>> compareColumn(Column currCol, Column baseCol) {
        LinkedHashMap<String, String> data;
        if (currCol.equals((Object)baseCol)) {
            return null;
        }
        ArrayList<Map<String, Object>> diffNodes = new ArrayList<Map<String, Object>>();
        if (currCol.getDataType() != baseCol.getDataType()) {
            data = new LinkedHashMap<String, String>();
            data.put(PROPERTY_KEY, DataModelProperty.columnType.getValue());
            data.put(BASE_VALUE, baseCol.getDataType().name());
            data.put(CURR_VALUE, currCol.getDataType().name());
            diffNodes.add(data);
        }
        if (currCol.getLength() != baseCol.getLength()) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.columnLength.getValue());
            data.put(BASE_VALUE, String.valueOf(baseCol.getLength()));
            data.put(CURR_VALUE, String.valueOf(currCol.getLength()));
            diffNodes.add(data);
        }
        if (currCol.getPrecision() != baseCol.getPrecision()) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.columnPrecision.getValue());
            data.put(BASE_VALUE, String.valueOf(baseCol.getPrecision()));
            data.put(CURR_VALUE, String.valueOf(currCol.getPrecision()));
            diffNodes.add(data);
        }
        if (currCol.isAllowNull() != baseCol.isAllowNull()) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.isNotNull.getValue());
            data.put(BASE_VALUE, String.valueOf(baseCol.isAllowNull()));
            data.put(CURR_VALUE, String.valueOf(currCol.isAllowNull()));
            diffNodes.add(data);
        }
        Default currDefault = currCol.getColDefault();
        Default baseDefault = baseCol.getColDefault();
        if (currDefault != null && baseDefault != null && !currDefault.equals((Object)baseDefault)) {
            data = new LinkedHashMap();
            data.put(PROPERTY_KEY, DataModelProperty.columnType.getValue());
            data.put(BASE_VALUE, baseCol.getColDefault().getValue());
            data.put(CURR_VALUE, currCol.getColDefault().getValue());
            diffNodes.add(data);
        }
        return diffNodes;
    }

    private Map<String, Column> toColumnDictMap(List<Column> list) {
        HashMap<String, Column> dict = new HashMap<String, Column>(list.size());
        for (Column column : list) {
            dict.put(column.getNumber(), column);
        }
        return dict;
    }

    private TreeNode addTable(Table table, PDModel pdModel) {
        PrimaryKey primaryKey;
        TreeNode treeNode = new TreeNode(pdModel.getNumber(), table.getNumber(), table.getNumber());
        treeNode.setColor(NODE_COLOR_ADD);
        treeNode.setType(TABLE);
        String columnsNode = ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DataModelCompareImpl_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        TreeNode columns = new TreeNode(table.getNumber(), table.getNumber() + COLUMNS, columnsNode);
        this.buildColumnNode(table, columns, table.getColumns());
        if (columns.getChildren() != null && !columns.getChildren().isEmpty()) {
            treeNode.addChild(columns);
        }
        String indexNode = ResManager.loadKDString((String)"\u7d22\u5f15", (String)"DataModelCompareImpl_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
        TreeNode indexs = new TreeNode(table.getNumber(), table.getNumber() + INDEXS, indexNode);
        this.buildIndexNode(table, indexs, table.getIndexes());
        if (indexs.getChildren() != null && !indexs.getChildren().isEmpty()) {
            treeNode.addChild(indexs);
        }
        if ((primaryKey = table.getPrimaryKey()) != null) {
            String primaryNode = ResManager.loadKDString((String)"\u4e3b\u952e", (String)"DataModelCompareImpl_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            TreeNode primary = new TreeNode(table.getNumber(), table.getNumber() + PRIMARY, primaryNode);
            this.buildPrimaryNode(table, primary, primaryKey);
            if (primary.getChildren() != null && !primary.getChildren().isEmpty()) {
                treeNode.addChild(primary);
            }
        }
        return treeNode;
    }

    private void buildColumnNode(Table table, TreeNode parentNode, List<Column> columns) {
        for (Column column : columns) {
            List<Map<String, Object>> data = this.addColumn(column);
            this.buildNode((PDMObject)table, parentNode, (PDMObject)column, NODE_COLOR_ADD, data);
        }
    }

    private void buildNode(PDMObject table, TreeNode parentNode, PDMObject object, String color, List<Map<String, Object>> data) {
        String type = this.getType(object);
        String id = table == null ? object.getNumber() : table.getNumber() + SEPARATOR + object.getNumber() + SEPARATOR + type;
        TreeNode columnNode = new TreeNode(parentNode.getId(), id, object.getNumber());
        columnNode.setColor(color);
        columnNode.setType(type);
        if (data != null) {
            columnNode.setData(data);
        }
        parentNode.addChild(columnNode);
    }

    private String getType(PDMObject object) {
        if (object instanceof Column) {
            return COLUMN;
        }
        if (object instanceof Index) {
            return INDEX;
        }
        if (object instanceof PrimaryKey) {
            return PRIMARY_KEY;
        }
        if (object instanceof Table) {
            return TABLE;
        }
        return null;
    }

    private void buildIndexNode(Table table, TreeNode parentNode, List<Index> indexList) {
        for (Index index : indexList) {
            List<Map<String, Object>> data = this.addIndex(index);
            this.buildNode((PDMObject)table, parentNode, (PDMObject)index, NODE_COLOR_ADD, data);
        }
    }

    private void buildPrimaryNode(Table table, TreeNode parentNode, PrimaryKey primaryKey) {
        if (primaryKey != null) {
            List<Map<String, Object>> data = this.addPrimary(primaryKey);
            this.buildNode((PDMObject)table, parentNode, (PDMObject)primaryKey, NODE_COLOR_ADD, data);
        }
    }
}

