/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.compare.dbmeta;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.plugin.compare.dbmeta.CommandContext;
import kd.bos.designer.plugin.compare.dbmeta.IDBMetaManager;
import kd.bos.designer.plugin.compare.dbmeta.OracleMetaManager;
import kd.bos.designer.plugin.compare.dbmeta.PgMetaManager;
import org.apache.commons.lang.NotImplementedException;

public abstract class DBMetaManager
implements IDBMetaManager {
    protected String[] excludeTableTags = new String[]{"%_R", "%_R2", "%_R3", "TEMP_%", "T_TEST_%"};

    public static IDBMetaManager getDBMetaManager(DBType dbType) {
        switch (dbType) {
            case Oracle: {
                return new OracleMetaManager();
            }
            case PostgreSQL: {
                return new PgMetaManager();
            }
        }
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeDB(CommandContext ctx, String sql) throws Exception {
        Connection conn = null;
        Statement ps = null;
        try {
            boolean ret;
            conn = DBMetaManager.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            boolean bl = ret = ps.execute();
            return bl;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T executeDB(CommandContext ctx, String sql, Object[] params, ResultSetHandler<T> handler) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Connection getConnection(CommandContext ctx) throws ClassNotFoundException, SQLException {
        DBType dbtype = ctx.getDbType();
        Class.forName(DBMetaManager.getDriver(dbtype));
        Connection conn = DriverManager.getConnection(ctx.getUrl(), ctx.getUser(), ctx.getPwd());
        return conn;
    }

    private static String getDriver(DBType sqlDBType) {
        switch (sqlDBType) {
            case DM: {
                return "dm.jdbc.driver.DmDriver";
            }
            case MySQL: {
                return "com.mysql.cj.jdbc.Driver";
            }
            case PostgreSQL: {
                return "org.postgresql.Driver";
            }
            case Oracle: {
                return "oracle.jdbc.driver.OracleDriver";
            }
            case SQLServer: {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
            case Vastbase: {
                return "cn.com.vastbase.Driver";
            }
            case YasDB: {
                return "com.yashandb.jdbc.Driver";
            }
            case OceanBase_Oracle: {
                return "com.oceanbase.jdbc.Driver";
            }
        }
        throw new RuntimeException("dbtype error\u3002");
    }

    protected int parseIntNullAsZero(String s) {
        return s == null ? 0 : Integer.parseInt(s);
    }
}

