/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.compare.dbmeta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.designer.plugin.compare.dbmeta.CommandContext;
import kd.bos.designer.plugin.compare.dbmeta.DBMetaManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OracleMetaManager
extends DBMetaManager {
    OracleMetaManager() {
    }

    @Override
    public Collection<Table> queryAllTables(CommandContext ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT C.TABLE_NAME, C.COLUMN_NAME,C.DATA_TYPE,C.DATA_LENGTH,C.CHAR_LENGTH,C.DATA_PRECISION,C.DATA_SCALE,C.NULLABLE,C.DATA_DEFAULT,C.COLUMN_ID,CO.COMMENTS ");
        sql.append(" FROM USER_TAB_COLUMNS C INNER JOIN USER_TABLES A ON C.TABLE_NAME = A.TABLE_NAME LEFT JOIN ALL_COL_COMMENTS CO ON C.TABLE_NAME=CO.TABLE_NAME AND C.COLUMN_NAME = CO.COLUMN_NAME ");
        sql.append(" WHERE C.TABLE_NAME NOT LIKE 'BIN$%' ");
        if (this.excludeTableTags.length > 0) {
            for (int i = 0; i < this.excludeTableTags.length; ++i) {
                sql.append(" AND C.TABLE_NAME NOT LIKE '").append(this.excludeTableTags[i]).append("' ");
            }
        }
        sql.append(" ORDER BY C.TABLE_NAME, C.COLUMN_ID ");
        ArrayList<Table> tableList = new ArrayList<Table>(100);
        LinkedHashMap tabColListMap = new LinkedHashMap(16);
        OracleMetaManager.executeDB(ctx, sql.toString(), null, rs -> {
            while (rs.next()) {
                String tabName = rs.getString("TABLE_NAME");
                ArrayList<Column> cols = (ArrayList<Column>)tabColListMap.get(tabName);
                if (cols == null) {
                    cols = new ArrayList<Column>(50);
                    tabColListMap.put(tabName, cols);
                }
                cols.add(this.createColumn(rs));
            }
            return null;
        });
        Map<String, PrimaryKey> primaryKeyMap = this.innerQueryAllPrimaryKey(ctx);
        Map<String, List<Index>> indexMap = this.innerQueryAllIndex(ctx);
        for (Map.Entry entry : tabColListMap.entrySet()) {
            List<Index> indexList;
            String tabName = (String)entry.getKey();
            Table table = new Table(tabName);
            for (Column col : (List)entry.getValue()) {
                table.addColumn(col);
            }
            PrimaryKey pk = primaryKeyMap.get(tabName);
            if (pk != null) {
                table.setPrimaryKey(pk);
            }
            if ((indexList = indexMap.get(tabName)) != null) {
                for (Index idx : indexList) {
                    table.addIndex(idx);
                }
            }
            tableList.add(table);
        }
        return tableList;
    }

    private Collection<Column> queryColumns(CommandContext ctx, String table) throws Exception {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT C.TABLE_NAME,C.COLUMN_NAME,C.DATA_TYPE,C.DATA_LENGTH,C.CHAR_LENGTH,C.DATA_PRECISION,C.DATA_SCALE,C.NULLABLE,C.DATA_DEFAULT,C.COLUMN_ID,CO.COMMENTS ");
        sql.append(" FROM USER_TAB_COLUMNS  C LEFT JOIN ALL_COL_COMMENTS CO ON C.TABLE_NAME=CO.TABLE_NAME AND C.COLUMN_NAME = CO.COLUMN_NAME ");
        sql.append(" WHERE C.TABLE_NAME= ? ORDER BY C.COLUMN_ID ");
        return (Collection)OracleMetaManager.executeDB(ctx, sql.toString(), new Object[]{table}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (rs.next()) {
                columnList.add(this.createColumn(rs));
            }
            return columnList;
        });
    }

    private Collection<PrimaryKey> queryAllPrimaryKey(CommandContext ctx) throws Exception {
        Map<String, PrimaryKey> map = this.innerQueryAllPrimaryKey(ctx);
        return map.values();
    }

    private Collection<Index> queryAllIndex(CommandContext ctx) throws Exception {
        Map<String, List<Index>> map = this.innerQueryAllIndex(ctx);
        ArrayList<Index> list = new ArrayList<Index>(50);
        for (List<Index> l : map.values()) {
            list.addAll(l);
        }
        return list;
    }

    private Map<String, List<Index>> innerQueryAllIndex(CommandContext ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT I.INDEX_NAME, T.TABLE_NAME, T.COLUMN_NAME, I.UNIQUENESS ");
        sql.append("  FROM USER_IND_COLUMNS T INNER JOIN USER_INDEXES I ON T.INDEX_NAME = I.INDEX_NAME AND T.TABLE_NAME = I.TABLE_NAME");
        sql.append(" WHERE T.TABLE_NAME NOT LIKE 'BIN$%' ");
        if (this.excludeTableTags.length > 0) {
            for (int i = 0; i < this.excludeTableTags.length; ++i) {
                sql.append(" AND T.TABLE_NAME NOT LIKE '").append(this.excludeTableTags[i]).append("' ");
            }
        }
        LinkedHashMap<String, List<Index>> idxMap = new LinkedHashMap<String, List<Index>>(100);
        OracleMetaManager.executeDB(ctx, sql.toString(), null, rs -> {
            while (rs.next()) {
                String table_name = rs.getString("TABLE_NAME");
                String indexName = rs.getString("INDEX_NAME");
                String column_name = rs.getString("COLUMN_NAME");
                String uniqueness = rs.getString("UNIQUENESS");
                ArrayList idxList = (ArrayList)idxMap.get(table_name);
                if (idxList == null) {
                    idxList = new ArrayList(3);
                    idxMap.put(table_name, idxList);
                }
                Index index = null;
                for (Index idx : idxList) {
                    if (!idx.getNumber().equalsIgnoreCase(indexName)) continue;
                    index = idx;
                    break;
                }
                if (index == null) {
                    index = new Index(indexName);
                    if ("UNIQUE".equals(uniqueness)) {
                        index.setUnique(true);
                    }
                }
                index.addColumn(column_name, true);
            }
            return null;
        });
        return idxMap;
    }

    @Nullable
    private Map<String, PrimaryKey> innerQueryAllPrimaryKey(CommandContext ctx) throws Exception {
        String sql = "SELECT A.TABLE_NAME,A.CONSTRAINT_NAME,A.COLUMN_NAME FROM USER_CONS_COLUMNS A INNER JOIN USER_CONSTRAINTS B ON A.CONSTRAINT_NAME = B.CONSTRAINT_NAME AND B.CONSTRAINT_TYPE = 'P' ORDER BY A.CONSTRAINT_NAME, A.POSITION ";
        LinkedHashMap<String, PrimaryKey> pkMap = new LinkedHashMap<String, PrimaryKey>(100);
        OracleMetaManager.executeDB(ctx, sql, null, rs -> {
            while (rs.next()) {
                String table_name = rs.getString("TABLE_NAME");
                String constraint_name = rs.getString("CONSTRAINT_NAME");
                String column_name = rs.getString("COLUMN_NAME");
                PrimaryKey pk = (PrimaryKey)pkMap.get(table_name);
                if (pk == null) {
                    pk = new PrimaryKey(constraint_name);
                    pkMap.put(table_name, pk);
                }
                pk.addCol(column_name);
            }
            return null;
        });
        return pkMap;
    }

    @NotNull
    private Column createColumn(ResultSet rs) throws SQLException {
        String data_default = rs.getString("data_default");
        String column_name = rs.getString("column_name");
        String data_type = rs.getString("data_type");
        int data_length = this.parseIntNullAsZero(rs.getString("data_length"));
        int char_length = this.parseIntNullAsZero(rs.getString("CHAR_LENGTH"));
        int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
        int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
        boolean nullable = "Y".equals(rs.getString("nullable"));
        int column_id = rs.getInt("column_id");
        String comments = rs.getString("comments");
        Column column = new Column(column_name);
        column.setDataType(this.convertDialectToKsqlDataType(data_type, data_precision, data_scale));
        column.setLength(this.convertLength(data_type, data_length, char_length));
        column.setPrecision(data_precision);
        column.setScale(data_scale);
        column.setAllowNull(nullable);
        column.setDefaultValue(data_default);
        column.setComment(comments);
        return column;
    }

    private DataType convertDialectToKsqlDataType(String dataType, int dataPrecision, int dataScale) {
        String ksqlType;
        if (dataType.equalsIgnoreCase("NUMBER")) {
            ksqlType = dataScale == 0 ? (dataPrecision >= 19 || dataPrecision == 0 ? "BIGINT" : (dataPrecision == 10 ? "INT" : "INT")) : "DECIMAL";
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            ksqlType = "CHAR";
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            ksqlType = "NCHAR";
        } else if (dataType.equalsIgnoreCase("VARCHAR2")) {
            ksqlType = "VARCHAR";
        } else if (dataType.equalsIgnoreCase("NVARCHAR2")) {
            ksqlType = "NVARCHAR";
        } else if (dataType.equalsIgnoreCase("NCLOB")) {
            ksqlType = "NCLOB";
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            ksqlType = "BLOB";
        } else if (dataType.equalsIgnoreCase("CLOB")) {
            ksqlType = "CLOB";
        } else if (dataType.equalsIgnoreCase("TIMESTAMP") || dataType.equalsIgnoreCase("DATE")) {
            ksqlType = "DATETIME";
        } else {
            throw new IllegalArgumentException("datatype : " + dataType);
        }
        return DataType.valueOf((String)ksqlType);
    }

    private int convertLength(String dataType, int dataLength, int charLength) {
        if (dataType.equalsIgnoreCase("CHAR")) {
            return charLength;
        }
        if (dataType.equalsIgnoreCase("NCHAR")) {
            return charLength;
        }
        if (dataType.equalsIgnoreCase("VARCHAR2")) {
            return charLength;
        }
        if (dataType.equalsIgnoreCase("NVARCHAR2")) {
            return charLength;
        }
        return dataLength;
    }
}

