/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.compare.dbmeta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.designer.plugin.compare.dbmeta.CommandContext;
import kd.bos.designer.plugin.compare.dbmeta.DBMetaManager;
import org.jetbrains.annotations.NotNull;

class PgMetaManager
extends DBMetaManager {
    PgMetaManager() {
    }

    @Override
    public Collection<Table> queryAllTables(CommandContext ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("  select s.table_name,s.column_name,t.typname as data_type ,s.character_maximum_length,s.numeric_precision,s.numeric_scale,s.is_nullable,s.column_default,s.ordinal_position ");
        sql.append(" ,col_description((table_schema||'.'||table_name)::regclass::oid, ordinal_position) as column_comment ");
        sql.append(" from information_schema.columns s,pg_attribute a, pg_class c, pg_type t ");
        sql.append(" where  table_schema = current_schema() and s.table_name = c.relname and s.ordinal_position = a.attnum ");
        sql.append(" and a.attrelid = c.oid and a.atttypid = t.oid ");
        if (this.excludeTableTags.length > 0) {
            sql.append(" and c.relname NOT LIKE '").append(this.excludeTableTags[0].toLowerCase()).append("' ");
            for (int i = 1; i < this.excludeTableTags.length; ++i) {
                sql.append(" AND c.relname NOT LIKE '").append(this.excludeTableTags[i].toLowerCase()).append("' ");
            }
        }
        sql.append(" order by s.ordinal_position ");
        ArrayList<Table> tableList = new ArrayList<Table>(100);
        LinkedHashMap tabColListMap = new LinkedHashMap(16);
        PgMetaManager.executeDB(ctx, sql.toString(), null, rs -> {
            while (rs.next()) {
                String tabName = rs.getString("table_name");
                ArrayList<Column> cols = (ArrayList<Column>)tabColListMap.get(tabName);
                if (cols == null) {
                    cols = new ArrayList<Column>(50);
                    tabColListMap.put(tabName, cols);
                }
                cols.add(this.createColumn(rs));
            }
            return null;
        });
        Map<String, List<PDMObject>> indexMap = this.innerQueryAllIndex(ctx);
        for (Map.Entry entry : tabColListMap.entrySet()) {
            String tabName = (String)entry.getKey();
            Table table = new Table(tabName);
            for (Column col : (List)entry.getValue()) {
                table.addColumn(col);
            }
            List<PDMObject> objectList = indexMap.get(tabName);
            for (PDMObject obj : objectList) {
                if (obj instanceof PrimaryKey) {
                    table.setPrimaryKey((PrimaryKey)obj);
                    continue;
                }
                table.addIndex((Index)obj);
            }
            tableList.add(table);
        }
        return tableList;
    }

    private Collection<Column> queryColumns(CommandContext ctx, String table) throws Exception {
        return null;
    }

    private Collection<PrimaryKey> queryAllPrimaryKey(CommandContext ctx) throws Exception {
        Map<String, List<PDMObject>> indexes = this.innerQueryAllIndex(ctx);
        ArrayList<PrimaryKey> indexList = new ArrayList<PrimaryKey>(100);
        for (List<PDMObject> l : indexes.values()) {
            for (PDMObject obj : l) {
                if (!(obj instanceof PrimaryKey)) continue;
                indexList.add((PrimaryKey)obj);
            }
        }
        return indexList;
    }

    private Collection<Index> queryAllIndex(CommandContext ctx) throws Exception {
        Map<String, List<PDMObject>> indexes = this.innerQueryAllIndex(ctx);
        ArrayList<Index> indexList = new ArrayList<Index>(100);
        for (List<PDMObject> l : indexes.values()) {
            for (PDMObject obj : l) {
                if (!(obj instanceof Index)) continue;
                indexList.add((Index)obj);
            }
        }
        return indexList;
    }

    private Map<String, List<PDMObject>> innerQueryAllIndex(CommandContext ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("select b.relname tabname, ic.relname idxname, b.indisprimary, b.indisunique, b.indisclustered, c.attname from pg_attribute c");
        sql.append(" inner join (select i.indrelid, t.relname, i.indexrelid, i.indisprimary, i.indisunique, i.indisclustered, unnest(i.indkey) colid from pg_index i");
        sql.append(" inner join pg_class t on i.indrelid = t.oid) b on c.attrelid = b.indrelid and c.attnum = colid");
        sql.append(" inner join pg_class ic on ic.oid = b.indexrelid  ");
        if (this.excludeTableTags.length > 0) {
            sql.append(" where b.relname NOT LIKE '").append(this.excludeTableTags[0].toLowerCase()).append("' ");
            for (int i = 1; i < this.excludeTableTags.length; ++i) {
                sql.append(" AND b.relname NOT LIKE '").append(this.excludeTableTags[i].toLowerCase()).append("' ");
            }
        }
        LinkedHashMap<String, List<PDMObject>> idxMap = new LinkedHashMap<String, List<PDMObject>>(100);
        PgMetaManager.executeDB(ctx, sql.toString(), null, rs -> {
            while (rs.next()) {
                String table_name = rs.getString("tabname");
                String indexName = rs.getString("idxname");
                String column_name = rs.getString("attname");
                boolean indisunique = rs.getBoolean("indisunique");
                boolean indisclustered = rs.getBoolean("indisclustered");
                boolean indisprimary = rs.getBoolean("indisprimary");
                ArrayList<PrimaryKey> idxList = (ArrayList<PrimaryKey>)idxMap.get(table_name);
                if (idxList == null) {
                    idxList = new ArrayList<PrimaryKey>(3);
                    idxMap.put(table_name, idxList);
                }
                Object obj = null;
                for (PDMObject pDMObject : idxList) {
                    if (!pDMObject.getNumber().equalsIgnoreCase(indexName)) continue;
                    obj = pDMObject;
                    break;
                }
                if (obj == null) {
                    obj = indisprimary ? new PrimaryKey(indexName) : new Index(indexName);
                    idxList.add((PrimaryKey)obj);
                }
                if (indisprimary) {
                    ((PrimaryKey)obj).addCol(column_name);
                    if (!indisclustered) continue;
                    obj.setCluster(true);
                    continue;
                }
                ((Index)obj).addColumn(column_name, true);
                if (indisunique) {
                    ((Index)obj).setUnique(true);
                }
                if (!indisclustered) continue;
                ((Index)obj).setCluster(true);
            }
            return null;
        });
        return idxMap;
    }

    @NotNull
    private Column createColumn(ResultSet rs) throws SQLException {
        String column_name = rs.getString("column_name");
        String dataType = rs.getString("data_type");
        int data_length = this.parseIntNullAsZero(rs.getString("character_maximum_length"));
        int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
        int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
        boolean nullable = "YES".equals(rs.getString("is_nullable"));
        String data_default = rs.getString("column_default");
        if (data_default != null) {
            data_default = data_default.split("::")[0];
        }
        String column_comment = rs.getString("column_comment");
        Column column = new Column(column_name);
        column.setDataType(this.convertDialectToKsqlDataType(dataType));
        column.setLength(data_length);
        column.setPrecision(data_precision);
        column.setScale(data_scale);
        column.setAllowNull(nullable);
        column.setDefaultValue(data_default);
        column.setComment(column_comment);
        return column;
    }

    private DataType convertDialectToKsqlDataType(String dataType) {
        String ksqlType;
        if (dataType.equalsIgnoreCase("SMALLINT") || dataType.equalsIgnoreCase("INT2")) {
            ksqlType = "SMALLINT";
        } else if (dataType.equalsIgnoreCase("INTEGER") || dataType.equalsIgnoreCase("INT4")) {
            ksqlType = "INT";
        } else if (dataType.equalsIgnoreCase("BIGINT") || dataType.equalsIgnoreCase("INT8")) {
            ksqlType = "BIGINT";
        } else if (dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("BPCHAR")) {
            ksqlType = "CHAR";
        } else if (dataType.equalsIgnoreCase("CHARACTER")) {
            ksqlType = "NCHAR";
        } else if (dataType.equalsIgnoreCase("CHARACTER VARYING") || dataType.equalsIgnoreCase("VARCHAR")) {
            ksqlType = "VARCHAR";
        } else if (dataType.equalsIgnoreCase("TEXT")) {
            ksqlType = "NCLOB";
        } else if (dataType.equalsIgnoreCase("BYTEA")) {
            ksqlType = "BLOB";
        } else if (dataType.equalsIgnoreCase("DATETIME") || dataType.equalsIgnoreCase("TIMESTAMP")) {
            ksqlType = "DATETIME";
        } else if (dataType.equalsIgnoreCase("NUMERIC")) {
            ksqlType = "DECIMAL";
        } else {
            throw new IllegalArgumentException("datatype : " + dataType);
        }
        return DataType.valueOf((String)ksqlType);
    }
}

