/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.log;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.datamodel.metadata.dao.PDMEntityMetaBuilder;
import kd.bos.datamodel.metadata.pdm.DeployPDMMetadataDao;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMEntityMetadata;
import kd.bos.db.DB;
import kd.bos.designer.plugin.PDMModelCompare;
import kd.bos.designer.plugin.log.DataModelLog;
import kd.bos.designer.plugin.log.DataModelLogDao;
import kd.bos.designer.plugin.log.DataModelLogServiceImpl;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;

public class DataModelHistoryPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(DataModelHistoryPlugin.class);
    private static final String TRUE = "true";
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    private static final String CLOSE = "close";
    private static final String RESTORE = "restore";
    private static final String COMPARE = "compare";
    private static final String DATA_MODEL = "dataModel";
    private static final String XML = "xml";
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String LOCK_MESSAGE = "lockMessage";
    private static final String MODEL_LIST = "modelList";
    private static final String SQL = "sql";
    private static final String RESTORE_CONFIRM_CALLBACK = "restoreConfirmCallBack";
    private static final String BOS_DEVP_METAMERGE = "bos_devp_metadatadiff";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CLOSE, RESTORE, COMPARE, SQL});
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap", ""});
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("openType");
        if (MODEL_LIST.equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COMPARE, RESTORE});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SQL});
        }
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String isDataModel = (String)parameter.getCustomParam(DATA_MODEL);
        if (TRUE.equals(isDataModel)) {
            String id = (String)parameter.getCustomParam("id");
            e.getQFilters().add(new QFilter("modelid", "=", (Object)id));
            e.setOrderBy("operatetime desc");
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        HashMap<String, String> result = new HashMap<String, String>();
        if (CLOSE.equals(key)) {
            result.put("action", CLOSE);
            this.getView().returnDataToParent(result);
            this.getView().close();
        } else if (RESTORE.equals(key)) {
            this.restoreMeta();
        } else if (COMPARE.equals(key)) {
            this.compareDataModel(false);
        } else if (SQL.equals(key)) {
            this.compareDataModel(true);
        }
    }

    private void buildSql(String lastModel, String currentModel) {
        PDMEntityMetadata lastEntityMeta = PDMEntityMetaBuilder.buildPDMEntityMetadata((String)lastModel);
        PDMEntityMetadata currentEntityMeta = PDMEntityMetaBuilder.buildPDMEntityMetadata((String)currentModel);
        if (currentEntityMeta == null || lastEntityMeta == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u811a\u672c\u5931\u8d25\uff0c\u672a\u627e\u5230\u5f53\u524d\u6a21\u578b\u6587\u4ef6\u3002", (String)"DataModelHistoryPlugin_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        PDMModelCompare compare = new PDMModelCompare();
        String number = currentEntityMeta.getNumber();
        HashMap<String, Object> res = new HashMap<String, Object>(2);
        res.put("number", number);
        Map<String, Map<String, String>> sqlParameter = compare.comparePDModel(lastEntityMeta, currentEntityMeta);
        if (sqlParameter.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6a21\u578b\u4e4b\u95f4\u65e0\u5dee\u5f02\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"DataModelHistoryPlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        res.put("sqlParameter", sqlParameter);
        res.put("modelId", currentEntityMeta.getId());
        res.put("bizAppId", currentEntityMeta.getBizappId());
        this.getView().returnDataToParent(res);
        this.getView().close();
    }

    private void compareDataModel(boolean isBuildSql) {
        String number;
        long currentVersion;
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 2 && selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6216\u8005\u4e24\u6761\u8bb0\u5f55\u3002", (String)"DataModelHistoryPlugin_5", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Long pkId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
        DataModelLog dataModelLog = DataModelLogDao.getDataModelLog(pkId);
        String current = dataModelLog == null ? null : dataModelLog.getXml();
        long l = currentVersion = dataModelLog == null ? 0L : dataModelLog.getVersion();
        if (selectedRows.size() == 1) {
            DeployMetadata dataModelMetadata = DeployPDMMetadataDao.getDataModelMetadata((String)id);
            long lastVersion = currentVersion;
            String last = current;
            currentVersion = dataModelMetadata.getVersion();
            current = dataModelMetadata.toDeployFile("").getFileContent();
            if (isBuildSql) {
                this.buildSql(last, current);
                return;
            }
            this.showMerge(last, current, lastVersion, currentVersion, ((AbstractDesignMeta)dataModelMetadata.getDesignMetas().get(0)).getNumber());
            return;
        }
        Long pkId2 = (Long)billList.getSelectedRows().get(1).getPrimaryKeyValue();
        DataModelLog currentDataModelLog = DataModelLogDao.getDataModelLog(pkId2);
        String last = currentDataModelLog == null ? null : currentDataModelLog.getXml();
        long lastVersion = currentDataModelLog == null ? 0L : currentDataModelLog.getVersion();
        String string = number = currentDataModelLog == null ? "" : currentDataModelLog.getNumber();
        if (currentVersion < lastVersion) {
            String temp = current;
            current = last;
            last = temp;
            long tempVersion = currentVersion;
            currentVersion = lastVersion;
            lastVersion = tempVersion;
        }
        if (isBuildSql) {
            this.buildSql(last, current);
            return;
        }
        this.showMerge(last, current, lastVersion, currentVersion, number);
    }

    private void restoreMeta() {
        if (!this.isCanRestore()) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataModelHistoryPlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object param = this.getView().getFormShowParameter().getCustomParam(LOCK_MESSAGE);
        if (param != null) {
            this.getView().showErrorNotification((String)param);
            return;
        }
        Long pkId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
        DataModelLog metaLog = DataModelLogDao.getDataModelLog(pkId);
        String xml = metaLog.getXml();
        this.getPageCache().put(XML, xml);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5c06\u5f53\u524d\u7248\u672c\u6570\u636e\u6a21\u578b\u8fd8\u539f\u81f3\u6570\u636e\u5e93\u5417\uff1f", (String)"DataModelHistoryPlugin_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(RESTORE_CONFIRM_CALLBACK));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (RESTORE_CONFIRM_CALLBACK.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
            String xml = this.getPageCache().get(XML);
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("action", RESTORE);
            try {
                MetadataDao.deployMetadata((String)xml, null, null);
                PDMDesignMetaDao.deleteModelById((String)id);
                this.writeLog(id, MetadataDao.getNumberById((String)id));
                result.put(STATUS, SUCCESS);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                result.put(STATUS, ERROR);
                result.put(MESSAGE, e.getMessage());
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private void showMerge(String lastXml, String currentXml, long oldCommitId, long newCommitId, String number) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DEVP_METAMERGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("newCommitId", (Object)String.valueOf(newCommitId));
        parameter.setCustomParam("oldCommitId", (Object)String.valueOf(oldCommitId));
        parameter.setCustomParam(LAST_DYM, (Object)lastXml);
        parameter.setCustomParam(BASE_DYM, (Object)currentXml);
        parameter.setCustomParam("filePath", (Object)("/" + number + ".kpdm"));
        parameter.setCustomParam("isNotShowTree", (Object)TRUE);
        this.getView().showForm(parameter);
    }

    private void writeLog(String modelId, String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            DataModelLogServiceImpl logService = new DataModelLogServiceImpl();
            logService.addDataModelLog(modelId, null, null, null);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private boolean isPrintModel() {
        return TRUE.equals(this.getView().getFormShowParameter().getCustomParam("isPrintModel"));
    }

    private boolean isDesignerMetaLog() {
        return TRUE.equals(this.getView().getFormShowParameter().getCustomParam("designerMetaLog"));
    }

    private boolean isBizObjExt() {
        return TRUE.equals(this.getView().getFormShowParameter().getCustomParam("bizext"));
    }

    private boolean isCanRestore() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean gray = (Boolean)parameter.getCustomParam("gray");
        if (gray) {
            String errorMsg = ResManager.loadKDString((String)"\u7070\u5ea6\u529f\u80fd\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_32", (String)"bos-designer-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean prod = (Boolean)parameter.getCustomParam("prod");
        if (prod) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_28", (String)"bos-designer-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean deploy = (Boolean)parameter.getCustomParam("deploy");
        if (deploy) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FormDesignerPlugin_31", (String)"bos-designer-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean currentIsv = (Boolean)parameter.getCustomParam("currentIsvIsBank");
        if (currentIsv) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"MetaDataLogRestorePlugin_4", (String)"bos-designer-plugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean isvIsSame = (Boolean)parameter.getCustomParam("isvIsSame");
        if (!isvIsSame) {
            String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u4e0d\u652f\u6301\u8fd8\u539f\u3002", (String)"DataModelHistoryPlugin_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }
}

