/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.log;

import java.util.ArrayList;
import java.util.List;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.designer.plugin.log.DataModelLog;
import kd.bos.designer.plugin.log.DataModelLogData;

public class DataModelLogDao {
    public static DataModelLog getDataModelLog(Long id) {
        String sql = "SELECT FVERSION, FDATA_TAG,FMODELNUMBER FROM T_DM_PDMMODELVERSION WHERE FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)id)};
        return (DataModelLog)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                DataModelLog log = new DataModelLog();
                log.setXml(rs.getString("FDATA_TAG"));
                log.setVersion(rs.getLong("FVERSION"));
                log.setNumber(rs.getString("FMODELNUMBER"));
                return log;
            }
            return null;
        });
    }

    public static void deleteDataModelLog(String modelId) {
        String sql = "SELECT FID FROM T_DM_PDMMODELVERSION WHERE FMODELID = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FMODELID", 12, (Object)modelId)};
        List idList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, rs -> {
            ArrayList<Long> ids = new ArrayList<Long>(10);
            while (rs.next()) {
                long fid = rs.getLong("FID");
                ids.add(fid);
            }
            return ids;
        });
        if (!idList.isEmpty()) {
            IDataEntityType dataEntityType = OrmUtils.getDataEntityType(DataModelLogData.class);
            BusinessDataWriter.delete((IDataEntityType)dataEntityType, (Object[])idList.toArray());
        }
    }

    public static void updateGitCommitStatus(String modelId) {
        String sql = "SELECT TOP 1 FID FROM T_DM_PDMMODELVERSION WHERE FMODELID = ? ORDER BY FOPERATETIME DESC";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FMODELID", 12, (Object)modelId)};
        Long id = (Long)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, rs -> {
            if (rs.next()) {
                return rs.getLong("FID");
            }
            return null;
        });
        if (id != null) {
            String updateSql = "UPDATE T_DM_PDMMODELVERSION SET FCOMMIT = '1' WHERE FID = ?";
            Object[] parameters2 = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)id)};
            DB.execute((DBRoute)DBRoute.meta, (String)updateSql, (Object[])parameters2);
        }
    }
}

