/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.plugin.log;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.pdm.DeployPDMMetadataDao;
import kd.bos.db.DB;
import kd.bos.designer.plugin.log.DataModelLogData;
import kd.bos.designer.plugin.log.DataModelLogService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.deploy.DeployMetadata;

public class DataModelLogServiceImpl
implements DataModelLogService {
    @Override
    public void addDataModelLog(DataModelLogData dataModelLogData) {
        long id = DB.genGlobalLongId();
        dataModelLogData.setId(id);
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(DataModelLogData.class);
        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])new Object[]{dataModelLogData});
    }

    @Override
    public void addDataModelLog(String modelId, String modelNumber, String submit, String description) {
        DataModelLogData dataModelLogData = new DataModelLogData();
        dataModelLogData.setId(DB.genGlobalLongId());
        dataModelLogData.setModelId(modelId);
        dataModelLogData.setIsv(ISVService.getISVInfo().getId());
        dataModelLogData.setSubmit(submit);
        DeployMetadata dataModelMetadata = DeployPDMMetadataDao.getDataModelMetadata((String)modelId);
        if (StringUtils.isBlank((CharSequence)modelNumber)) {
            modelNumber = ((AbstractDesignMeta)dataModelMetadata.getDesignMetas().get(0)).getNumber();
        }
        dataModelLogData.setModelNumber(modelNumber);
        String data = this.getDeployMeta(dataModelMetadata);
        long version = dataModelMetadata.getVersion();
        dataModelLogData.setData(data);
        dataModelLogData.setDescription(description);
        dataModelLogData.setVersion(version);
        dataModelLogData.setOperator(RequestContext.get().getCurrUserId());
        dataModelLogData.setOperateTime(new Date());
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(DataModelLogData.class);
        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])new Object[]{dataModelLogData});
    }

    private String getDeployMeta(DeployMetadata deploy) {
        if (deploy == null) {
            return "";
        }
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setIndent(true);
        serializer.setNewlines(true);
        String fileContent = serializer.serializeToString((Object)deploy, null);
        if (!fileContent.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") && !(fileContent = serializer.serializeToString((Object)this, null)).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u5e8f\u5217\u5316\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff01", (String)"MetadataLogServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0])});
        }
        return fileContent;
    }
}

