/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.datamodel.meta.element.pdm.ColumnAp;
import kd.bos.datamodel.meta.element.pdm.TableAp;
import kd.bos.designer.property.DataModelPropertyHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class RelationNodePlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String PARAM_CONTEXT = "context";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_META_TYPE = "metatype";
    private static final String PARAM_ITEM_ID = "itemId";
    private static final String PARAM_PROPERTY_NAME = "propertyName";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TABLE = "table";
    private static final String COLUMN = "column";
    private static final String TABLE_ID = "tableId";
    private static final String COLUMN_ID_MAPPING = "columnIdMapping";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List param = (List)parameter.getCustomParam(PARAM_CONTEXT);
        Map value = (Map)parameter.getCustomParam(PARAM_VALUE);
        TableAp tableAp = DataModelPropertyHelper.buildTableAp(param);
        this.initEntryEntity(tableAp, value);
    }

    private void initEntryEntity(TableAp tableAp, Map<String, Object> value) {
        if (tableAp == null) {
            return;
        }
        this.getPageCache().put(TABLE_ID, tableAp.getId());
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(tableAp.getColumns().size());
        HashMap<String, String> columnIdMapping = new HashMap<String, String>(tableAp.getColumns().size());
        for (ColumnAp columnAp : tableAp.getColumns()) {
            ComboItem item = new ComboItem(new LocaleString(columnAp.getColumnName()), columnAp.getColumnName());
            comboItems.add(item);
            columnIdMapping.put(columnAp.getColumnName(), columnAp.getId());
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(COLUMN);
        comboEdit.setComboItems(comboItems);
        this.getPageCache().put(COLUMN_ID_MAPPING, SerializationUtils.toJsonString(columnIdMapping));
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        this.getModel().setValue(TABLE, (Object)tableAp.getTableName(), rowIndex);
        if (value.get("ColumnIds") == null) {
            return;
        }
        List v = (List)value.get("ColumnIds");
        String refColumnId = (String)((Map)v.get(0)).get("DMRefId");
        String columnName = tableAp.getColumnName(refColumnId);
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            this.getModel().setValue(COLUMN, (Object)columnName, rowIndex);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.btnOk();
        }
    }

    private void btnOk() {
        String columnName = (String)this.getModel().getValue(COLUMN, 0);
        if (StringUtils.isBlank((CharSequence)columnName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RelationStartNodePlugin_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String itemId = (String)parameter.getCustomParam(PARAM_ITEM_ID);
        String propertyName = (String)parameter.getCustomParam(PARAM_PROPERTY_NAME);
        String metaType = (String)parameter.getCustomParam(PARAM_META_TYPE);
        Map oldValue = (Map)parameter.getCustomParam(PARAM_VALUE);
        String columnIdMapping = this.getPageCache().get(COLUMN_ID_MAPPING);
        Map idMapping = (Map)SerializationUtils.fromJsonString((String)columnIdMapping, Map.class);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(PARAM_ITEM_ID, itemId);
        result.put(PARAM_PROPERTY_NAME, propertyName);
        if (StringUtils.isBlank((CharSequence)metaType)) {
            metaType = "dmmeta";
        }
        result.put(PARAM_META_TYPE, metaType);
        HashMap<String, Object> value = new HashMap<String, Object>(4);
        value.put("_Type_", "RelNode");
        String id = oldValue.get("Id") == null ? Uuid16.create().toString() : (String)oldValue.get("Id");
        Object columnIds = oldValue.get("ColumnIds");
        String columnId = null;
        if (columnIds instanceof List && !((List)columnIds).isEmpty()) {
            Map col = (Map)((List)columnIds).get(0);
            columnId = col.get("Id") == null ? Uuid16.create().toString() : (String)col.get("Id");
        }
        value.put("Id", id);
        value.put("RelTableId", this.getPageCache().get(TABLE_ID));
        ArrayList columns = new ArrayList(1);
        HashMap<String, String> column = new HashMap<String, String>(4);
        String colId = columnId == null ? Uuid16.create().toString() : columnId;
        column.put("Id", colId);
        column.put("ParentId", id);
        column.put("_Type_", "RefColumnAp");
        String dMRefId = (String)idMapping.get(columnName);
        column.put("DMRefId", dMRefId);
        columns.add(column);
        value.put("ColumnIds", columns);
        result.put(PARAM_VALUE, value);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }
}

