/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.table;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.table.AbstractValidator;
import kd.bos.designer.table.ColumnTypes;
import kd.bos.designer.table.ValidatorResult;

public class ColumnValidator
extends AbstractValidator {
    private static final String COLUMN_TYPE = "columntype";
    private static final String LENGTH = "length";
    private static final String PRECISION = "precision";

    public ColumnValidator(DynamicObjectCollection dynamicObjectCollection) {
        super(dynamicObjectCollection);
    }

    @Override
    public ValidatorResult validator() {
        ValidatorResult result = new ValidatorResult();
        for (int i = 0; i < this.dynamicObjectCollection.size(); ++i) {
            DynamicObject object = (DynamicObject)this.dynamicObjectCollection.get(i);
            StringBuilder message = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>(10);
            ArrayList<String> lengthMessage = new ArrayList<String>(10);
            for (String field : this.validatorField) {
                String filedValue = object.getString(field);
                IDataEntityProperty property = (IDataEntityProperty)object.getDataEntityType().getProperties().get((Object)field);
                if (StringUtils.isBlank((CharSequence)filedValue)) {
                    list.add(property.getDisplayName().getLocaleValue());
                }
                if (!COLUMN_TYPE.equals(field) || !StringUtils.isNotBlank((CharSequence)filedValue)) continue;
                if (this.checkLength(object, filedValue) != null) {
                    lengthMessage.add(this.checkLength(object, filedValue));
                }
                if (this.checkPrecision(object, filedValue) == null) continue;
                lengthMessage.add(this.checkPrecision(object, filedValue));
            }
            this.checkEmptyField(result, this.handleMessage(list), message);
            this.checkColumnType(result, lengthMessage, message);
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            result.getMessage().add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff1a %3$s", (String)"ColumnValidator_3", (String)"bos-datamodel-plugin", (Object[])new Object[0]), object.getDataEntityType().getDisplayName().getLocaleValue(), i + 1, message.toString()));
        }
        return result;
    }

    private String checkLength(DynamicObject object, String fileValue) {
        int length;
        String message = null;
        if ((ColumnTypes.VARCHAR.getType().equals(fileValue) || ColumnTypes.NVARCHAR.getType().equals(fileValue) || ColumnTypes.CHAR.getType().equals(fileValue) || ColumnTypes.DECIMAL.getType().equals(fileValue)) && (length = object.getInt(LENGTH)) <= 0) {
            message = ResManager.loadKDString((String)"\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ColumnValidator_0", (String)"bos-datamodel-plugin", (Object[])new Object[0]);
        }
        return message;
    }

    private String checkPrecision(DynamicObject object, String fileValue) {
        int precision;
        String message = null;
        if (ColumnTypes.DECIMAL.getType().equals(fileValue) && (precision = object.getInt(PRECISION)) <= 0) {
            message = ResManager.loadKDString((String)"\u7cbe\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ColumnValidator_1", (String)"bos-datamodel-plugin", (Object[])new Object[0]);
        }
        return message;
    }

    private void checkEmptyField(ValidatorResult result, String fields, StringBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)fields)) {
            result.setSuccess(false);
            builder.append(fields);
            builder.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ColumnValidator_2", (String)"bos-datamodel-plugin", (Object[])new Object[0]));
        }
    }

    private void checkColumnType(ValidatorResult result, List<String> lengthMessage, StringBuilder builder) {
        if (!lengthMessage.isEmpty()) {
            result.setSuccess(false);
            lengthMessage.forEach(builder::append);
        }
    }
}

