/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.datamodel.metadata.pdm.DeployPDMMetadataDao;
import kd.bos.datamodel.metadata.pdm.PDMDesignMetaDao;
import kd.bos.datamodel.metadata.pdm.PDMEntityDesignMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDBizException;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.FileUtils;

public class DataModelUtils {
    private static final Log logger = LogFactory.getLog(DataModelUtils.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    private static final String JSONTYPE = ".json";
    private static final String RESOURCE = "resource";
    private static final String CUSTOM = "custom";
    private static final String UPLOADSOURCE = "uploadsource";
    private static final String IS_DELETE = "is delete";
    private static final String KINGDEE = "kingdee";
    private static final String regex = "[a-z0-9_]+";
    private static final String regex2 = "[a-z0-9A-Z_]+";
    private static final String MESSAGE = "message";
    public static final String T_TABLE = "T_TABLE";
    private static final String T_TABLE2 = "T_";
    public static final String T_ISV_TABLE = "TK_%s_TABLE";
    private static final String T_ISV_TABLE2 = "TK_%s_";
    private static final String KING_DEE = "kingdee";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DATAMODEL_PLUGIN = "bos-datamodel-plugin";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String APPLICATION_JSONANDCHARSET = "application/json;charset=UTF-8";
    private static final String MC_SERVER_URL = "mc.server.url";
    private static final String ERRORCODE = "errorcode";

    public static String genModelId(String isv, String product, String appNum, String number, String createType) {
        if ("kingdee".equalsIgnoreCase(isv)) {
            isv = "kd";
        }
        if (StringUtils.isBlank((CharSequence)product)) {
            product = "cosmic";
        }
        if ("extend".equals(createType)) {
            return String.format("%s_%s_%s_%s_ext", isv, product, appNum, number);
        }
        return String.format("%s_%s_%s_%s", isv, product, appNum, number);
    }

    public static String autoFormNumber(String number, String tag, String modelId, String masterId) {
        int formCounts = DataModelUtils.getExtFormCounts(modelId, masterId);
        if (number.length() <= 25) {
            if (formCounts > 0) {
                number = number + formCounts;
            }
        } else {
            int tag_len = tag.length();
            number = number.substring(0, 25 - tag_len) + tag;
            if (formCounts > 0) {
                int i_len = String.valueOf(formCounts).length();
                number = number.substring(0, 25 - tag_len - i_len) + tag + formCounts;
            }
        }
        return number;
    }

    public static String autoISVNumber(String number) {
        String isv = ISVService.getISVInfo().getId();
        if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv) && StringUtils.isNotBlank((CharSequence)number) && !number.startsWith(isv.toLowerCase(Locale.ENGLISH) + "_")) {
            number = isv.toLowerCase(Locale.ENGLISH) + "_" + number;
        }
        return number;
    }

    public static Map<String, Object> numberCheck(String number) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        boolean flag = Pattern.matches(regex, number);
        if (!flag) {
            retMap.put(MESSAGE, ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DevportalUtil_55", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return retMap;
        }
        DataModelUtils.checkNumber(number, retMap);
        return retMap;
    }

    public static Map<String, Object> checkNumber(String number, String name) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        boolean flag = Pattern.matches(regex2, number);
        if (!flag) {
            retMap.put(MESSAGE, String.format(ResManager.loadKDString((String)"%s\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DataModelUtils_0", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), name));
            return retMap;
        }
        DataModelUtils.checkDataModelNumber(number, retMap, name);
        return retMap;
    }

    public static String checkNumberAndReturnValue(String number, boolean isLowerCase) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        Map<String, Object> res = isLowerCase ? DataModelUtils.checkNumber2(number, "") : DataModelUtils.checkNumber(number, "");
        return res.isEmpty() ? number : null;
    }

    public static Map<String, Object> checkNumber2(String number, String name) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        boolean flag = Pattern.matches(regex, number);
        if (!flag) {
            retMap.put(MESSAGE, String.format(ResManager.loadKDString((String)"%s\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DataModelUtils_2", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), name));
            return retMap;
        }
        DataModelUtils.checkDataModelNumber(number, retMap, name);
        return retMap;
    }

    private static void checkDataModelNumber(String number, Map<String, Object> retMap, String name) {
        if (number.startsWith("_") || number.endsWith("_")) {
            String message = ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"DataModelUtils_3", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
            retMap.put(MESSAGE, String.format(message, name));
        }
    }

    private static void checkNumber(String number, Map<String, Object> retMap) {
        if (number.startsWith("_") || number.endsWith("_")) {
            retMap.put(MESSAGE, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"DevportalUtil_56", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.length() > 25) {
            retMap.put(MESSAGE, ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"DevportalUtil_57", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public static Map<String, Object> checkTableName(String tableName) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String id = ISVService.getISVInfo().getId();
        if ("kingdee".equals(id)) {
            if (!tableName.toUpperCase().startsWith(T_TABLE2)) {
                String name = ResManager.loadKDString((String)"\u8868\u540d", (String)"TablePlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
                String tbName = ResManager.loadKDString((String)"t_{\u540d\u79f0}\u6216\u8005T_{\u540d\u79f0}", (String)"TablePlugin_13", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
                String message = String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d\u503c\u201c%2$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff1a%3$s\u3002", (String)"TablePlugin_12", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), name, tableName, tbName);
                retMap.put(MESSAGE, message);
                retMap.put("tableName", T_TABLE);
                return retMap;
            }
        } else {
            String isvTable = String.format(T_ISV_TABLE2, id.toUpperCase());
            if (!tableName.toUpperCase().startsWith(isvTable)) {
                String name = ResManager.loadKDString((String)"\u8868\u540d", (String)"TablePlugin_4", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]);
                String tbName = String.format(ResManager.loadKDString((String)"tk_%1$s_{\u540d\u79f0}\u6216\u8005TK_%2$s_{\u540d\u79f0}", (String)"TablePlugin_15", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), id, id.toUpperCase());
                String message = String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d\u503c\u201c%2$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff1a%3$s\u3002", (String)"TablePlugin_12", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]), name, tableName, tbName);
                retMap.put(MESSAGE, message);
                retMap.put("tableName", String.format(T_ISV_TABLE, id.toUpperCase()));
                return retMap;
            }
        }
        return retMap;
    }

    public static boolean numberExist(String number, String modelId) {
        return DataModelUtils.dataModelFieldCheck("fnumber", number, modelId);
    }

    public static boolean bizAppExist(String bizAppId, String modelId) {
        return DataModelUtils.dataModelFieldCheck("fbizappid", bizAppId, modelId);
    }

    private static boolean dataModelFieldCheck(String field, String value, String modelId) {
        Object[] params;
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        String tableName = designerMetaType.getAlias();
        String sql = "";
        if (StringUtils.isBlank((CharSequence)modelId)) {
            sql = String.format("select FId from %s where %s = ? ", tableName, field);
            params = new Object[]{value};
        } else {
            sql = String.format("select FId from %s where %s = ? and fid <> ?", tableName, field);
            params = new Object[]{value, modelId};
        }
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static boolean dataModelFieldCheck(String field, String value) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FId from %s where %s = ? ", tableName, field);
        Object[] params = new Object[]{value};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private static int getExtFormCounts(String modelId, String masterId) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(PDMEntityDesignMeta.class);
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select 1 from %s where FMASTERID = ? ", tableName);
        Object[] params = new SqlParameter[]{StringUtils.isBlank((CharSequence)masterId) ? new SqlParameter(":FMASTERID", 12, (Object)modelId) : new SqlParameter(":FMASTERID", 12, (Object)masterId)};
        return (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                int isvcount = 0;
                if (rs.next()) {
                    isvcount = rs.getInt(1);
                }
                return isvcount;
            }
        });
    }

    public static Map<String, Object> exportSource(String modelId, String modelNumber) {
        return DataModelUtils.exportSource(modelId, modelNumber, null, null, "model");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> exportSource(String modelId, String modelNumber, String bizAppId, Map<String, String> sql, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            bizAppId = PDMDesignMetaDao.getBizAppIdByModelId((String)modelId);
        }
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList<File> fileList = new ArrayList<File>();
        if ("sql".equals(type)) {
            DataModelUtils.exportSql(sql, localPath);
        } else {
            DataModelUtils.expDataModelMetadata(modelId, localPath);
        }
        InputStream in = null;
        try {
            DataModelUtils.zipFiles(modelNumber, localPath, fileList);
            String downloadFile = FileUtils.cleanString((String)(localPath + File.separator + modelNumber + ".zip"));
            Path downloadPath = Paths.get(DataModelUtils.checkFilePath(downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(modelNumber + ".zip", in, 5000);
            result.put("urls", urls);
            result.put("success", true);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.put("success", false);
            result.put("msg", String.format("\u5bfc\u51fa\u5143\u6570\u636e\u5931\u8d25\uff0cERR\uff1a%s", e.getMessage()));
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            try {
                String filePath;
                File traceIdFile;
                if (in != null) {
                    in.close();
                }
                if ((traceIdFile = new File(filePath = FileUtils.cleanString((String)traceIdPath.replace('.', '%').replace('/', '%')))).exists()) {
                    boolean appNumDelete;
                    DataModelUtils.deleteKd(traceIdFile);
                    String checkFilePath = FileUtils.cleanString((String)appNumberPath.replace('.', '%').replace('/', '%'));
                    File appNumberFile = new File(checkFilePath);
                    if (appNumberFile.listFiles().length == 0 && (appNumDelete = appNumberFile.delete())) {
                        logger.debug(appNumberFile + "delete:" + appNumDelete);
                    }
                }
            }
            catch (IOException ioExp) {
                logger.error((Throwable)ioExp);
            }
        }
    }

    private static void exportSql(Map<String, String> sql, String exportPath) {
        for (Map.Entry<String, String> entry : sql.entrySet()) {
            String name = entry.getKey();
            String content = entry.getValue();
            try {
                DataModelUtils.saveMetaFile(content, name, exportPath);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static JSONObject expDataModelMetadata(String modelId, String exportPath) {
        JSONObject checkInMsg = new JSONObject();
        try {
            List list = DeployPDMMetadataDao.getDataModelDeployFile((String)modelId);
            if (list != null && list.size() > 0) {
                String pdmMeta = ((DeployFile)list.get(0)).getFileContent();
                String pdmFileName = ((DeployFile)list.get(0)).getFileName();
                DataModelUtils.saveMetaFile(pdmMeta, pdmFileName, exportPath);
                for (int i = 1; i < list.size(); ++i) {
                    String langFileName = ((DeployFile)list.get(i)).getFileName();
                    String langMeta = ((DeployFile)list.get(i)).getFileContent();
                    DataModelUtils.saveMetaFile(langMeta, langFileName, exportPath);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return checkInMsg;
    }

    private static void saveMetaFile(String pdmMeta, String pdmFileName, String exportPath) {
        String fullPath = String.format("%s/metadata/%s", exportPath, pdmFileName);
        String[] abovePath = fullPath.split(pdmFileName);
        File fileAbovePath = new File(FileUtils.cleanString((String)abovePath[0]));
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        Path customZipPath = Paths.get(DataModelUtils.checkFilePath(FileUtils.cleanString((String)fullPath)), new String[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(pdmMeta);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void zipFiles(String zipName, String localPath, List<File> fileList) {
        JSONArray files = new JSONArray();
        String MetadataPath = FileUtils.cleanString((String)((localPath = DataModelUtils.checkFilePath(localPath)) + File.separator + "metadata"));
        File MetadataFile = new File(MetadataPath);
        if (MetadataFile.exists()) {
            files.add((Object)MetadataPath);
        }
        if (fileList != null && fileList.size() > 0) {
            for (File file : fileList) {
                try {
                    files.add((Object)file.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        String zipFilePath = FileUtils.cleanString((String)(localPath + File.separator + zipName + ".zip"));
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DataModelUtils.zipFile(files, out, "");
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void zipFile(JSONArray files, ZipOutputStream out, String pathSign) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
                DataModelUtils.zipFile(tempFiles, out, pathSign);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            Path zipFilePath = Paths.get(path, new String[0]);
            String fileName = file.getName();
            int t = -1;
            if (path == null) continue;
            if (path.contains("datamodel")) {
                t = path.indexOf("datamodel");
            }
            if (path.contains("jar") && path.endsWith(".zip") && !fileName.contains("jar")) {
                t = path.indexOf("jar");
            }
            if (StringUtils.isNotBlank((CharSequence)pathSign)) {
                if (path.contains(pathSign) && !path.contains(JSONTYPE)) {
                    t = path.indexOf("webapp");
                } else if (path.contains(JSONTYPE)) {
                    t = path.indexOf(pathSign);
                }
            } else if ((path.contains(CUSTOM) || path.contains(UPLOADSOURCE)) && path.endsWith(".zip") && !fileName.contains(CUSTOM) && !fileName.contains(UPLOADSOURCE)) {
                t = path.indexOf(RESOURCE);
            }
            if (t == -1) continue;
            if ((path = path.endsWith(JSONTYPE) ? path.substring(t + pathSign.length() + 1, path.length()) : path.substring(t, path.length())).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    private static void deleteKd(File file) {
        if (!file.isDirectory()) {
            boolean fileDelete = file.delete();
            if (fileDelete) {
                logger.debug(file + IS_DELETE);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    boolean isDelFile = delfile.delete();
                    if (!isDelFile) continue;
                    logger.debug(delfile + IS_DELETE);
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                DataModelUtils.deleteKd(fileList[i]);
            }
            boolean fileDelete = file.delete();
            if (fileDelete) {
                logger.debug(file + IS_DELETE);
            }
        }
    }

    public static void addLog(String id, String opName, String opDescription) {
        try {
            LogServiceHelper helper = new LogServiceHelper();
            AppLogInfo info = new AppLogInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"modelm")});
            if (bizApp != null) {
                info.setBizAppID(bizApp.getString("id"));
            }
            info.setBizObjID(id);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(RequestContext.get().getClient());
            info.setClientIP(RequestContext.get().getLoginIP());
            info.setOpName(opName);
            info.setOpDescription(opDescription);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static Map<String, Object> isContainsChineseSymbol(String content) {
        HashMap<String, Object> res = new HashMap<String, Object>(1);
        if (StringUtils.isBlank((CharSequence)content)) {
            return res;
        }
        String regex = "[\u201c\u201d\u2018\u2019]";
        Pattern compile = Pattern.compile(regex);
        boolean containsChineseSymbol = compile.matcher(content).find();
        if (containsChineseSymbol) {
            res.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u82f1\u6587\u53cc\u5f15\u53f7\u6216\u8005\u5355\u5f15\u53f7\u3002", (String)"DataModelUtils_1", (String)BOS_DATAMODEL_PLUGIN, (Object[])new Object[0]));
        }
        return res;
    }

    public static JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put(CONTENT_TYPE, APPLICATION_JSONANDCHARSET);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty(MC_SERVER_URL);
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String sHttpResponse = MCApiUtil.callMcApiService((String)"/kapi/app/mc/GetDbInstanceListService", (String)"text/json", header, params, (int)60);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger(ERRORCODE) == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (Exception e) {
                logger.error("getDbInstanceList\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        JSONArray newData = new JSONArray();
        for (Object datum : data) {
            if (((Boolean)((JSONObject)datum).get((Object)"readonly")).booleanValue()) continue;
            newData.add(datum);
        }
        return newData;
    }
}

