/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.util.List;
import java.util.Objects;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.Default;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.datamodel.pdm.validationrule.PDMIdentifierRule;

public class Column
extends PDMObject {
    private Table table;
    private String originalDataType;
    private DataType dataType;
    protected int length;
    private int precision;
    private int scale;
    private String typePrecisionText;
    private Default colDefault;
    private boolean allowNull = true;
    private boolean isComputed = false;
    private String ComputedExpression;
    private boolean persisted;
    private boolean ignoreCompareIsNull;
    private boolean ignoreCompareDefault;

    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setIgnoreCompareIsNull(boolean ignoreCompareIsNull) {
        this.ignoreCompareIsNull = ignoreCompareIsNull;
    }

    public void setIgnoreCompareDefault(boolean ignoreCompareDefault) {
        this.ignoreCompareDefault = ignoreCompareDefault;
    }

    public String getDataTypeText() {
        if (this.dataType == null) {
            return "";
        }
        switch (this.dataType) {
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case NVARCHAR: {
                return this.dataType.name() + "(" + this.length + ")";
            }
            case DECIMAL: {
                return this.dataType.name() + "(" + this.precision + "," + this.scale + ")";
            }
        }
        return this.dataType.name();
    }

    public Default getColDefault() {
        return this.colDefault;
    }

    public void setDefaultValue(String value) {
        if (this.colDefault == null) {
            this.colDefault = new Default(this.getDataType(), value);
        } else {
            this.colDefault.setValue(value);
        }
        this.colDefault.setColumn(this);
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public Column(String number) {
        if (number == null || number.trim().length() == 0) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        this.number = number;
    }

    @Override
    public List<ValidateResultItem> validate() {
        String tableStr;
        List<ValidateResultItem> resultList = super.validate();
        PDMIdentifierRule identifierRule = new PDMIdentifierRule();
        resultList.addAll(identifierRule.validate(this.getNumber()));
        String string = tableStr = this.table == null ? "" : "'" + this.table.getNumber() + "'";
        if (this.dataType == null) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u5b57\u6bb5'%s'\u672a\u6307\u5b9a\u7c7b\u578b\u3002", tableStr, this.getNumber())));
        } else {
            if (this.dataType.isCharType()) {
                if (this.length <= 0) {
                    resultList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u5b57\u6bb5'%s'\u672a\u6307\u5b9a\u957f\u5ea6\u3002", tableStr, this.getNumber())));
                }
            } else if (this.dataType != DataType.BLOB && this.dataType != DataType.CLOB && this.dataType != DataType.NCLOB) {
                if (this.dataType == DataType.DECIMAL) {
                    if (this.precision <= 0 || this.scale <= 0) {
                        resultList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u5b57\u6bb5'%s'\u672a\u6307\u5b9a\u957f\u5ea6\u4e0e\u7cbe\u5ea6\u3002", tableStr, this.getNumber())));
                    } else if (this.precision <= this.scale) {
                        resultList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u5b57\u6bb5'%s'\u6307\u5b9a\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7cbe\u5ea6\u3002", tableStr, this.getNumber())));
                    }
                    if (!this.ignoreCompareIsNull && this.allowNull) {
                        resultList.add(new ValidateResultItem(MessageType.Warn, String.format("%s\u6570\u503c\u578b\u5b57\u6bb5'%s'\u5e94\u8be5\u5b9a\u4e49\u975e\u7a7a\uff0c\u5e76\u4e14\u6307\u5b9a\u9ed8\u8ba4\u503c\u3002", tableStr, this.getNumber())));
                    }
                } else if (this.dataType.isIntegerType() && !this.ignoreCompareIsNull && this.allowNull) {
                    resultList.add(new ValidateResultItem(this.getErrorLevel(MessageType.Error), String.format("%s\u6574\u578b\u5b57\u6bb5'%s'\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u5e76\u4e14\u5fc5\u987b\u6307\u5b9a\u9ed8\u8ba4\u503c\u3002", tableStr, this.getNumber())));
                }
            }
            if (!this.allowNull) {
                if (this.dataType == DataType.BLOB || this.dataType == DataType.CLOB || this.dataType == DataType.NCLOB) {
                    if (!this.ignoreCompareIsNull) {
                        resultList.add(new ValidateResultItem(this.getErrorLevel(MessageType.Error), String.format("%s\u5927\u5bf9\u8c61\u5b57\u6bb5'%s'\u4e0d\u5141\u8bb8\u975e\u7a7a\u3002", tableStr, this.getNumber())));
                    }
                } else if (!this.ignoreCompareDefault && (this.colDefault == null || this.colDefault.getValue() == null || this.colDefault.getValue().isEmpty())) {
                    resultList.add(new ValidateResultItem(this.getErrorLevel(MessageType.Error), String.format("%s\u975e\u7a7a\u5b57\u6bb5'%s'\u5fc5\u987b\u6307\u5b9a\u9ed8\u8ba4\u503c\u3002", tableStr, this.getNumber())));
                }
            }
        }
        if (!this.ignoreCompareDefault && this.colDefault != null && this.colDefault.getValue() != null && !this.colDefault.getValue().isEmpty()) {
            resultList.addAll(this.colDefault.validate());
        }
        return resultList;
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Column column = (Column)obj;
        boolean bl = isEqual = this.number.equals(column.number) && this.dataType == column.dataType;
        if (this.dataType.isCharType()) {
            isEqual = isEqual && this.length == column.length;
        } else if (this.dataType == DataType.DECIMAL) {
            boolean bl2 = isEqual = isEqual && this.precision == column.precision && this.scale == column.scale;
        }
        if (!this.ignoreCompareIsNull) {
            boolean bl3 = isEqual = isEqual && this.allowNull == column.allowNull;
        }
        if (!this.ignoreCompareDefault) {
            isEqual = isEqual && Objects.equals(this.colDefault, column.colDefault);
        }
        return isEqual;
    }

    @Override
    public String toString() {
        String type = this.getDataTypeText();
        String def = this.colDefault == null ? "" : this.colDefault.toString();
        String isNull = this.allowNull ? "" : "NOT NULL";
        return String.format("%s %s %s %s", this.number, type, def, isNull);
    }
}

