/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public enum DataType {
    CHAR(0),
    VARCHAR(1),
    NCHAR(2),
    NVARCHAR(3),
    BLOB(6),
    CLOB(7),
    NCLOB(8),
    INT(9),
    SMALLINT(10),
    BIGINT(11),
    DATETIME(12),
    DECIMAL(14),
    XMLTYPE(15);

    private short nCode;

    private DataType(int _nCode) {
        this.nCode = (short)_nCode;
    }

    public short getValue() {
        return this.nCode;
    }

    public static DataType valueOf(short value) {
        for (DataType item : DataType.values()) {
            if (item.getValue() != value) continue;
            return item;
        }
        throw new KDException(BosErrorCode.variableNotValid, new Object[]{String.format("Can't convert the %d to DataType.", value)});
    }

    public static DataType valueOf(int value) {
        return DataType.valueOf((short)value);
    }

    public static DataType valueOfName(String name) {
        for (DataType item : DataType.values()) {
            if (!item.name().equalsIgnoreCase(name)) continue;
            return item;
        }
        throw new KDException(BosErrorCode.variableNotValid, new Object[]{String.format("Can't convert the %s to DataType.", name)});
    }

    public boolean isCharType() {
        return this.nCode == 0 || this.nCode == 1 || this.nCode == 2 || this.nCode == 3;
    }

    public boolean isCharOrTextType() {
        return this.nCode == 0 || this.nCode == 1 || this.nCode == 2 || this.nCode == 3 || this.nCode == 7 || this.nCode == 8;
    }

    public boolean isIntegerType() {
        return this.nCode == 9 || this.nCode == 10 || this.nCode == 11;
    }

    public static DataType fromSqlType(int sqlType) {
        switch (sqlType) {
            case 1: {
                return CHAR;
            }
            case 12: {
                return VARCHAR;
            }
            case -15: {
                return NCHAR;
            }
            case -9: {
                return NVARCHAR;
            }
            case -2: 
            case 2004: {
                return BLOB;
            }
            case 2005: {
                return CLOB;
            }
            case 2011: {
                return NCLOB;
            }
            case 4: {
                return INT;
            }
            case 5: {
                return SMALLINT;
            }
            case -5: 
            case 93: {
                return BIGINT;
            }
            case 91: {
                return DATETIME;
            }
            case 2: 
            case 3: {
                return DECIMAL;
            }
            case 2009: {
                return XMLTYPE;
            }
        }
        throw new KDException(BosErrorCode.canNotCast, new Object[]{"Unsupported sqlType:" + sqlType});
    }

    public static int toSqlType(DataType type) {
        switch (type.nCode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return -15;
            }
            case 3: {
                return -9;
            }
            case 6: {
                return 2004;
            }
            case 7: {
                return 2005;
            }
            case 8: {
                return 2011;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return -5;
            }
            case 12: {
                return 91;
            }
            case 14: {
                return 3;
            }
            case 15: {
                return 2009;
            }
        }
        return 1111;
    }

    public String getDataType(int dbType) {
        return kd.bos.ksql.datatype.DataType.getDataType((int)dbType).nativeType(this.name());
    }
}

