/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.PDMObject;

public class Default
extends PDMObject {
    private DataType type;
    private String value;
    private String originalValue;
    private Column column;

    public String getValue() {
        return this.value;
    }

    final void setValue(String value) {
        this.originalValue = value;
        this.value = this.type == DataType.DATETIME && value != null && value.trim().length() != 0 ? ("getdate()".equalsIgnoreCase(value) ? "GETDATE()" : String.format("{ts'%s'}", value)) : (this.type == DataType.VARCHAR && "newid()".equalsIgnoreCase(value) ? "NEWID()" : ((this.type == DataType.CHAR || this.type == DataType.NCHAR || this.type == DataType.NVARCHAR || this.type == DataType.VARCHAR) && "''".equals(value) ? "' '" : value));
    }

    void setColumn(Column column) {
        this.column = column;
    }

    public Default(DataType type, String value) {
        this.type = type;
        this.setValue(value);
    }

    @Override
    public List<ValidateResultItem> validate() {
        String colNumber;
        String string = colNumber = this.column == null ? "" : this.column.getNumber();
        String tableName = this.column == null ? "" : (this.column.getTable() == null ? "" : "'" + this.column.getTable().getNumber() + "'");
        ArrayList<ValidateResultItem> resultItemList = new ArrayList<ValidateResultItem>();
        if (this.type.isCharType()) {
            if ("''".equals(this.value)) {
                resultItemList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u5b57\u7b26\u7c7b\u578b\u5b57\u6bb5'%s'\u9ed8\u8ba4\u503c\u4e0d\u80fd\u4e3a\u7a7a\u4e32\u3002", tableName, colNumber)));
            } else if (this.value != null && !this.value.startsWith("'")) {
                resultItemList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u5b57\u7b26\u7c7b\u578b\u5b57\u6bb5'%s'\u9ed8\u8ba4\u503c\u4f7f\u7528\u5f15\u53f7'%s'\u3002", tableName, colNumber, this.value)));
            }
        }
        if (this.type == DataType.DECIMAL && this.getValue() != null && !this.getValue().isEmpty() && !Default.isNumeric(this.getValue())) {
            resultItemList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u6570\u503c\u7c7b\u578b\u5b57\u6bb5'%s'\u9ed8\u8ba4\u503c\u5fc5\u987b\u4e3a\u6570\u503c\u3002", tableName, colNumber)));
        }
        if (this.type == DataType.DATETIME && !"getdate()".equalsIgnoreCase(this.value)) {
            String v = this.originalValue;
            try {
                if (v.contains("'")) {
                    v = v.replaceAll("'", "");
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                format.parse(v);
            }
            catch (ParseException | DateTimeParseException e) {
                resultItemList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u65e5\u671f\u7c7b\u578b\u5b57\u6bb5'%s'\u9ed8\u8ba4\u503c\u5fc5\u987b\u4e3a\u6709\u6548\u65e5\u671f\u3002", tableName, colNumber)));
            }
        }
        if ((this.type == DataType.BLOB || this.type == DataType.CLOB || this.type == DataType.NCLOB) && this.value != null) {
            resultItemList.add(new ValidateResultItem(MessageType.Warn, String.format("%s\u5927\u5bf9\u8c61\u7c7b\u578b\u5b57\u6bb5'%s'\u4e0d\u5e94\u8be5\u6709\u9ed8\u8ba4\u503c\u3002", tableName, colNumber)));
        }
        if (this.type.isIntegerType() && this.getValue() != null && !this.getValue().isEmpty() && !Default.isInteger(this.getValue())) {
            resultItemList.add(new ValidateResultItem(MessageType.Error, String.format("%s\u6574\u6570\u7c7b\u578b\u5b57\u6bb5'%s'\u9ed8\u8ba4\u503c\u5fc5\u987b\u4e3a\u6574\u6570\u3002", tableName, colNumber)));
        }
        resultItemList.addAll(super.validate());
        return resultItemList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Default def = (Default)obj;
        return this.value.equals(def.value);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return "DEFAULT " + this.value;
    }

    private static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[0-9]+[\\.]?[0-9]*$");
        return pattern.matcher(str).matches();
    }
}

