/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.datamodel.pdm.validationrule.PDMIdentifierRule;

public class Index
extends PDMObject {
    private boolean isUnique;
    private boolean isCluster;
    private List<String> colNumbers = new ArrayList<String>(8);
    private List<String> descCols = new ArrayList<String>(8);
    private Table table;
    private String tableNumber;

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public void setCluster(boolean cluster) {
        this.isCluster = cluster;
    }

    public List<String> getColNumbers() {
        return this.colNumbers;
    }

    public List<String> getColDescs() {
        return Collections.unmodifiableList(this.descCols);
    }

    public Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
        this.tableNumber = table.getNumber();
    }

    String getTabNumber() {
        return this.table == null ? "" : this.table.getNumber();
    }

    public Index(String idxNumber) {
        this.number = idxNumber;
    }

    public void addColumn(String colNumber, boolean isAsc) {
        this.colNumbers.remove(colNumber.toLowerCase());
        this.colNumbers.add(colNumber.toLowerCase());
        if (!isAsc) {
            this.descCols.remove(colNumber.toLowerCase());
            this.descCols.add(colNumber.toLowerCase());
        }
    }

    @Override
    public List<ValidateResultItem> validate() {
        PDMIdentifierRule identifierRule = new PDMIdentifierRule();
        List<ValidateResultItem> resultItemList = identifierRule.validate(this.getNumber());
        if (this.colNumbers.isEmpty()) {
            resultItemList.add(new ValidateResultItem(MessageType.Error, String.format("\u7d22\u5f15%s\u7684\u5217\u672a\u5b9a\u4e49\u3002", this.getNumber())));
        }
        resultItemList.addAll(super.validate());
        return resultItemList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Index index = (Index)obj;
        return this.getTabNumber().equals(index.getTabNumber()) && this.number.equals(index.number) && this.isCluster == index.isCluster() && this.isUnique == index.isUnique() && this.colNumbers.equals(index.colNumbers) && this.descCols.equals(index.descCols);
    }

    @Override
    public String toString() {
        StringBuilder cols = new StringBuilder();
        cols.append(this.colNumbers.get(0));
        for (String col : this.descCols) {
            if (!col.equals(this.colNumbers.get(0))) continue;
            cols.append(" DESC");
            break;
        }
        block1: for (int i = 1; i < this.colNumbers.size(); ++i) {
            String colnumber = this.colNumbers.get(i);
            cols.append(",").append(colnumber);
            for (String col : this.descCols) {
                if (!col.equals(colnumber)) continue;
                cols.append(" DESC");
                continue block1;
            }
        }
        return String.format("%s ON %s (%s)", this.number, this.getTabNumber(), cols.toString());
    }
}

