/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.IValidateResult;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResult;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.Default;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.JSONUtils;

public class PDMValidator {
    private MessageType noModifiedErrorLevel;
    private List<RuleConfig> innerRuleConfigList = new ArrayList<RuleConfig>();
    private List<RuleConfig> dynamicRuleConfigList = new ArrayList<RuleConfig>();
    private static List<RuleConfig> outerRuleConfigList = new ArrayList<RuleConfig>(10);

    public void setNoModifiedErrorLevel(MessageType noModifiedErrorLevel) {
        this.noModifiedErrorLevel = noModifiedErrorLevel;
    }

    public void addRule(String pdmObjectName, String validateRuleClassName) throws ClassNotFoundException {
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setRuleClass(validateRuleClassName);
        ruleConfig.setValidateTypeClass(pdmObjectName);
        ruleConfig.exclude = new ArrayList();
        ruleConfig.params = new HashMap<String, String>();
        this.dynamicRuleConfigList.add(ruleConfig);
    }

    public List<IValidateResult> validate(List<PDMObject> pdmObjectList) {
        ArrayList<IValidateResult> validateResults = new ArrayList<IValidateResult>(pdmObjectList.size());
        for (PDMObject object : pdmObjectList) {
            this.initPDMValidateRule(object);
            object.setNoModifiedErrorLevel(this.noModifiedErrorLevel);
            List<ValidateResultItem> resultList = object.validate();
            ValidateResult result = new ValidateResult();
            result.setObjectId(object.getName());
            result.addValidateResultItem(resultList);
            validateResults.add(result);
        }
        return validateResults;
    }

    private void initPDMValidateRule(PDMObject object) {
        Default colDefault;
        if (object instanceof Table) {
            for (Column col : ((Table)object).getColumns()) {
                this.initPDMValidateRule(col);
            }
            for (Index idx : ((Table)object).getIndexes()) {
                this.initPDMValidateRule(idx);
            }
        } else if (object instanceof Column && (colDefault = ((Column)object).getColDefault()) != null) {
            this.initPDMValidateRule(colDefault);
        }
        ArrayList<RuleConfig> configList = new ArrayList<RuleConfig>();
        configList.addAll(this.innerRuleConfigList);
        configList.addAll(outerRuleConfigList);
        configList.addAll(this.dynamicRuleConfigList);
        for (RuleConfig ruleConfig : configList) {
            ValidateRule rule;
            if (ruleConfig.validateTypeClass != object.getClass() || this.isExcludeRule(ruleConfig.exclude, object)) continue;
            try {
                rule = (ValidateRule)ruleConfig.ruleClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"PDMValidator initPDMValidateRule error: load " + ruleConfig.ruleClass.getName() + " error."});
            }
            rule.setRuleParameter(ruleConfig.params);
            object.addValidateRule(rule);
        }
    }

    private boolean isExcludeRule(List<String> excludeObjects, PDMObject object) {
        if (excludeObjects == null || excludeObjects.isEmpty()) {
            return false;
        }
        return excludeObjects.contains(object.getNumber().toLowerCase());
    }

    private static List<RuleConfig> getDynamicRule() {
        List paramList;
        String ruleConfig = null;
        try (InputStream in = PDMValidator.class.getResourceAsStream("/validaterule.json");){
            int size;
            InputStreamReader ir = new InputStreamReader(in);
            char[] buf = new char[1024];
            StringBuilder sb = new StringBuilder();
            while ((size = ir.read(buf)) != -1) {
                sb.append(buf, 0, size);
            }
            ruleConfig = sb.toString();
            ir.close();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"PDMValidator load validaterule.json error: Can't load validaterule.json"});
        }
        if (ruleConfig == null || ruleConfig.trim().length() == 0) {
            return new ArrayList<RuleConfig>();
        }
        try {
            paramList = (List)JSONUtils.cast((String)ruleConfig, List.class);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"PDMValidator load validaterule.json error: jsoin convert eror."});
        }
        if (paramList == null || paramList.isEmpty()) {
            return new ArrayList<RuleConfig>();
        }
        ArrayList<RuleConfig> ruleConfigList = new ArrayList<RuleConfig>(10);
        for (Map map : paramList) {
            RuleConfig rule = new RuleConfig();
            rule.setRuleClass((String)map.get("rule"));
            rule.setValidateTypeClass((String)map.get("type"));
            rule.exclude = (List)map.get("exclude");
            rule.params = (Map)map.get("param");
            ruleConfigList.add(rule);
        }
        return ruleConfigList;
    }

    static {
        outerRuleConfigList = PDMValidator.getDynamicRule();
    }

    private static class RuleConfig {
        Class ruleClass;
        Class validateTypeClass;
        List exclude;
        Map<String, String> params;

        private RuleConfig() {
        }

        void setRuleClass(String ruleClassName) {
            try {
                this.ruleClass = Class.forName(ruleClassName);
            }
            catch (ClassNotFoundException e) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"PDMValidator load " + ruleClassName + " error: ClassNotFoundException."});
            }
        }

        void setValidateTypeClass(String validateType) {
            switch (validateType) {
                case "Table": {
                    this.validateTypeClass = Table.class;
                    break;
                }
                case "Column": {
                    this.validateTypeClass = Column.class;
                    break;
                }
                case "Index": {
                    this.validateTypeClass = Index.class;
                    break;
                }
                case "PrimaryKey": {
                    this.validateTypeClass = PrimaryKey.class;
                    break;
                }
                case "Default": {
                    this.validateTypeClass = Default.class;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid ValidateRule type.");
                }
            }
        }
    }
}

