/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.datamodel.DMObject;
import kd.bos.datamodel.DataModel;
import kd.bos.datamodel.Package;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.model.validator.Validator;
import kd.bos.datamodel.pdm.model.Table;

public class PDModel
extends DataModel
implements Validator {
    private List<Table> tables;

    public List<Table> getTables() {
        if (this.tables == null) {
            ArrayList<Table> tempTables = new ArrayList<Table>(10);
            for (DMObject dmObject : this.getItems()) {
                tempTables.addAll(this.fetchTable(dmObject));
            }
            this.tables = tempTables;
        }
        return this.tables;
    }

    public void addPackage(Package pdmPackage) {
        this.getItems().add(pdmPackage);
    }

    @Override
    public void addValidateRule(ValidateRule rule) {
    }

    @Override
    public List<ValidateResultItem> validate() {
        ArrayList<ValidateResultItem> validateItemList = new ArrayList<ValidateResultItem>(1);
        for (DMObject dmObject : this.getItems()) {
            if (!(dmObject instanceof Table)) continue;
            ValidateResultItem item = new ValidateResultItem(MessageType.Error, String.format("\u8868\uff08%s\uff09\u6ca1\u6709\u5f52\u5c5e\u5230\u5305\uff0c\u8868\u5fc5\u987b\u5b9a\u4e49\u5728\u5305\u5185\u3002", dmObject.getName()));
            validateItemList.add(item);
        }
        return validateItemList;
    }

    private List<Table> fetchTable(DMObject dmObject) {
        ArrayList<Table> tableList = new ArrayList<Table>(10);
        if (dmObject instanceof Package) {
            for (DMObject object : ((Package)dmObject).getItem()) {
                tableList.addAll(this.fetchTable(object));
            }
        } else if (dmObject instanceof Table) {
            tableList.add((Table)dmObject);
        }
        return tableList;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

