/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidationException;
import kd.bos.datamodel.pdm.model.ConstraintType;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.datamodel.pdm.validationrule.PDMIdentifierRule;

public class PrimaryKey
extends PDMObject {
    private List<String> colNumbers = new ArrayList<String>();
    private boolean isCluster;
    private ConstraintType consType = ConstraintType.PRIMARY_KEY;
    private String tableNumber;
    private boolean ignoreCompareCluster;
    private Table table;

    public List<String> getColNumbers() {
        return this.colNumbers;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public void setCluster(boolean cluster) {
        this.isCluster = cluster;
    }

    public ConstraintType getConsType() {
        return this.consType;
    }

    public void setIgnoreCompareCluster(boolean ignoreCompareCluster) {
        this.ignoreCompareCluster = ignoreCompareCluster;
    }

    void setTable(Table table) {
        this.table = table;
        this.tableNumber = table.getNumber();
    }

    public PrimaryKey(String pkNumber) {
        if (pkNumber == null || pkNumber.trim().length() < 1) {
            throw new ValidationException("\u672a\u5b9a\u4e49\u4e3b\u952e\u540d\u3002");
        }
        this.number = pkNumber;
    }

    public void addCol(String colNumber) {
        this.colNumbers.add(colNumber);
    }

    public int getColumnCount() {
        return this.colNumbers.size();
    }

    @Override
    public List<ValidateResultItem> validate() {
        PDMIdentifierRule identifierRule = new PDMIdentifierRule();
        List<ValidateResultItem> resultList = identifierRule.validate(this.getNumber());
        if (this.colNumbers.isEmpty()) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("Table'%s'\u7684\u4e3b\u952e'%s'\u672a\u6307\u5b9a\u5b57\u6bb5\u3002", this.tableNumber, this.number)));
        }
        String pkSuffix = this.tableNumber.substring(2).toUpperCase();
        String pkNumber = this.number.toUpperCase(Locale.ENGLISH);
        if (!pkNumber.startsWith("PK_") || !pkNumber.endsWith(pkSuffix)) {
            resultList.add(new ValidateResultItem(this.getErrorLevel(MessageType.Error), String.format("Table'%s'\u7684\u4e3b\u952e'%s'\u547d\u540d\u4e0d\u89c4\u8303\uff0c\u5e94\u4e3aPK_%s\u3002", this.tableNumber, this.number, pkSuffix)));
        }
        resultList.addAll(super.validate());
        return resultList;
    }

    @Override
    public String toString() {
        String pkcols = String.join((CharSequence)",", this.colNumbers);
        return String.format("CONSTRAINT %s PRIMARY KEY (%s)", this.getNumber(), pkcols);
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrimaryKey pk = (PrimaryKey)obj;
        boolean bl = isEqual = this.number.equals(pk.number) && this.consType == pk.consType && this.colNumbers.equals(pk.colNumbers);
        if (!this.ignoreCompareCluster) {
            isEqual = isEqual && this.isCluster == pk.isCluster;
        }
        return isEqual;
    }
}

