/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.validationrule.PDMIdentifierRule;

public class Table
extends PDMObject {
    private List<Column> columns = new ArrayList<Column>(10);
    private PrimaryKey primaryKey;
    private List<Index> indexes = new ArrayList<Index>(5);

    public final List<Column> getColumns() {
        return this.columns;
    }

    public void addColumn(Column col) {
        for (Column column : this.columns) {
            if (!column.getNumber().equalsIgnoreCase(col.getNumber())) continue;
            throw new RuntimeException("\u5b57\u6bb5\u540d\u91cd\u590d\u3002");
        }
        col.setTable(this);
        this.columns.add(col);
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        this.primaryKey.setTable(this);
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void addIndex(Index ind) {
        if (ind.getNumber() == null || ind.getNumber().trim().length() == 0) {
            throw new RuntimeException("\u7d22\u5f15\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (ind.isCluster() && this.primaryKey != null && this.primaryKey.isCluster()) {
            throw new RuntimeException("\u4e3b\u952e\u4e3a\u805a\u96c6\uff0c\u7d22\u5f15\u4e0d\u5141\u8bb8\u6307\u5b9a\u4e3a\u805a\u96c6\u3002");
        }
        for (Index index : this.indexes) {
            if (!index.getNumber().equalsIgnoreCase(ind.getNumber())) continue;
            throw new RuntimeException("\u7d22\u5f15\u540d\u91cd\u590d\u3002");
        }
        ind.setTable(this);
        this.indexes.add(ind);
    }

    public boolean hasCluster() {
        if (this.primaryKey != null && this.primaryKey.isCluster()) {
            return true;
        }
        for (Index item : this.indexes) {
            if (!item.isCluster()) continue;
            return true;
        }
        return false;
    }

    public Table(String number) {
        if (number == null || number.trim().length() == 0) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u8868\u540d\u3002");
        }
        this.number = number;
    }

    @Override
    public List<ValidateResultItem> validate() {
        PDMIdentifierRule tableNameRule = new PDMIdentifierRule();
        List<ValidateResultItem> resultList = tableNameRule.validate(this.getNumber());
        if (this.getColumns().isEmpty()) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u8868'%s'\u672a\u5b9a\u4e49\u5b57\u6bb5\u3002", this.getNumber())));
        }
        for (Column col : this.getColumns()) {
            resultList.addAll(col.validate());
        }
        this.validatePK(resultList);
        this.validateIndex(resultList);
        resultList.addAll(super.validate());
        return resultList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Table table = (Table)obj;
        return this.number.equals(table.number) && this.primaryKey.equals(table.primaryKey) && this.columns.equals(table.columns) && this.indexes.equals(table.indexes);
    }

    private void validatePK(List<ValidateResultItem> resultList) {
        if (this.primaryKey == null) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u8868'%s'\u672a\u6307\u5b9a\u4e3b\u952e\u3002", this.getNumber())));
        } else {
            resultList.addAll(this.primaryKey.validate());
        }
    }

    private void validateIndex(List<ValidateResultItem> resultList) {
        if (!this.hasCluster()) {
            resultList.add(new ValidateResultItem(this.getErrorLevel(MessageType.Error), String.format("\u8868'%s'\u672a\u6307\u5b9a\u805a\u96c6\u7d22\u5f15\u3002", this.getNumber())));
        }
        ArrayList<String> idxes = new ArrayList<String>(this.indexes.size());
        if (this.indexes.isEmpty()) {
            resultList.add(new ValidateResultItem(MessageType.Warn, String.format("\u8868'%s'\u672a\u6307\u5b9a\u7d22\u5f15\u3002", this.getNumber())));
            return;
        }
        for (Index idx : this.indexes) {
            if (idx.isCluster() && this.primaryKey != null && this.primaryKey.isCluster()) {
                resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u8868'%s'\u7684\u4e3b\u952e\u4e3a\u805a\u96c6\uff0c\u7d22\u5f15'%s'\u4e0d\u5141\u8bb8\u5b9a\u4e49\u4e3a\u805a\u96c6\u3002", this.getNumber(), idx.getNumber())));
            }
            if (this.getPrimaryKey() != null && idx.getNumber().equals(this.getPrimaryKey().getNumber())) {
                resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u8868'%s'\u7684\u7d22\u5f15\u540d'%s'\u4e0e\u4e3b\u952e\u540d\u51b2\u7a81\u3002", this.getNumber(), idx.getNumber())));
            }
            if (idxes.contains(idx.getNumber())) {
                resultList.add(new ValidateResultItem(this.getErrorLevel(MessageType.Error), String.format("\u8868'%s'\u6709\u91cd\u590d\u7d22\u5f15'%s'\u3002", this.getNumber(), idx.getNumber())));
            } else {
                idxes.add(idx.getNumber());
            }
            resultList.addAll(idx.validate());
        }
    }
}

