/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.sqlscript;

import java.util.Locale;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.datamodel.pdm.sqlscript.ScriptGenerator;

class KSQLGenerator
implements ScriptGenerator {
    boolean outComment = false;

    KSQLGenerator() {
    }

    @Override
    public String createTableSql(Table table) {
        StringBuilder sb = new StringBuilder();
        String tableName = table.getNumber() == null ? null : table.getNumber().toUpperCase(Locale.ENGLISH);
        sb.append(String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') ", tableName));
        sb.append(System.lineSeparator());
        sb.append(String.format(" CREATE TABLE %s (", tableName));
        for (Column column : table.getColumns()) {
            sb.append(System.lineSeparator());
            sb.append(this.createColumnSql(column));
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(System.lineSeparator());
        sb.append(");");
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    @Override
    public String addColumnSql(String tableNnumber, Column column) {
        StringBuilder sb = new StringBuilder();
        tableNnumber = tableNnumber == null ? null : tableNnumber.toUpperCase(Locale.ENGLISH);
        String columnNumber = column.getNumber() == null ? null : column.getNumber().toUpperCase(Locale.ENGLISH);
        sb.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '").append(tableNnumber).append("' AND KSQL_COL_NAME ='").append(columnNumber).append("') ");
        sb.append(System.lineSeparator());
        sb.append(" ALTER TABLE ").append(tableNnumber).append(" ADD (");
        sb.append(this.createColumnSql(column)).append(" );");
        return sb.toString();
    }

    String createColumnSql(Column column) {
        String val;
        StringBuilder sb = new StringBuilder();
        String columnNumber = column.getNumber() == null ? null : column.getNumber().toUpperCase(Locale.ENGLISH);
        sb.append(columnNumber).append(" ");
        sb.append(column.getDataType().name());
        switch (column.getDataType()) {
            case DECIMAL: {
                sb.append("(");
                sb.append(column.getPrecision());
                sb.append(",").append(column.getScale()).append(")");
                break;
            }
            case NVARCHAR: 
            case VARCHAR: 
            case NCHAR: 
            case CHAR: {
                sb.append("(").append(column.getLength()).append(")");
            }
        }
        if (column.getColDefault() != null && (val = column.getColDefault().getValue()) != null && val.trim().length() > 0) {
            sb.append(" DEFAULT ").append(column.getColDefault().getValue());
        }
        if (!column.isAllowNull()) {
            sb.append(" NOT NULL");
        }
        if (this.outComment && column.getComment() != null && column.getComment().trim().length() > 0) {
            sb.append(" COMMENT '").append(column.getComment()).append("'");
        }
        return sb.toString();
    }

    @Override
    public String createConstraintSql(Table table) {
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && pk.getColNumbers().size() > 0) {
            StringBuilder sql = new StringBuilder();
            String pkNumber = pk.getNumber() == null ? null : pk.getNumber().toUpperCase(Locale.ENGLISH);
            sql.append("IF NOT EXISTS (SELECT 1 FROM KSQL_CONSTRAINTS WHERE KSQL_CONS_NAME = '").append(pkNumber).append("')");
            sql.append(System.lineSeparator());
            sql.append(" ALTER TABLE ").append(table.getNumber().toUpperCase(Locale.ENGLISH)).append(" ADD CONSTRAINT ").append(pkNumber).append(" ").append(pk.getConsType().name());
            if (pk.isCluster()) {
                sql.append(" CLUSTERED ");
            }
            sql.append("(");
            for (int i = 0; i < pk.getColNumbers().size(); ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append(pk.getColNumbers().get(i).toUpperCase(Locale.ENGLISH));
            }
            sql.append(")").append(System.lineSeparator());
            return sql.toString();
        }
        return "";
    }

    @Override
    public String createIndexesSql(Table table) {
        StringBuilder sIndexes = new StringBuilder();
        for (Index item : table.getIndexes()) {
            sIndexes.append(this.createIndexSql(item));
            sIndexes.append(System.lineSeparator());
        }
        return sIndexes.toString();
    }

    @Override
    public String createIndexSql(Index idx) {
        StringBuilder idxStr = new StringBuilder();
        if (idx.getNumber() != null && idx.getTable() != null && idx.getColNumbers().size() > 0) {
            String indexNumber;
            String tableNumber = idx.getTable().getNumber() == null ? null : idx.getTable().getNumber().toUpperCase(Locale.ENGLISH);
            String string = indexNumber = idx.getNumber() == null ? null : idx.getNumber().toUpperCase(Locale.ENGLISH);
            if (tableNumber == null || tableNumber.trim().isEmpty()) {
                throw new RuntimeException("\u7d22\u5f15\u7684\u8868\u540d\u4e3a\u7a7a(inx.getTable().getNumber())\u3002");
            }
            idxStr.append(" IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = '").append(tableNumber).append("' AND KSQL_INDNAME = '").append(indexNumber).append("')").append(System.lineSeparator());
            idxStr.append(" CREATE ");
            if (idx.isUnique()) {
                idxStr.append("UNIQUE ");
            }
            if (idx.isCluster()) {
                idxStr.append(" CLUSTERED ");
            }
            idxStr.append("INDEX ").append(indexNumber).append(" ON ").append(tableNumber).append(" (");
            for (String col : idx.getColNumbers()) {
                idxStr.append(col.toUpperCase(Locale.ENGLISH));
                idxStr.append(" ");
                if (idx.getColDescs().contains(col)) {
                    idxStr.append(" DESC ");
                }
                idxStr.append(",");
            }
            idxStr.setLength(idxStr.length() - 1);
            idxStr.append(");").append(System.lineSeparator());
        }
        return idxStr.toString();
    }
}

