/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PDModel;
import kd.bos.datamodel.pdm.model.PrimaryKey;
import kd.bos.datamodel.pdm.model.Table;
import kd.bos.datamodel.pdm.sqlscript.ScriptGenerator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class PDMCompare {
    private static Log logger = LogFactory.getLog(PDMCompare.class);
    private StringBuilder alterScript;
    private StringBuilder constraintScript;
    private StringBuilder infoLog;
    private StringBuilder warnLog;
    private boolean isOutDropSql;
    private boolean isOutAlterPKSql;
    private static Map<String, ModifyPDMObject> modifyObjectMap = null;
    private boolean ignoreCompareCluster;
    private boolean ignoreCompareIsNull;
    private boolean ignoreCompareDefault;

    public void setOutDropSql(boolean isOutDropSql) {
        this.isOutDropSql = isOutDropSql;
    }

    public Map<String, String> getSqlScript() {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("table", this.alterScript.toString());
        sqlMap.put("constraint", this.constraintScript.toString());
        return sqlMap;
    }

    public Map<String, String> getLog() {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("warn", this.warnLog.toString());
        sqlMap.put("info", this.infoLog.toString());
        return sqlMap;
    }

    public boolean compare(PDModel currObj, PDModel oldObj) throws Exception {
        this.reset();
        ScriptGenerator scriptGenerator = ScriptGenerator.createScriptGenerator();
        boolean isDifferent = false;
        this.appendLine(this.infoLog, String.format("\u6a21\u578b%s\u548c\u6a21\u578b%s\u5f00\u59cb\u6bd4\u8f83 - %s\uff1a", currObj.getName(), oldObj.getName(), this.getCurrDateString()));
        Map<String, ModifyPDMObject> modifyObjectMap = PDMCompare.getModifyObjectName();
        HashMap<String, Table> oldTabMap = new HashMap<String, Table>(20);
        for (Table oldTable : oldObj.getTables()) {
            oldTabMap.put(oldTable.getNumber(), oldTable);
        }
        for (Table tab : currObj.getTables()) {
            Table oldTable;
            String tableNumber = tab.getNumber();
            ModifyPDMObject modifyObj = modifyObjectMap.get(tableNumber);
            HashMap<String, String> modifyColumnMap = new HashMap(8);
            if (modifyObj != null) {
                if (modifyObj.getOldTableNumber() != null && modifyObj.IsModifyTableNumber()) {
                    tableNumber = modifyObj.oldTableNumber;
                }
                modifyColumnMap = modifyObj.getColumns();
            }
            if ((oldTable = (Table)oldTabMap.get(tableNumber)) != null) {
                oldTabMap.remove(tableNumber);
                if (this.compareTable(tab, oldTable, modifyColumnMap)) continue;
                isDifferent = true;
                continue;
            }
            this.appendLine(this.alterScript, scriptGenerator.createTableSql(tab));
            this.appendLine(this.constraintScript, scriptGenerator.createConstraintSql(tab));
            this.appendLine(this.constraintScript, scriptGenerator.createIndexesSql(tab));
            isDifferent = true;
        }
        for (Table tab : oldTabMap.values()) {
            if (this.isOutDropSql) {
                this.appendLine(this.alterScript, "DROP TABLE " + tab.getNumber().toUpperCase(Locale.ENGLISH) + ";");
                continue;
            }
            this.appendLine(this.alterScript, " --- drop TABLE --------- \u4e0d\u5141\u8bb8\u5220\u9664\u8868" + tab.getNumber() + "\uff0c\u8bf7\u6062\u590dpdm ------------------- ");
        }
        this.appendLine(this.infoLog, String.format("\u6a21\u578b%s\u548c\u6a21\u578b%s\u6bd4\u8f83\u5b8c\u6210 - %s\u3002", currObj.getNumber(), oldObj.getNumber(), this.getCurrDateString()));
        return isDifferent;
    }

    private boolean compareTable(Table currTab, Table oldTab, Map<String, String> dictModifyColumns) throws Exception {
        boolean isDifferent;
        String oldTableNumber;
        boolean isAdd = false;
        boolean isAlter = false;
        String currTableNumber = currTab.getNumber().toUpperCase(Locale.ENGLISH);
        if (!currTableNumber.equals(oldTableNumber = oldTab.getNumber().toUpperCase(Locale.ENGLISH))) {
            this.appendLine(this.alterScript, String.format("EXEC p_ModifyObjectName '%s', '%s', '%s', 'OBJECT', '';", oldTableNumber, oldTableNumber, currTableNumber));
        }
        Map<String, Column> dropColMap = this.toColumnDictMap(oldTab.getColumns());
        HashMap<String, Column> addColMap = new HashMap<String, Column>();
        ScriptGenerator scriptGenerator = ScriptGenerator.createScriptGenerator();
        for (Column col : currTab.getColumns()) {
            String isModify;
            String isNull;
            String colDef;
            String colNumber = dictModifyColumns.get(col.getNumber());
            if (colNumber != null) {
                this.alterScript.append("EXEC p_ModifyObjectName '").append(currTableNumber).append("', '").append(colNumber.toUpperCase(Locale.ENGLISH)).append("', '").append(col.getNumber().toUpperCase(Locale.ENGLISH)).append("', 'COLUMN', '").append(this.columnPropertyScript(col)).append("';").append(System.lineSeparator());
            } else {
                colNumber = col.getNumber();
            }
            Column objCol = dropColMap.get(colNumber);
            if (objCol == null) {
                addColMap.put(colNumber, col);
                continue;
            }
            dropColMap.remove(colNumber);
            col.setIgnoreCompareIsNull(this.ignoreCompareIsNull);
            col.setIgnoreCompareDefault(this.ignoreCompareDefault);
            if (col.equals(objCol)) continue;
            isDifferent = true;
            String string = colDef = col.getColDefault() == null ? "NULL" : col.getColDefault().getValue();
            if ("".equals(colDef)) {
                colDef = "NULL";
            }
            colDef = colDef.replace("'", "''");
            String string2 = isNull = col.isAllowNull() ? "NULL" : "NOT NULL";
            if (col.getDataType() != objCol.getDataType()) {
                isModify = "1111";
            } else {
                isModify = "00";
                if (col.getLength() != objCol.getLength() || col.getPrecision() != objCol.getPrecision() || col.getScale() != objCol.getScale()) {
                    isModify = "01";
                }
                if (col.isAllowNull() != objCol.isAllowNull()) {
                    if (this.enablePrimaryColumnModify(currTab, col)) {
                        isModify = isModify + "1";
                    } else {
                        this.appendLine(this.constraintScript, String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getName(), col.getName()));
                    }
                } else {
                    isModify = isModify + "0";
                }
                if (col.getColDefault() == null && objCol.getColDefault() != null) {
                    if (this.enablePrimaryColumnModify(currTab, col)) {
                        isModify = isModify + "1";
                    } else {
                        this.appendLine(this.constraintScript, String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getName(), col.getName()));
                    }
                } else if (col.getColDefault() != null && objCol.getColDefault() == null || col.getColDefault() != null && objCol.getColDefault() != null && !col.getColDefault().equals(objCol.getColDefault())) {
                    if (this.enablePrimaryColumnModify(currTab, col)) {
                        isModify = isModify + "1";
                    } else {
                        this.appendLine(this.constraintScript, String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getName(), col.getName()));
                    }
                } else {
                    isModify = isModify + "0";
                }
            }
            if (isModify.length() == 0 || "0000".equals(isModify)) continue;
            this.alterScript.append("EXEC p_AlterColumn '").append(currTableNumber).append("', '").append(col.getNumber().toUpperCase(Locale.ENGLISH)).append("', '").append(col.getDataTypeText()).append("', '").append(isNull).append("', '").append(isModify).append("', '").append(colDef).append("';").append(System.lineSeparator());
            if (!isModify.startsWith("1")) continue;
            this.warnLog.append("\u8b66\u544a\uff1a\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u53ef\u80fd\u9020\u6210\u7a0b\u5e8f\u517c\u5bb9\u9519\u8bef\u3002 \u4e0d\u4e00\u81f4\u7684\u5185\u5bb9\uff1a\u8868'").append(currTab.getNumber()).append("'\u7684\u5b57\u6bb5'").append(objCol.getNumber()).append("'\u539f\u7c7b\u578b'").append(objCol.getDataTypeText()).append("' -> \u65b0\u7c7b\u578b'").append(col.getDataTypeText()).append(System.lineSeparator());
        }
        this.comparePK(currTab, oldTab);
        isDifferent = this.compareIndex(currTab, oldTab);
        if (!addColMap.isEmpty()) {
            isDifferent = true;
            for (Column item : addColMap.values()) {
                this.appendLine(this.alterScript, scriptGenerator.addColumnSql(currTab.getNumber(), item));
            }
        }
        for (Column item : dropColMap.values()) {
            isDifferent = true;
            this.appendLine(this.alterScript, " --- drop column --------- \u4e0d\u5141\u8bb8\u5220\u9664\u8868" + currTab.getName() + "\u7684\u5b57\u6bb5" + item.getName() + "\uff0c\u8bf7\u6062\u590dpdm\u4e2d\u7684\u5b57\u6bb5 ------------------- ");
        }
        return !isDifferent;
    }

    private void comparePK(Table currTab, Table oldTab) throws Exception {
        PrimaryKey currTabPK = currTab.getPrimaryKey();
        PrimaryKey oldTabPK = oldTab.getPrimaryKey();
        if (currTabPK == null) {
            throw new Exception(String.format("\u8868%s\u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\u3002", currTab.getName()));
        }
        if (currTabPK.getNumber() == null || currTabPK.getNumber().isEmpty() || currTabPK.getColNumbers().isEmpty()) {
            if (oldTabPK.getNumber() == null || oldTabPK.getNumber().isEmpty() || oldTabPK.getColNumbers().isEmpty()) {
                this.appendLine(this.warnLog, String.format("\u8b66\u544a\uff1a\u539f\u6a21\u578b\u8868%s\u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\uff0c\u5e94\u5728\u539f\u6a21\u578b\u63d0\u4ea4\u65f6\u68c0\u6d4b\u5e76\u4fee\u6539\uff08\u6b64\u5904\u51fa\u73b0\u8bf4\u660e\u4e0a\u4e2a\u7248\u672c\u672a\u6821\u9a8c\u6216\u672a\u4fee\u6539\uff09\u3002", currTab.getName()));
            } else {
                throw new Exception(String.format("\u8868%s\u7684\u4e3b\u952e\u672a\u547d\u540d\u6216\u4e3b\u952e\u672a\u5b9a\u4e49\u5217\uff0c\u5e94\u5728\u6a21\u578b\u63d0\u4ea4\u65f6\u68c0\u6d4b\uff08\u6b64\u5904\u51fa\u73b0\u8bf4\u660e\u6a21\u578b\u672a\u6821\u9a8c\uff09\u3002", currTab.getName()));
            }
        }
        String colnames = String.join((CharSequence)",", currTabPK.getColNumbers());
        currTabPK.setIgnoreCompareCluster(this.ignoreCompareCluster);
        if (!currTabPK.equals(oldTabPK)) {
            this.appendLine(this.constraintScript, String.format("/*\u8868%s\u7684\u4e3b\u952e\u5217%s\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u5982\u679c\u8be5\u8868\u8fd8\u672a\u53d1\u5e03\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53d8\u66f4\u57fa\u51c6\u6a21\u578b\u91cd\u65b0\u751f\u6210\u8868\u7ed3\u6784\u3002*/", currTab.getName(), colnames));
        }
        logger.debug("table '{}' new pk '{}({})' -> old pk'{}({})'.", new Object[]{currTab.getNumber(), currTabPK.getNumber(), colnames, oldTabPK.getNumber(), String.join((CharSequence)",", oldTabPK.getColNumbers())});
    }

    private boolean compareIndex(Table currTab, Table oldTab) {
        boolean isAlter = false;
        Map<String, Index> dictDropIndexes = this.toIndexDictMap(oldTab.getIndexes());
        ArrayList<Index> listAddIndexes = new ArrayList<Index>(8);
        for (Index idx : currTab.getIndexes()) {
            if (dictDropIndexes.containsKey(idx.getNumber())) {
                Index oldInd = dictDropIndexes.get(idx.getNumber());
                if (!idx.equals(oldInd)) {
                    isAlter = true;
                    this.appendLine(this.constraintScript, String.format("EXEC p_DropIdx '%s', '%s';", idx.getNumber().toUpperCase(Locale.ENGLISH), oldTab.getNumber().toUpperCase(Locale.ENGLISH)));
                    listAddIndexes.add(idx);
                }
                dictDropIndexes.remove(idx.getNumber());
                continue;
            }
            isAlter = true;
            listAddIndexes.add(idx);
        }
        for (Index idx : dictDropIndexes.values()) {
            this.appendLine(this.constraintScript, String.format("EXEC p_DropIdx '%s', '%s';", idx.getNumber().toUpperCase(Locale.ENGLISH), oldTab.getNumber().toUpperCase(Locale.ENGLISH)));
        }
        ScriptGenerator scriptGenerator = ScriptGenerator.createScriptGenerator();
        for (Index idx : listAddIndexes) {
            this.appendLine(this.constraintScript, scriptGenerator.createIndexSql(idx));
        }
        return isAlter;
    }

    private String columnPropertyScript(Column column) {
        String val;
        StringBuilder sb = new StringBuilder();
        sb.append(column.getDataTypeText());
        if (column.getColDefault() != null && (val = column.getColDefault().getValue()) != null && val.length() > 0) {
            sb.append(" DEFAULT ").append(column.getColDefault().getValue());
        }
        if (!column.isAllowNull()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    private Map<String, Column> toColumnDictMap(List<Column> list) {
        HashMap<String, Column> dict = new HashMap<String, Column>(list.size());
        for (Column column : list) {
            dict.put(column.getNumber(), column);
        }
        return dict;
    }

    private Map<String, Index> toIndexDictMap(List<Index> list) {
        HashMap<String, Index> indexMap = new HashMap<String, Index>(list.size());
        for (Index index : list) {
            indexMap.put(index.getNumber(), index);
        }
        return indexMap;
    }

    private boolean enablePrimaryColumnModify(Table currTab, Column col) {
        return !currTab.getPrimaryKey().getColNumbers().contains(col.getName());
    }

    private void reset() {
        this.alterScript = new StringBuilder();
        this.constraintScript = new StringBuilder();
        this.warnLog = new StringBuilder();
        this.infoLog = new StringBuilder();
    }

    private void appendLine(StringBuilder stringBuilder, String str) {
        if (str != null && str.trim().length() > 0) {
            stringBuilder.append(str);
            stringBuilder.append(System.lineSeparator());
        }
    }

    @NotNull
    private String getCurrDateString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date());
    }

    private static Map<String, ModifyPDMObject> getModifyObjectName() throws Exception {
        if (modifyObjectMap == null) {
            modifyObjectMap = new HashMap<String, ModifyPDMObject>();
        }
        return modifyObjectMap;
    }

    static class ModifyPDMObject {
        private String tableNumber;
        private String oldTableNumber;
        private Map<String, String> columns;

        public String getTableNumber() {
            return this.tableNumber;
        }

        public void setTableNumber(String tableNumber) {
            this.tableNumber = tableNumber;
        }

        public String getOldTableNumber() {
            return this.oldTableNumber;
        }

        public void setOldTableNumber(String oldTableNumber) {
            this.oldTableNumber = oldTableNumber;
        }

        public Map<String, String> getColumns() {
            return this.columns;
        }

        public void setColumns(Map<String, String> columns) {
            this.columns = columns;
        }

        ModifyPDMObject(String tableNumber) {
            this.tableNumber = tableNumber;
            this.columns = new HashMap<String, String>(6);
        }

        public boolean IsModifyTableNumber() {
            return !this.tableNumber.equals(this.oldTableNumber);
        }

        public void add(String columnNumber, String oldColumnNumber) {
            this.columns.put(columnNumber, oldColumnNumber);
        }
    }
}

