/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;

public class DecimalColumnIsNullRule
implements ValidateRule<Column> {
    private MessageType messageType;

    @Override
    public void setRuleParameter(Map parameter) {
        String msgType = (String)parameter.get("level");
        this.messageType = "warn".equals(msgType) ? MessageType.Warn : MessageType.Error;
    }

    @Override
    public List<ValidateResultItem> validate(Column column) {
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        if (column.getDataType() == DataType.DECIMAL && column.isAllowNull()) {
            resultList.add(new ValidateResultItem(this.getErrorLevel(column, this.messageType), String.format("%s\u6570\u503c\u578b\u5b57\u6bb5'%s'\u5e94\u5b9a\u4e49\u4e3a\u975e\u7a7a\u3002", column.getTable().getNumber(), column.getNumber())));
        }
        return resultList;
    }

    private MessageType getErrorLevel(Column column, MessageType messageType) {
        if (!column.isModified() && messageType == MessageType.Error) {
            return column.getNoModifiedErrorLevel();
        }
        return messageType;
    }
}

