/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Index;

public class IndexColCountRule
implements ValidateRule<Index> {
    private int colCount = 5;

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object colCountConfigVal = parameter.get("colCount");
        if (colCountConfigVal != null) {
            this.colCount = Integer.parseInt(colCountConfigVal.toString());
        }
    }

    @Override
    public List<ValidateResultItem> validate(Index index) {
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        int idxColCount = index.getColNumbers().size();
        if (idxColCount > this.colCount) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u7d22\u5f15'%s'\u7684\u5b57\u6bb5\u4e2a\u6570\u4e0d\u5e94\u8d85\u8fc7%d\u4e2a\u3002", index.getNumber(), this.colCount)));
        }
        return resultList;
    }
}

