/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.Index;

public class IndexColLengthRule
implements ValidateRule<Index> {
    private int colLength = 255;

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object colCountConfigVal = parameter.get("colLength");
        if (colCountConfigVal != null) {
            this.colLength = Integer.parseInt(colCountConfigVal.toString());
        }
    }

    @Override
    public List<ValidateResultItem> validate(Index index) {
        HashSet<String> cols = new HashSet<String>(index.getColNumbers().size());
        for (String col : index.getColNumbers()) {
            cols.add(col);
        }
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        for (Column col : index.getTable().getColumns()) {
            if (!cols.contains(col.getNumber()) || col.getLength() <= this.colLength) continue;
            resultList.add(new ValidateResultItem(this.getErrorLevel(index, MessageType.Error), String.format("\u957f\u5ea6\u8d85\u8fc7%d\u7684\u5b57\u6bb5'%s'\uff0c\u4e0d\u9002\u5408\u5efa\u7d22\u5f15\uff08'%s'\uff09\u3002", this.colLength, col.getNumber(), index.getNumber())));
        }
        return resultList;
    }

    private MessageType getErrorLevel(Index index, MessageType messageType) {
        if (!index.isModified()) {
            return index.getNoModifiedErrorLevel();
        }
        return messageType;
    }
}

