/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Index;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.datamodel.pdm.model.Table;

public class IndexColReplicateRule
implements ValidateRule<Table> {
    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
    }

    @Override
    public List<ValidateResultItem> validate(Table table) {
        HashMap<String, PDMObject> cols = new HashMap<String, PDMObject>();
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        if (table.getPrimaryKey() != null && table.getPrimaryKey().getColNumbers().size() > 0) {
            cols.put(table.getPrimaryKey().getColNumbers().get(0), table.getPrimaryKey());
        }
        List<Index> indexes = table.getIndexes();
        for (Index idx : indexes) {
            if (idx.getColNumbers().size() <= 0) continue;
            String col = idx.getColNumbers().get(0);
            PDMObject existIndex = (PDMObject)cols.get(col);
            if (existIndex != null) {
                resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u7d22\u5f15'%s'\u5b9a\u4e49\u7684\u5b57\u6bb5'%s'\u4e0e'%s'\u5b9a\u4e49\u7684\u5b57\u6bb5\u76f8\u540c\u3002", idx.getNumber(), col, existIndex.getNumber())));
                continue;
            }
            cols.put(col, existIndex);
        }
        return resultList;
    }
}

