/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Index;

public class IndexNamePrefixRule
implements ValidateRule<Index> {
    private int maxLength = 30;
    private String prefix = "IDX_";

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object prefixVal;
        Object maxLengthConfigVal = parameter.get("maxLength");
        if (maxLengthConfigVal != null) {
            this.maxLength = Integer.parseInt(maxLengthConfigVal.toString());
        }
        if ((prefixVal = parameter.get("prefix")) != null) {
            this.prefix = prefixVal.toString();
        }
    }

    @Override
    public List<ValidateResultItem> validate(Index index) {
        String indexName = index.getNumber();
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        if (indexName.length() > this.maxLength) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u7d22\u5f15\u540d'%s'\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%d\u4f4d\u3002", indexName, this.maxLength)));
        }
        if (!indexName.toUpperCase().startsWith(this.prefix)) {
            resultList.add(new ValidateResultItem(this.getErrorLevel(index, MessageType.Error), String.format("\u7d22\u5f15\u540d'%s'\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u540d\u79f0\u5e94\u4f7f\u7528IDX_\u5f00\u5934\u3002", indexName)));
        }
        return resultList;
    }

    private MessageType getErrorLevel(Index index, MessageType messageType) {
        if (!index.isModified()) {
            return index.getNoModifiedErrorLevel();
        }
        return messageType;
    }
}

