/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.PDMObject;
import kd.bos.ksql.util.StringUtil;

public class PDMIdentifierRule
implements ValidateRule<PDMObject> {
    private static final String[] KEYWORDS = new String[]{"ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CALL", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONNECT", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CURSOR_LOOP", "DATABASE", "DATE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DO", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "EMPTY", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "FALSE", "FAST", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "FUNCTION_NAME", "GIN", "GIN_TRGM_OPS", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITYCOL", "IDENTITY_INSERT", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "KSQL_BLOCK", "KSQL_COLNAME", "KSQL_CONSTNAME", "KSQL_CONSTRAINTS", "KSQL_CURSOR_LOOP", "KSQL_DEFAULT", "KSQL_FETCH", "KSQL_INDEXES", "KSQL_INDNAME", "KSQL_NULLABLE", "KSQL_TABNAME", "KSQL_USERCOLUMNS", "KSQL_USERTABLES", "LABEL", "LEFT", "LIKE", "ILIKE", "LIMIT", "LINENO", "LOAD", "LOOP", "MATCH", "NATIONAL", "NEW", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PRIOR", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SCHINESE_PINYIN", "SCHINESE_RADICAL", "SCHINESE_STROKE", "SELECT", "SESSION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "START", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TIME", "TIMESTAMP", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUE", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT", "XIN", "COMMENT"};
    private final Set<String> keyWordSet = new HashSet<String>(KEYWORDS.length);

    public PDMIdentifierRule() {
        for (int i = 0; i < KEYWORDS.length; ++i) {
            this.keyWordSet.add(KEYWORDS[i]);
        }
    }

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
    }

    @Override
    public List<ValidateResultItem> validate(PDMObject pdmObject) {
        return this.validate(pdmObject.getNumber());
    }

    @Override
    public List<ValidateResultItem> validate(String identifier) {
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        if (StringUtil.isEmpty((String)identifier)) {
            resultList.add(new ValidateResultItem(MessageType.Error, "\u4e0d\u7b26\u5408\u547d\u540d\u89c4\u8303\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
        }
        if (!this.isJavaIdentifier(identifier)) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u547d\u540d'%s'\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u540d\u79f0\u53ea\u80fd\u4ee5\u82f1\u6587\u5b57\u6bcd\u5f00\u5934\uff0c\u7531\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u5e76\u4e14\u4e0d\u80fd\u4f7f\u7528\u4fdd\u7559\u5b57\u3002", identifier)));
        }
        return resultList;
    }

    private boolean isJavaIdentifier(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return false;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i]) && (i != 0 || Character.isJavaIdentifierStart(chars[i]))) continue;
            return false;
        }
        return !this.keyWordSet.contains(s);
    }
}

