/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Column;
import kd.bos.datamodel.pdm.model.DataType;
import kd.bos.datamodel.pdm.model.Table;

public class TableColCountRule
implements ValidateRule<Table> {
    int colCountInTable = 80;

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object colCountConfigVal = parameter.get("colCount");
        if (colCountConfigVal != null) {
            this.colCountInTable = Integer.parseInt(colCountConfigVal.toString());
        }
    }

    @Override
    public List<ValidateResultItem> validate(Table table) {
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        int nvarcharColCount = 0;
        List<Column> cloumns = table.getColumns();
        for (Column item : cloumns) {
            if (item.getDataType() != DataType.NVARCHAR) continue;
            ++nvarcharColCount;
        }
        if (cloumns.size() - nvarcharColCount > this.colCountInTable) {
            resultList.add(new ValidateResultItem(MessageType.Error, "\u8868\u4e0d\u5e94\u8d85\u8fc7" + this.colCountInTable + "\u4e2a\u5b57\u6bb5\u3002table:" + table.getName()));
        }
        return resultList;
    }
}

