/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.datamodel.pdm.validationrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.datamodel.model.validator.MessageType;
import kd.bos.datamodel.model.validator.ValidateResultItem;
import kd.bos.datamodel.model.validator.ValidateRule;
import kd.bos.datamodel.pdm.model.Table;

public class TableIndexCountRule
implements ValidateRule<Table> {
    int indexCount = 8;

    @Override
    public void setRuleParameter(Map<String, Object> parameter) {
        Object maxLengthConfigVal = parameter.get("indexCount");
        if (maxLengthConfigVal != null) {
            this.indexCount = Integer.parseInt(maxLengthConfigVal.toString());
        }
    }

    @Override
    public List<ValidateResultItem> validate(Table table) {
        ArrayList<ValidateResultItem> resultList = new ArrayList<ValidateResultItem>();
        int idxSize = table.getIndexes().size();
        if (idxSize > this.indexCount) {
            resultList.add(new ValidateResultItem(MessageType.Error, String.format("\u8868'%s'\u7d22\u5f15\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u7d22\u5f15\u4e2a\u6570\u4e0d\u5e94\u8d85\u8fc7%d\u4e2a\u3002", table.getNumber(), this.indexCount)));
        }
        return resultList;
    }
}

